.ig
$Header: 05.t,v 1.1 88/05/21 18:39:40 papowell Locked $
$log$
..
.bp
.NH 1
Remote Spool Queue
.PP
Entries in a remote spool queue are transfered to the remote host
by a server process forked by the
.I lpd
daemon.
The server process checks the spool queue for entries
and then initiates communication with the remote host and the 
line printer daemon on the remote end.
The following section discusses the protocol used to transfer files
to the remote hosts.
.NH 2
Establishing Communication
.PP
Interhost job transfer is done by using the Internet (Inet)
interprocess communication facilities.
For an excellent tutorial on this,
see the 4.3BSD Advanced Tutorial On Interprocess Communications.
The client or process that wishes to send files to a remote host
establishes communication using the following procedure.
.IP 1). 3
The client opens an AF_INET socket,
using the SOCK_STREAM protocol.
The socket will use a reliable message delivery method for
communication.
Note that the socket is written to send a message,
read to receive a message.
.IP 2). 3
The client socket is bound to a reserved port on the local host,
that is,
a port on the local host whose port number is less than 1024.
These are reserved ports and can only be bound to by
root processes or a process which
is SUID root.
The server on the remote machine will check to ensure that the
client originated his request from a reserved port.
.IP 3). 3
The client determines the remote host addressing information using the
.IR gethostbynam (3)
facility.
This returns the network address of the remote host.
.IP 4). 3
The client determines the port number that the remote
.I lpd
server is listening on by using the
.IR getservent (3)
facility;
for example,
.L getservent("printer","tcp")
will return the port number and other needed information.
.IP 5). 3
Using the above information,
the client process will use
.IR connect (2)
to establish a connection to the remote host.
If the connect call fails,
then the client may retry a couple of times until successful,
or terminate with an error condition.
.NH 2
Sending Requests
.PP
After establishing connection with the remote host,
the
.I lpd
daemon will fork a server process to deal with the request.
The format of the requests is specified in
Table 1.1.
Requests consist of a simple message consisting of a flag
(unsigned character value) followed by a string terminated with a
new line character.
For example,
the request to transfer files to the remote host consists of a line of the
form:
.ti +5n
\&^Bprinter
.PP
The remote server process uses network supplied information to
determine the name of the client host machine,
and the port that originated the message.
It will check the local
printer permissions file to determine if the host is allowed to access
the specified printer spool queue.
After checking this basic permission,
the remote host will then perform any requested actions.
.NH 2
File Transfers
.PP
A job is transferred between the local and remote hosts by using one
of two methods.
The first method is to send the data files of a job first,
followed by the control file (Berkeley Protocol);
the second method is to send the control file,
followed by the data files (PLP Protocol).
The
.B fj
flag is used to select the PLP (control file first) protocol to be used
in sending jobs.
The default protocol is the Berkeley (data files first) protocol.
.PP
The file transfer protocol consists of sending a line identifying
the type of protocol being used,
the size of the file (in bytes),
and the name of the file.
The remote host will return a single
0 (zero)
confirmation byte if it agrees to accept the file;
any other value is a fatal error.
After confirmation,
the file is transferred to the other end,
followed by a single
0 (zero) byte.
If the remote end receives the file and the terminating 0 byte,
it will return a confirming
0 (zero) byte.
The next file may then be transferred.
After all files have been transferred,
a single
0 (zero) byte will terminate the file transfer.
.PP
The file transferred to the remote site will be placed in the
remote site spool queue directory,
with the same path name it had at the local site.
Both the local and remote sites will lock any files being
transfered in order to prevent other PLP processes from
manipulating them.
Table 5.1 specifies the values of the flags used in the protocol.
.KF
.TS
tab(:) box center;
l | l | l.
Protocol:Flag:Meaning
_
Berkeley:2 (^B):control file
Both:3 (^C):data file
PLP:4 (^D):control file
PLP:5 (^E):last file
.TE
.ce
Table 5.1. File Transfer Protocol Flags
.KE
.PP
To use the Berkeley Protocol,
the data files would be transferred first using the 3 (^B) flag,
followed by the control file using the 2 (^C) flag.
To use the PLP Protocol,
the control file would be transferred first
using the 4 (^D) flag,
followed by the data files.
When all of the data files had been transferred,
a confirming message would be sent using the 5 (^E) flag,
indicating that the job had been transferred.
.PP
For example,
assume that we have a job with a control file
.L cfA123attila.cs.umn.edu ,
and a data file
.L dfA123attila.cs.umn.edu .
Using the Berkeley Protocol,
the client would first send the message
.ti +5n
.L "^C1293 dfA123attila.cs.umn.edu" ,
.br
requesting transfer of a 1293 byte data file,
whose name is
.L dfA123attila .
After confirmation,
the data file followed by a single 0 byte would be sent,
and a confirmation should be received.
Next,
the message
.L "^B343 cfA123attila.cs.umn.edu" ,
would be sent,
and then the control file followed by a single 0 byte would be sent.
Having received the control file,
the remote end would acknowledge the reception of the job,
allowing the client to delete the job and send another one.
When control file is transferred,
the remote host will check the job to make sure that all data files have
been transferred,
and enable it for printing or further processing.
If anything happens to disturb this communication,
the connection is terminated and any partially transferred jobs are
removed.
.PP
To prevent interaction between an unspooler server and a file
transfer server,
the job control file is locked by the file transfer server until it
has been completely transferred.
.NH 2
Error Recovery and Retry
.PP
When either end of the file transfer protocol detects an error,
they will shut down the link.
It is the responsibility of the client process to retry sending jobs.
.NH 2
Security Checks and Authorizations
.PP
The PLP file transfer protocol restricts the names of control and
data files to a fixed format.
In addition,
the
.B U
(unlink) flag has no effect on a remote host.
The enforcement of the fixed format of data and control file names
makes it simple to remove all files associated with a job on
completion.
.PP
Before placing a job in the spool queue,
the user name and hostname are checked to see if permissions are
acceptible.
The security of this check is based on the assumption that the client
host is a trusted originator of PLP jobs.
In a networked environment with many different users,
this may not be the case,
as it is possible to forge information in a control file.
The
.B fd
(no forward)
flag in a printcap entry prevents the acceptance of jobs from other than
the current client.
This is intended to prevent clients from attempting to transfer control
files that would appear to have originated from another
host.
While this will provide verification at the host level,
assuming that network level software will uniquely identify a host,
it still does not provide a secure user identification.
