.ig
$Header: 04.t,v 1.1 88/05/21 18:39:37 papowell Locked $
$log$
..
.NH 1
Printcap and PLP Operations
.PP
The entries in the printcap file are used to define and control
the actions of the PLP software.
Each host machine must have a printcap file that is used to specify
the spool queues that are available on the host.
Permissions to use a particular spool queue are determined by the
printer permissions file.
The following chapter discusses the structure of the printcap file,
and the purpose of entries in the printcap file.
.NH 2
Printcap Format
.PP
The printcap file format is a simplified form of the
.IR termcap (5)
data base.
Each spool queue has a corresponding printcap entry.
Each entry for a spool queue with multiple servers also has a printcap entry.
Figure 4.1 is an example of a typical printcap entry.
.KF
.DT
.in +1i
.L
.SM
.nf
#	Default line printer is first in printcap entry
#   Clunker Printer in Lind 23
clunker_lind23|clunker:\e
	:lp=/dev/lp:\e
	:st=\et\er\e015:\e
	:mx#20:\e
	:wt:fl@:
.LG
.in -1i
.R
.ce
Figure 4.1  Sample Printcap Entry
.KE
.IP 1). 3
Blank lines and lines which start with a
.L #
are treated as comments and can be used to separate entries.
.IP 2). 3
Each entry starts in column 1,
and is continued across multiple lines by escaping the end of line with a
backslash (\c
.BR \e ).
Fields of the entry are separated by colons (\c
.BR : ).
.IP 3). 3
The first field of an entry is the entry name followed by a
an optional list of aliases.
The entry name and aliases are separated by a bars (\c
.BR | ).
.IP 4). 3
Parameter fields start with a two letter parameter name,
followed by a flag indicating the parameter type.
Parameters can be strings,
integers,
or flags.
String parameters have the form
.L xx=ssss 
(\c
.L ssss
is the string assigned to the parameter),
integer parameters have the form
.L xx#nnnn ,
and flag or boolean parameters use
.L xx
to set
.L xx@
to clear the flag.
.IP 5). 3
Non-printing characters can be represented in a string by using
the character escape sequences of the C programming language.
.IP 6). 3
See the
.IR printcap \|(5)
man page for a complete list of printcap variables and their default values.
.PP
Each entry in the printcap file specifies either a remote spool queue,
a local spool queue with a single printer,
a local spool queue with multiple printers,
or a printer for a spool queue with multiple printers.
The information in the printcap entry determines the type of entry and
how the entries in the spool queue are to be handled.
.PP
The PLP software searches the printcap file for a printcap entry with
a matching printer name or alias.
By convention,
if a user does not specify a printer,
either by using a command line option or setting the
.B PRINTER
environment variable,
the first printer in the printcap file is used as the default printer.
.NH 2
Spool Queue Directory
.PP
The
.B sd
(spool directory) field specifies the path name of the directory
which will hold spool queue entries or jobs.
The
.B sd
parameter must be present for all printcap entries which are
used for spooling.
Figure 4.2  is a typical printcap entry for
a remote printer spool queue,
whose spool directory is specified as
.L /usr/spool/lind33_decwriter .
.KF
.nf
.in +1i
.DT
.L
.SM
# Decwriter III in Lind 33
# Modified 11 Feb. 1988 Patrick Powell - added fx=n for ditroff
# queue printer permissions file
# maximum job size 2000K bytes, no copies
remote\||\|lind33_decwriter:\e
	:fx=ilpn:\e
	:sd=/usr/spool/lind33_decwriter:\e
	:rm=umn-cs.cs.umn.edu:rp=lind33_decrwriter:\e
	:xu=perms:\e
	:ex=n:ne=/usr/local/lib/ddumb:\e
	:mx#2000:sc:
.LG
.R
.in -1i
.ce
Figure 4.2  Remote Printer Printcap Entry
.KE
.NH 2
Job Submission Controls
.PP
The following fields are used to control job submission.
.NH 3
Job Formats
.PP
Each job in a spool queue has an associated format,
which is represented by a lower case letter\**.
.FS
Actually,
each file in the job can have a different format,
but the current version of
.I lpr
does not support this.
.FE
There are several
.I lpr
options such as 
.B -n,
.B -d,
etc. which can be used to specify a limited set of formats,
or the
.B \-Fx
option can be used to specify any format.
For example,
the
.B \-Fn
options specifies printing using the
.B n
format,
as below.
.ti +.5i
.L "ditroff -Tdumb -ms myfile | lpr -Fn -Premote"
.PP
The format supported by a spool queue can be restricted by the
.B fx
printcap field,
which specifies the formats supported by the spool queue.
In Figure 4.2,
the
.B fx=ilpn
field restricts formats to
.L i,
.L l,
.L p,
and
.L n .
Some formats require that files be printable
(i.e.- contain characters in the ASCII characters set,
or other restrictions).
By default,
only the
.L f
and
.L p
formats are checked by
.I lpr
for printable files.
The
.B xt
field is used to specify additional formats to be checked for printable files.
.NH 3
Permissions Files
.PP
Each host has a
printer permissions file which is checked by the
PLP software to determine if actions requested by users or other hosts
are permitted.
In addition,
the
.B xu
(check user) printcap
field is used to specify an additional printer permission
file which is checked for jobs in the spool queue.
For example,
the
.B xu=perms
field causes the
.L perms
file in the spool directory to be checked by
.I lpr
when  the job is submitted.
Similarly,
the unspooling server process will also check this file
when the job is finally printed.
.NH 3
Prefilters
.PP
It may be desirable to process or filter a job at the time that it is
spooled.
The program used to filter a job is specified by a field of the form
.BR X e=filtername ,
or
.BR X e=filtername,y ,
where
.L X
is the original format,
filtername is the pathname of a program,
and
.L y
is the result format.
The default result format is
.L f .
In addition,
the
.I lpr
.B -p
option specifies filtering with the
.I pr
program;
.I lpr
invokes the program specified by the
.BR pr= filtername
(default is
.L /bin/pr ).
.NH 3
Job Size and Number of Copies
.PP
The
.B mx
(maximum size)
field is used to specify a maximum file size (in 1 Kbyte blocks)
that can be spooled by
.I lpr.
Jobs whose total size (including duplicates) exceeds this limit are
not spooled.
For example,
the
.B mx#2000
entry restricts jobs to a maximum of 2000 Kbytes.
The
.B mc
(maximum copies) value specifies the maximum number of copies allowed
and the
.B sc
(suppress copies) flag which suppresses multiple copies.
.NH 2
Remote Printer Spool Queues
.PP
Remote spool queues specify the remote host using the
.B rm
field and the remote printer using the
.B rp
field.
The remote host addressing information is obtained using the
.IR gethostbynam (3R)
facility.
The remote printer must appear in the remote host's
printcap data base.
The following is an example of an entry for a remote spool queue
that will be sent to host
.L umn-cs.cs.umn.edu ,
and printed on the
.L lind33_decwriter
printer.
.NH 2
Local Printer Queues
.PP
Unspooling from a local printer queue can be done in two manners:
using the unspooling cababilies of the PLP server created for the
queue by the lpd,
or by having the server process invoke a special
.I "queue handler"
process.
The latter method is discussed later in this section.
.PP
Associated with each local queue is an output device.
These can be categorized as serial line
or a specialized device with a non-serial interface.
If a device is attached to a serial,
the printcap can be used to specify how the serial line
is to be conditioned in order to communicate with the printer.
Figure 4.3 is a sample printcap entry for a DecWriter III printer connected
over a 1200 baud serial line.
.KF
.DT
.in +1i
.L
.nf
.SM
# Local Printer Entry
# Decwriter III in Lind 33
# Modified 11 Feb. 1988 Patrick Powell - added fx=n for ditroff, max 2 retries
lind33_decwriter\||\|clunker\||\|Decwriter Model 3:\e
	:fx=ilpn:\e
	:sd=/usr/spool/lind33_decwriter:\e
	:xu=/usr/adm/perms/lind33_decwriter:\e
	:rt=2:\e
	:ne=/usr/local/lib/ddumb:\e
	:lp=/dev/ttyh8:rw:\e
	:br#1200:fs#06320:ty=-nl odd even -tabs tandem new:\e
	:lf=error:
.LG
.in -1i
.R
.ce
Figure 4.3 Printcap Entry for Serial Line Device
.LG
.KE
.NH 3
Output Device Pathname
.PP
The
.B lp
(line printer) parameter specifies a path name of the device that is
to be opened and output sent to.
The device is opened for writing only (default),
or reading and writing if the
.B rw
flag is  present.
Note that there is no default value for the
.B lp
field.
If there is no physical device corresponding to the printer,
then
.L "lp=/dev/null"
should be used to specify a null device.
.NH 3
Retry Limits
.PP
The server will attempt to unspool and print a job for a limited number
of times.
The number of attempts is set by the
.B rt
(retry) parameter;
the default value is 3,
and a \-1 value specifies unlimited retries.
.NH 3
Serial Line Characteristics
.PP
Printers connected via a serial communication line
must have the proper baud rate and line characteristics set.
.IP "Setting Bit (Baud) Rates" 3
The
.B br
parameter sets the bit (baud) rate for the tty line.
For example,
300 means 300 BPI,
9600 means 9600 BPI.
.IP "Setting Line Characteristics" 3
The
.B fs
(set bits) and
.B fc
(clear bits) parameter is used to set the serial line characteristics with the
TIOCSETP
.IR ioctl \|(2)
operation.
The
.B fs
and
.B fc
set and clear bits in the line control status word returned by the
TIOGSETP ioctl operation,
which is then restored with the ioctl TIOCSETP.
In the above example,
.B fs
sets CRMOD,
no parity,
and XTABS (see
.IR tty \|(4)
for details).
The
.B xs
and
.B xc
are be used to set and clear local control  information
using the TIOCCLGET and TIOCCLSET ioctl calls.
.IP "Alternate Method" 3
In case you find the
.B fs ,
.B fc ,
etc.,
method of setting line characteristics embarassingly user-hostile,
you can use the
.B ty
(stty) parameter,
which uses (almost) the same keywords and options as the
.I stty (1)
command.
For example,
.L "ty=nl -odd -even -tabs" 
can be used instead of the above
.B fs
values.
If you need tandem line control you
may have to open the output device for reading and writing using the
.B rw
field;
this appears to be implementation dependent.
The following 
.I stty
options are recognized by the
.L ty
field and have the same meaning as the
.I stty
command as supplied for 4.3 UNIX,
with some local modifications added from SUN Microsystems UNIX.
.DS
.DT
.nf
.L
.SM
.ta 16n +16n +16n +16n +16n +16n +16n +16n +16n 8i
bs0	bs1	[-]cbreak	cooked	cr0	
cr1	cr2	cr3	[-]decctlq	[-]echo	
[-]even	ff0	ff1	[-]lcase	[-]litout	
nl0	nl1	nl2	nl3	[-]nl	
[-]noflsh	new	[-]nohang	old	[-]odd	
[-]raw	start	stop	tab0	tab1	
tab2	[-]tabs	[-]tandem	tek	ti700	
[-]tilde	tn300	tty33	tty37	vt05	
.DE
.NH 2
Job, Log, Lock, and Status Files
.PP
The pathnames for all files associated with a spool queue are
relative to the spool queue directory or are absolute paths.
The following sections discuss the various files that are used
for logging and status reporting.
.NH 3
Job Files
.PP
A job consists of a control file and a set of data files.
Lines in the control file provide information about the user,
the originating hosts,
and the names of the data files,
and the data file unspooling formats.
A job control file name has the form:
.ti +5n
.B cf
.L "[Priority \- A-Z]"
.L "[Job Number \- 000-999]"
.L "[Host Name]"
.br
.ti +5n
.nf
Example:   cfA002attila.cs.umn.edu
.fi
.PP
The first two letters identify the file as a control file,
the next letter is the job's priority level,
the next 3 digits are the job number,
and the trailing characters are the host name.
.PP
The priority level is set by the LPR process at the time that the job is
submitted;
the
.I lpc
program can be used to upgrade a job's priority.
The sequence number is obtained from a sequence file,
which is locked when in use by
.I lpr
in order to avoid duplicate sequence file names.
Each host has a unique sequence file,
and the combination of host and sequence number should be unique.
This is true as long as there are less than 1000 jobs outstanding in
a queue.
The host name currently used in the PLP software is currently set to be the
network host name,
as returned by
.IR gethostnam (3n).
.PP
The data files associated with a job have files names with a similar form,
as follows:
.ti +5n
.B df
.I [Sequence]
.I [Job Number]
.I [Host]
.br
.ti +5n
.nf
Example:  dfA002attila.cs.umn.edu, dfB002attila.cs.umn.edu
.fi
.PP
The PLP software checks to ensure that control file and data file
names have the same corresponding form.
.NH 3
Control File
.PP
A control file contains the information neccessary to print a job.
Figure 4.4 is a typical control file for a job.
.KF
.DT
.L
.SM
.nf
.in +1i
Hattila.cs.umn.edu
LPatrick Powell,L136
Ppapowell
N(stdin)
J(stdin)
CZ
fdfA001attila
UdfA001attila
.in -1i
.LG
.R
.ce
Figure 4.4. Job Control File Example
.KE
.PP
The first character on each line is a flag character
used to decode the remainder of the line.
Upper case flags provide information or pass options for the
printing actions.
Lower  case characters are format indicators for specified data files.
Note that there is a maximum limit on the size of each line of a
control file.
Table 4.1 lists the various control flags that are used
in the control file.
.KS
.L
.SM
.TS
tab(:) box center;
l |l |l.
Flag:Parameter:Meaning
_
C:class name:banner page
H:host name:originating host
I:indent:amount to indent output
J:job name:banner page
L:user name:name to print on banner
M:mail:mail to user when done printing
N:name:name of file in job
P:Person:user's login name
S:flag:no header request
R:account:accounting information
U:file name:remove file after we print it
W:width:page width for PR
X:header:header title for PR
Z:extra options:options for filters from lpr
f:file name:ordinary file
l:file name:text file with control chars
p:file name:text file to print with pr(1)
t:file name:troff(1) file
n:file name:ditroff(1) file
d:file name:dvi file
g:file name:plot(1G) file
v:file name:plain raster file
c:file name:cifplot file
.TE
.LG
.R
.ce
Table 4.1. Control File Flags
.KE
.NH 3
Log File
.PP
The spool queue server process writes error and informational messages to 
the server log file,
which is specified by the
.B lf
field;
the default log file is
.IR log .
If the log file does not exist,
then a dummy log file (/dev/null) is opened for logging purposes.
Serious error message are written both to the log file and
logged using the
.IR syslog (8)
facility if it is available,
or to
.L /dev/console
if it is not.
.NH 3
Lock File
.PP
The spool queue lock file
is used to control spooling and unspooling  operations.
The lock file name is specified using the
.B lo
(lock file)
field,
and the default lock file name is
.IR lock .
.NH 3
Status Files
.PP
The server status file
(default file is
.IR status )
contains status information reflecting the operations of the unspooling
server processes.
The
.B st
(status) field can be used to specify an explicity name for the status file.
An additional printer status file can be specified with the
.B ps
field.
This file can be used by filter programs that generated additional status
information that should be available for display.
.NH 2
Multiple Servers
.PP
If a spool queue has multiple printers or servers,
the server names are specified by the 
.B sv
(servers) parameter,
which contains a comma separated list of server names.
Each server name has a printcap entry,
and each server entry has a corresponding
.B ss
(serves) field
which contains the name of the spool queue served by the printer.
Each printer will use the spool queue directory specified by the
.B sd
field of the spool queue that it serves.
Note that this name corresponds to the name of the queue,
not the spool directory.
.KF
.in +1i
.DT
.L
.SM
.nf
# Multiple servers
fast:\e
	:sd=/usr/spool/fast:\e
	:sv=lp1,lp2:
lp1:\e
	:ss=fast:\e
	:lo=lp1:lf=log1:st=st1:lp=/dev/lp1:
lp2:\e
	:ss=fast:\e
	:lo=lp2:lf=log2:st=st2:lp=/dev/lp2:
.LG
.R
.in -1i
.ce
Figure 4.5  Multiple Server Printcap Entry
.KE
.PP
In the example in Figure 4.5,
the
.L lp1
and
.L lp2
printers are used to serve the
.L fast
spool queue.
Note that each of them explicitly specified the name of their lock and
log files;
as they will use the same queue directory the names of the lock,
log,
and status files must be different.
