.ig
$Header: 01.t,v 1.1 88/05/21 18:39:31 papowell Locked $
$log$
..
.NH 1
Overview
.PP
The Public Line Printer Spooler (PLP) software is a
reverse engineered version of the Berkeley Line Printer Spooler (LPD).
During the implementation,
there was no resort to any of the Berkeley LPD source,
other than for tables that are used to print big letter banners\**.
.FS
The author has seen these appear in several public domain games programs,
and has recollections of running card decks which produced
suspiciously similar output.
.FE
Due to experience with the Berkeley software,
some LPD routines and functionality may be duplicated,
but in general the implementation and structure of the PLP software is
radically different.
.PP
The Public Line Printer Spooler supports:
.IP 1). 3
Multiple printers,
one or more per spooling queue.
.IP 2). 3
Multiple prioritized spooling queues.
.IP 3). 3
Both local and remote printers.
.IP 4). 3
Printers attached via serial lines,
which can have line characteristics such as baud rate,
parity,
etc., specified.
.IP 5). 3
Devices such as an Imagen laser printer which may
require a special communications protocol for printing.
.IP 6). 3
Operation in a shared file system environment (such as NFS).
.IP 7). 3
Restriction of use by a printer permissions data base.
In addition to a per-host database,
each individual spool queue may have a supplementary database.
.PP
The major components of line printer system are the
following files and commands in Table 1.1.
.TS
center box;
l | l | l.
Name	Type	Purpose
_
/??/printcap.<host>	file	printer configuration and capability data base
/??/printer_perms.<host>	file	printer permissions data base
/??/log.<host>	file	daemon log file
/??/lock.<host>	file	daemon lock
/usr/lib/lpd	daemon	line printer daemon
/usr/local/bin/lpr	command	enter a job in a printer queue
/usr/local/bin/lpq	command	examine queues
/usr/local/bin/lprm	command	delete jobs from a queue
/usr/local/bin/lpc	command	administer printers and spooling queues
printer,tcp	port	inet service port on which lpd listens
.TE
.ce
Table 1.1 Major PLP Components
.PP
The
.L /??/printcap.<host>
file
is a master data base describing
characteristics of line printers either directly attached to the host
or accessible across a network.
In the Berkeley LPD software,
the printcap file was
.L /etc/printcap .
While this convention is easy to use in a single host or loosely
coupled multiple processor environment,
it has proven to be difficult to manage and apply in a networked based
file system such as NFS.
In order to provide an easier management of the PLP software,
the
.L printcap ,
.L printer_perms ,
.L log ,
and
.L lock
files have the form:
.L /usr/spool/lpd/<file>.<host> ,
where
.L <host>
is the network level form of the host name.
Note that this allows a single  spool directory to be made available to
all the systems using an NFS file system.
Note that all files in the spool directory are created using the
.L daemon
user ID and group ID,
avoiding problems with NFS systems and root userids.
.PP
The format of the printcap database is based on the
.IR termcap (5)
format.
.PP
The
.L printer_perms
or printer permissions file is used by PLP software to
determine what operations,
queues,
and services can be accesssed by users.
It also determines the spool queues accessible by users from remote hosts,
as well as determining.
The printer permissions file is similar in purpose to the
.I host.equiv
file that is used by
.I rshd .
.PP
The
.L lpd
program is a
.I daemon
or server program that carries out actions as requested by other programs.
The
.L lpr
program creates print jobs in the appropriate spool queue,
and then requests the
.L lpd
daemon to perform unspooling actions.
The
.L lpq
program is used to print the status of local and remote spool queues.
The
.L lprm
program is used to remove jobs from spool queues,
and the
.L lpc
program is used to control spooling and unspooling activities.
.PP
Communication between the
.L lpd
daemon and the utility programs is done using the Internet TCP/IP
communications support provided by most UNIX systems.
Each host has an
.L lpd
daemon which listens on a well known port of the host,
and carries out requested activities.
.PP
The remainder of this document provides details of the structure and
implementation of the above facilities and programs.
Section 2 describes the functionality of the
.L lpd
daemon and  the 
.L "lpr" ,
.L "lpq" ,
.L "lprm" ,
and
.L "lpc"
programs.
Section 3 describes the structure of the spool directory associated
with each spool queue,
and the security precautions taken to ensure the integrity of the
the spool directory and print jobs.
Section 4 is a description of the
.I printcap
data base,
and how the information in the database
is used by the PLP software to perform spooling operations.
Section 5 is a description of the inter-host file transfer protocol used
by PLP.
Section 6 is a description of the unspooling operations carried out by the
.I lpd
program,
and how they are controlled by the printcap information.
Section 7 details how filter programs are invoked by the spool server
processes and how they are specified in the printcap.
Section 8 describes how PLP can be used in a networked file system
environment.
Section 9 outlines how the
.I lpc
program is used to control spooling operations.
Section 10 is a discussion of some diagnositic information supplied by
the PLP programs.
Section 11 is an outline of the installation and test procedures for
PLP.
Section 12 is a summary of differences between the Berkeley LPR
software and PLP.
