/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 ***************************************************************************
 * MODULE: Setup_filter.c
 ***************************************************************************
 * Revision History: Created Sat Jan  9 16:57:59 CST 1988
 * $Log:	setup_filter.c,v $
 * Revision 3.1  88/06/18  09:35:45  papowell
 * Version 3.0- Distributed Sat Jun 18 1988
 * 
 * Revision 2.1  88/05/09  10:10:24  papowell
 * PLP: Released Version
 * 
 * Revision 1.1  88/03/01  11:09:19  papowell
 * Initial revision
 * 
 ***************************************************************************/
#ifndef lint
static char id_str1[] =
	"$Header: setup_filter.c,v 3.1 88/06/18 09:35:45 papowell Exp $ PLP Copyright 1988 Patrick Powell";
#endif lint

/**********************************************************************
 *Setup_filter(int format; char *filtername )
 * create the command line to invoke a filter
 *  format: the format type of the data the filter will be invoked with
 *           (a single (char) letter identifies the type).
 *  filtername: an string containing the filter Name and arguments
 *  prog: address of a pointer which will be set to the program Name
 *
 * Actions:
 *  creates a string which contains the command to invoke a filter.
 *  The command be of the form:
 *  filtername arguments \   <- from filtername
 *      -PPrinter -wwidth -llength -xwidth -ylength [-c] [-iindent] \
 *		[-Zoptions] [-Cclass] [-Jjob] [-Raccntname] -nlogin -hHost
 *      -Fformat [affile]
 *  The 'o' (of filter) only gets the -w, -l, -x, -y and -F options
 **********************************************************************/

#include "lp.h"
char *add_stropt(), *add_numopt(), *add_chropt();

char *
Setup_filter(format, filtername)
	int format;
	char *filtername;
{
	static char cmd[BUFSIZ];	/* the command buffer */
	char *bp, *ep;		/* buffer pointer and general purpose pointer */

	if (!filtername || !*filtername) {
		log(XLOG_INFO,"format %c has no filter",format);
		return ( (char *)0 );
	}

	/* set up end of buffer pointer for error detection */
	ep = cmd + sizeof(cmd);

	/* First copy the filter progname and its fixed args */

	bp = estrcp( cmd, filtername, ep );
	bp = add_stropt(bp,ep," -P",Printer);
	if( PWIDTH[0] == 0 ){
		(void)sprintf( PWIDTH, "%d", PW );
	}
	bp = add_stropt(bp,ep," -w",PWIDTH);
	bp = add_numopt(bp,ep," -l",PL);
	bp = add_numopt(bp,ep," -x",PX);
	bp = add_numopt(bp,ep," -y",PY);

	if (format == 'o') {	/* of format */
		bp = add_chropt(bp,ep," -F",format);
		if( bp == 0 ){
			log( XLOG_INFO, "filter command too long '%s'", cmd );
			return( 0 );
		}
		return(cmd);
	}

	/*
	 * -PPrinter -wwidth -llength -xwidth -ylength [-c] [-iindent] \
	 *  [-Zoptions] [-Cclass] [-Jjob] -nlogin -hHost -Fformat [affile]
	 */
	if (format == 'l'){	/* add literal flag */
		bp = add_stropt( bp,ep, " -c", "" );
	}
	if( INDENT[0] ){
		bp = add_stropt(bp,ep," -i",INDENT);
	}
	if( ZOPTS[0] ){
		bp = add_stropt(bp,ep," -Z",ZOPTS);
	}
	if( ACCNTNAME[0] ){
		bp = add_stropt(bp,ep," -R",ACCNTNAME);
	}
	if( CLASSNAME[0] ){
		bp = add_stropt(bp,ep," -C",CLASSNAME);
	}
	if( JOBNAME[0] ){
		bp = add_stropt(bp,ep," -J",JOBNAME);
	}
	bp = add_stropt(bp,ep," -n",LOGNAME);
	bp = add_stropt(bp,ep," -h",FROMHOST);
	/*
	 * accounting_filename
	 */
	bp = add_chropt(bp,ep," -F",format);
	if( AF && *AF ){
		bp = add_stropt(bp,ep," ",AF);
	}
	if( bp == 0 ){
		log( XLOG_INFO, "filter command too long '%s'", cmd );
	}
	return(cmd);
}


static char *
add_stropt( s, e, s1, s2 )
	char *s, *e, *s1, *s2;
{
	s = estrcp( s, s1, e );
	s = estrcp( s, s2, e );
	return( s );
}

static char *
add_numopt( s, e, s1, n )
	char *s, *e, *s1;
	int n;
{
	char b[10];
	(void)sprintf(b, "%d", n);
	s = estrcp( s, s1, e );
	s = estrcp( s, b, e );
	return( s );
}

static char *
add_chropt( s, e, s1, n )
	char *s, *e, *s1;
	int n;
{
	char b[2];
	b[0]=n; b[1] = 0;
	s = estrcp( s, s1, e );
	s = estrcp( s, b, e );
	return( s );
}
