/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 ***************************************************************************
 * MODULE: Remote_ops.c
 * intiate remote operations from the local machine
 ***************************************************************************
 * Revision History: Created Sun Jan 17 19:55:38 CST 1988
 * $Log:	remote_ops.c,v $
 * Revision 3.3  88/07/06  17:32:41  papowell
 * Added retry for status connection.  Sigh.
 * 
 * Revision 3.2  88/06/24  17:55:38  papowell
 * MODS for VAX 4.3BSD UNIX
 * 
 * Revision 3.1  88/06/18  09:35:29  papowell
 * Version 3.0- Distributed Sat Jun 18 1988
 * 
 * Revision 2.1  88/05/09  10:10:01  papowell
 * PLP: Released Version
 * 
 * Revision 1.4  88/04/06  12:12:58  papowell
 * Minor updates, changes in error message formats.
 * Elimination of the AF_UNIX connections, use AF_INET only.
 * Better error messages.
 * 
 * Revision 1.3  88/03/25  15:01:23  papowell
 * Debugged Version:
 * 1. Added the PLP control file first transfer
 * 2. Checks for MX during file transfers
 * 3. Found and fixed a mysterious bug involving the SYSLOG facilities;
 * 	apparently they open files and then assume that they will stay
 * 	open.
 * 4. Made sure that stdin, stdout, stderr was available at all times.
 * 
 * Revision 1.2  88/03/11  19:27:55  papowell
 * Minor Changes, Updates
 * 
 * Revision 1.1  88/03/01  11:09:08  papowell
 * Initial revision
 * 
 ***************************************************************************/
#ifndef lint
static char id_str1[] =
	"$Header: remote_ops.c,v 3.3 88/07/06 17:32:41 papowell Locked $ PLP Copyright 1988 Patrick Powell";
#endif lint

#include "lp.h"

/***************************************************************************
 * Remote_status()
 * get the status from the remote Host RM for Printer RP
 ***************************************************************************/
Remote_status()
{
	char buf[BUFSIZ];

	if( RP == 0 || *RP == 0 ){
		fatal(XLOG_INFO, "no RP specified for RM (%s)", RM );
	}
	(void)sprintf( buf, "%c%s\n",  Short_format? REQ_DSHORT : REQ_DLONG,RP);
	if(Debug>3)log(XLOG_DEBUG,"Remote_status: %s, '%d'%s",RM,buf[0],buf+1);
	if( JSUCC == Link_line( 3, buf )){
		if(Debug>4)log(XLOG_DEBUG,"request sent");
		Link_get();
	} else {
		(void)fprintf( stdout, "Remote connect to '%s' (%s) failed: %s\n",
			RP, RM, Errormsg(errno));
	}
	Link_close();
}

/***************************************************************************
 * Remote_remove()
 * send a remote remove request to the remote Host
 ***************************************************************************/
Remote_remove( )
{
	char buf[BUFSIZ];		/* holds command */
	char *bp, *ep;			/* ACME Pointers, Inc. */
	int i;					/* ACME Integers, Inc. */
	static char *xsp = " ";	/* needs a space */

	/*
	 * set up the remote command format:
	 * <REQ_REMOVE>Printer Person [Parms]
	 */
	bp = buf; ep = buf+sizeof(buf);
	*bp++ = REQ_REMOVE;
	if( RP == 0 || *RP == 0 ){
		fatal( XLOG_INFO, "no RP specified for RM %s", RM );
	}
	bp = estrcp( bp, RP, ep );
	bp = estrcp( bp, xsp, ep );
	bp = estrcp( bp, Person, ep );
	for( i = 0; i < Parmcount; ++i ){
		bp = estrcp( bp, xsp, ep );
		bp = estrcp( bp, Parms[i].str, ep );
	}
	bp = estrcp( bp, "\n", ep );
	/*
	 * check command line for length
	 */
	if( bp == 0 ){
		fatal( XLOG_INFO, "Remote_remove: command line too long '%s'");
	}
	/*
	 * send command
	 */
	if(Debug>3)log(XLOG_DEBUG,"Remote_remove: %s, '%d'%s",RM,buf[0],buf+1);
	if( JSUCC == Link_line( 3, buf )){
		if(Debug>3)log(XLOG_DEBUG,"request sent");
		Link_get();
	}
	Link_close();
}

/***************************************************************************
 * Remote_control(cmd)
 * send the remote command to the printer
 * This has the form: \006person command RP
 ***************************************************************************/
Remote_control(cmd)
	char *cmd;
{
	char buf[BUFSIZ];

	if( RP == 0 || *RP == 0 ){
		fatal(XLOG_INFO, "no RP specified for RM (%s)", RM );
	}
	(void)sprintf( buf, "%c%s %s %s\n",  REQ_CONTROL,Person,cmd,RP);
	if(Debug>3)log(XLOG_DEBUG,"Remote_control:%s '%d%'%s'",RM,buf[0],buf+1);
	if( JSUCC == Link_line( 3, buf )){
		if(Debug>4)log(XLOG_DEBUG,"request sent");
		Link_get();
	} else {
		(void)fprintf( stdout, "Remote connect to '%s' (%s) failed: %s\n",
			RP, RM, Errormsg(errno));
	}
	Link_close();
}

/***************************************************************************
 * Remote_start()
 * start the remote printer
 ***************************************************************************/
Remote_start()
{
	char buf[BUFSIZ];
	int succ;

	if( RP == 0 || *RP == 0 ){
		fatal(XLOG_INFO, "no RP specified for RM (%s)", RM );
	}
	(void)sprintf( buf, "%c%s\n", REQ_START, RP);
	if(Debug>3)log(XLOG_DEBUG,"Remote_start:%s '%d%'%s'",RM,buf[0],buf+1);
	succ = Link_line( 3, buf );
	if( JSUCC == succ){
		if(Debug>4)log(XLOG_DEBUG,"request sent");
		(void)Link_confirm();
	}
	Link_close();
	return( JSUCC == succ );
}
