/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 ***************************************************************************
 * MODULE: lpr_temp.c
 * Routines to manage the Temp_file array
 ***************************************************************************
 * Revision History: Created Sat Jan 30 12:31:45 CST 1988
 * $Log:	lpr_temp.c,v $
 * Revision 3.1  88/06/18  09:35:03  papowell
 * Version 3.0- Distributed Sat Jun 18 1988
 * 
 * Revision 2.2  88/05/14  10:18:36  papowell
 * Use long format for job file names;
 * Added 'fd', no forward flag;
 * Control file has to have hostname and origination agree.
 * 
 * Revision 2.1  88/05/09  10:09:28  papowell
 * PLP: Released Version
 * 
 * Revision 1.4  88/05/06  07:07:58  papowell
 * Fixed up error messages.
 * 
 * Revision 1.3  88/03/25  15:00:45  papowell
 * Debugged Version:
 * 1. Added the PLP control file first transfer
 * 2. Checks for MX during file transfers
 * 3. Found and fixed a mysterious bug involving the SYSLOG facilities;
 * 	apparently they open files and then assume that they will stay
 * 	open.
 * 4. Made sure that stdin, stdout, stderr was available at all times.
 * 
 * Revision 1.2  88/03/11  19:29:54  papowell
 * Minor Changes, Updates
 * 
 * Revision 1.1  88/03/01  11:08:52  papowell
 * Initial revision
 * 
 ***************************************************************************/
#ifndef lint
static char id_str1[] =
	"$Header: lpr_temp.c,v 3.1 88/06/18 09:35:03 papowell Exp $ PLP Copyright 1988 Patrick Powell";
#endif lint

#include "lpr.h"

/***************************************************************************
 * Get_tmp_data()
 *   Generate the name of a data file
 * Get_cf()
 *   return the name of the control file.
 * Add_temp( char *s )
 *   Add the name of a file to the temporary file list
 * Remove_temp()
 *   Unlink all the files in the Temp_file[] list
 ***************************************************************************/

/***************************************************************************
 * Get_tmp_data()
 * Generate the name of a data file
 * The name has the form: df<seq><job><host>
 ***************************************************************************/
static int seq;

char *
Get_tmp_data()
{
	char buf[BUFSIZ];	/* Big Buffers, Inc. */
	int c;				/* ACME Integers, Inc. */
	char *sp;			/* ACME Pointers, Inc. */
	char *st = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

	/*
	 * convert sequence number to A-Z, a-z
	 */
	if( seq >= strlen(st) ){
		Diemsg( "too many input files, split job up" );
	}
	c = st[seq];
	++seq;
	/*
	 * generate name
	 */
	(void)sprintf(buf, "df%c%03d%s", c, Job_number, Host );
	if(Debug>3)log(XLOG_DEBUG,"Get_tmp_data: %s",buf);

	/*
	 * Add to list of temporary files to be removed in case of error
	 */
	sp = Add_temp( buf );
	return( sp );
}


/***************************************************************************
 * Get_cf()
 * return the name of the control file.  This has the form
 * tf<Priority><Sequence><Host>
 ***************************************************************************/
char *
Get_cf()
{
	char buf[BUFSIZ];	/* Big Buffers, Inc. */
	char *sp;			/* ACME Pointers and Buggy Whips */

	(void)sprintf(buf, "tf%c%03d%s", Priority, Job_number, Host );
	/*
	 * check to see that the job file name fits in the limits
	 */
	if( strlen( buf ) >= CFNAMELEN ){
		fatal( XLOG_INFO, "Get_cf: control file name too long '%s'",
			buf);
	}
	if(Debug>3)log(XLOG_DEBUG,"Get_cf: control file %s",buf);
	sp = Add_temp( buf );
	return( sp );
}

/***************************************************************************
 * Add_temp( char *s )
 * Add the name of a file to the temporary file list
 * Note: these will be deleted on abnormal exit
 ***************************************************************************/
static char *Temp_space;
static int Temp_size;

char *
Add_temp( s )
	char *s;
{
	int i;
	char *sp;		/* ACME Pointers and Integers */

	if( Temp_max == 0 ){
		Temp_max = 10;
		Temp_file = (char **)malloc( (unsigned)sizeof(char *) * Temp_max);
		if( Temp_file == 0 ){
			fatal( XLOG_INFO, "Add_temp: malloc Temp_file failed" );
		}
	}
	if( Temp_max <= Temp_count ){
		Temp_max += 10;
		Temp_file = (char **)realloc((char *)Temp_file,
			(unsigned)(sizeof(char *)*Temp_max));
		if( Temp_file == 0 ){
			fatal( XLOG_INFO, "Add_temp: realloc Temp_file failed" );
		}
	}
	i = strlen( s ) + 1;
	if( i > Temp_size ){
		Temp_size = BUFSIZ;
		Temp_space = malloc( BUFSIZ );
		if( Temp_space == 0 ){
			fatal( XLOG_INFO, "Add_temp: malloc Temp_space failed" );
		}
	}
	sp = Temp_space;
	(void)strcpy(Temp_space, s );
	Temp_file[Temp_count] = sp;
	++Temp_count;
	Temp_space += i;
	Temp_size -= i;
	if(Debug>5){
		for(i=0;i<Temp_count;++i)log(XLOG_DEBUG,"temp %d %s",i,Temp_file[i]);
	}
	return( sp );
}


/***************************************************************************
 * Remove_temp()
 * Unlink all the files in the Temp_file[] list
 ***************************************************************************/

Remove_temp()
{
	char buf[BUFSIZ];	/* hold the full pathname */
	int i;				/* ACME Integers, Inc. */
	char *sd_end;		/* end of the SD name in buf */

	if( Temp_count <= 0 || SD == 0 || *SD == 0
		|| (strlen(SD)+CFNAMELEN)> sizeof(buf) ){
		return;
	}
	(void)strcpy(buf, SD );
	(void)strcat(buf, "/" );
	sd_end = &buf[strlen(buf)];
	for(i = 0; i < Temp_count; ++i ){
		(void)strcpy( sd_end, Temp_file[i] );
		if(Debug>3)log(XLOG_DEBUG,"Remove_temp: removing temp file %s", buf );
		if( unlink( buf ) < 0 ){
			logerr(XLOG_INFO,"Remove_temp: cannot remove temp file %s", buf );
		}
	}
}
