/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 ***************************************************************************
 * MODULE: lpr_canprint.c
 * Checks to see if a file is printable
 * This will be a system dependent function.  If you have setreuid(),
 * you can implement this in a fairly effective manner, as the file
 * open and stat() is done as the user, not as root.
 * The "is_exec" and "is_arch" functions are very system dependent.
 * If you have file(1) available,  check to see how it determines the file
 * types.  This may be more bizzare than you expect.
 ***************************************************************************
 * Revision History: Created Sat Jan 30 15:17:59 CST 1988
 * $Log:	lpr_canprint.c,v $
 * Revision 3.2  88/06/24  17:55:54  papowell
 * MODS for VAX 4.3BSD UNIX
 * 
 * Revision 3.1  88/06/18  09:34:51  papowell
 * Version 3.0- Distributed Sat Jun 18 1988
 * 
 * Revision 2.2  88/05/19  10:34:15  papowell
 * Fixed open() calls to have a 0 parameter, ie: open(f, perms, 0), where needed
 * 
 * Revision 2.1  88/05/09  10:09:06  papowell
 * PLP: Released Version
 * 
 * Revision 1.9  88/05/06  07:08:54  papowell
 * Modified getwd() call so that a setreuid() is done first.  This way there
 * are no problems with root perms on different systems.
 * 
 * Revision 1.8  88/04/28  17:31:59  papowell
 * fixed the setreuid() calls so that they will work on several systems
 * very odd behaviour.  Also modified the access() calls.
 * 
 * Revision 1.7  88/04/28  11:03:30  papowell
 * Modified the "printability" check to only do known text formats.
 * The XT flag is now used to force a check, rather than not forced a check
 * 
 * Revision 1.5  88/04/07  09:10:09  papowell
 * Apollo Workstation Modifications
 * 
 * Revision 1.4  88/04/06  12:13:14  papowell
 * Minor updates, changes in error message formats.
 * Elimination of the AF_UNIX connections, use AF_INET only.
 * Better error messages.
 * 
 * Revision 1.3  88/03/25  15:00:23  papowell
 * Debugged Version:
 * 1. Added the PLP control file first transfer
 * 2. Checks for MX during file transfers
 * 3. Found and fixed a mysterious bug involving the SYSLOG facilities;
 * 	apparently they open files and then assume that they will stay
 * 	open.
 * 4. Made sure that stdin, stdout, stderr was available at all times.
 * 
 * Revision 1.2  88/03/11  19:27:52  papowell
 * Minor Changes, Updates
 * 
 * Revision 1.1  88/03/01  11:08:43  papowell
 * Initial revision
 * 
 ***************************************************************************/
#ifndef lint
static char id_str1[] =
	"$Header: lpr_canprint.c,v 3.2 88/06/24 17:55:54 papowell Exp $ PLP Copyright 1988 Patrick Powell";
#endif lint

#include "lpr.h"
extern long lseek();

/***************************************************************************
 * Is_printable(  char *f )
 * Test to see if this is a printable file.
 * Return: 0 if unprintable; 1 otherwise
 ***************************************************************************/
static char errmsg[] = "File '%s' not printed: %s";

int
Is_printable( file, statb )
	char *file;
	struct stat *statb;	/* file status */
{
	char buf[BUFSIZ];
	int fd = -1;		/* file descriptor */
	int n, i, c;		/* Acme Integers, Inc. */
	int succ = 0;
	int euid = geteuid();	/* euid of process */

	/*
	 * If you have setreuid, you are very lucky; do all this as the user
	 */
	if( access(file, F_OK | R_OK) < 0){
		Warnmsg(errmsg, file, "cannot access it");
	} else if(Remove && access(file, F_OK | R_OK | W_OK ) < 0){
		Warnmsg(errmsg, file, "cannot remove it");
 	} else {
		/*
		 * do the rest of tests as USER
		 */
		if( euid == 0 ){
			Set_uid( getuid() );
		}
		if ((fd = open(file, O_RDONLY, 0)) < 0) {
			Warnmsg(errmsg, file, "cannot open it");
		} else if (fstat(fd, statb) < 0) {
			Warnmsg(errmsg, file, "cannot stat it");
		} else if ((statb->st_mode & S_IFMT) == S_IFDIR) {
			Warnmsg(errmsg, file, "it is a directory");
		} else if (statb->st_size == 0) {
			Warnmsg(errmsg, file, "it is an empty file");
		} else if( (n = read(fd, buf, sizeof(buf))) <= 0 ){
			Warnmsg(errmsg, file, "cannot read it");
		} else if( Binary || Format == 'l' ){
			succ = 1;
		} else if( !(index( "fpr", Format) || (XT && index( XT, Format)) )){
			/*
			 * We don't have to do the following checks, applicable to
			 * text files.
			 */
				succ = 1;
		} else if( is_exec(fd, buf, n) ){
			Warnmsg(errmsg, file, "executable program");
		} else if( is_arch(fd, buf, n)){
			Warnmsg(errmsg, file, "archive file");
		} else {
			succ = 1;
			/*
			 * check for clean and lovely files, up to the first block
			 */
			for( i = 0; i < n; ++i ){
				c = buf[i];
				if(!isascii(c) || !( c == '\b' || isprint(c) || isspace(c))){
					Warnmsg(errmsg, file, "it is a garbage file");
					succ = 0;
						break;
				}
			}
		}
		if( succ == 0 ){
			(void)close(fd);
			fd = -1;
		} else if( lseek( fd, 0L, 0 ) < 0 ){
			logerr( XLOG_INFO, "Is_printable: lseek failed %s", file );
			(void)close(fd);
			fd = -1;
		}
		if( euid == 0 ){
			Clear_uid();
		}
	}
	return(fd);
}
/*
 * The is_exec and is_arch are system dependent functions
 * which check if a file is an executable or archive file,
 * based on the information in the header.
 */

#ifndef	NO_A_OUT_H
#include <a.out.h>
#endif	NO_A_OUT_H
#include <ar.h>

static int
is_exec( fd, buf, n )
	int fd;
	char *buf;
	int n;
{
	int i;
#ifdef IS_DATAGEN
#	include <sgs.h>
	struct header header;

	i = 0;
	if( lseek(fd, (long)0, 0 ) < 0 ){
		logerr(XLOG_INFO,"is_exec: cannot lseek");
	}
	if( read(fd, (char *)&header, sizeof(header) ) == sizeof(header)  ){
		i =  ISMAGIC(header.magic_number);
	}
#endif IS_DATAGEN
#if defined(IS_VAX) || defined(IS_SUN)

	i = 0;
	if( n >= sizeof( struct exec ) ){
		i = !(N_BADMAG( (*(struct exec *)buf) ));
	}
#endif
#if defined( IS_UMAX ) || defined( NO_A_OUT_H )
	i = 0;
#endif
	return( i );
}

static int
is_arch( fd, buf, n )
	int fd;
	char *buf;
{
	return( !strncmp( buf, ARMAG, strlen( ARMAG )) );
}
