/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 ***************************************************************************
 * MODULE: lpr.c
 * lpr - off line print
 ***************************************************************************
 * Revision History: Created Mon Jan 25 14:04:26 CST 1988
 * $Log:	lpr.c,v $
 * Revision 3.2  88/06/24  17:56:01  papowell
 * MODS for VAX 4.3BSD UNIX
 * 
 * Revision 3.1  88/06/18  09:34:46  papowell
 * Version 3.0- Distributed Sat Jun 18 1988
 * 
 * Revision 2.1  88/05/09  10:09:00  papowell
 * PLP: Released Version
 * 
 * Revision 1.6  88/04/27  18:02:45  papowell
 * The SIGCHLD signal has an odd behaviour on some systems.  Modified so that
 * it will not get set UNLESS processes are started;  also,  it is reset
 * to SIG_DFL, not SIG_IGN.
 * 
 * Revision 1.5  88/04/15  13:06:09  papowell
 * Std_environ() call added, to ensure that fd 0 (stdin), 1 (stdout), 2(stderr)
 * have valid file descriptors;  if not open, then /dev/null is used.
 * 
 * Revision 1.4  88/04/06  12:13:28  papowell
 * Minor updates, changes in error message formats.
 * Elimination of the AF_UNIX connections, use AF_INET only.
 * Better error messages.
 * 
 * Revision 1.3  88/03/25  15:00:16  papowell
 * Debugged Version:
 * 1. Added the PLP control file first transfer
 * 2. Checks for MX during file transfers
 * 3. Found and fixed a mysterious bug involving the SYSLOG facilities;
 * 	apparently they open files and then assume that they will stay
 * 	open.
 * 4. Made sure that stdin, stdout, stderr was available at all times.
 * 
 * Revision 1.2  88/03/11  19:28:47  papowell
 * Minor Changes, Updates
 * 
 * Revision 1.1  88/03/01  11:08:41  papowell
 * Initial revision
 * 
 ***************************************************************************/
#ifndef lint
static char id_str1[] =
	"$Header: lpr.c,v 3.2 88/06/24 17:56:01 papowell Exp $ PLP Copyright 1988 Patrick Powell";
#endif lint
#include "lpr.h"

/***************************************************************************
 * SYNOPSIS
 *      lpr [ -PPrinter ] [ -#num ] [ -C class ] [ -J job ] [
 *      -RremoteAccount ] [ -m[mailTo] ] [ -T title ] [-i[numcols]]
 *      [ -1234 font ] [ -wnum ] [ -Zzoptions ] [ -Uuser ] [ -HHost
 *      ] [ -Ffilter ] [ -bhrs ] [ -Dn ] [ -X ] [ filename ...  ]
 * DESCRIPTION
 *      Lpr uses a spooling server to print the named files when
 *      facilities become available.  If no Names appear, the stan-
 *      dard input is assumed.
 *      -PPrinter  Output to the specified Printer
 *      -F?  Filter or format specification
 *      -p text to be printed using pr(1) to format the files.
 *      -l (literal) text with control characters to be printed
 *      -t output from troff(1)
 *      -n output from DITROFF
 *      -d output from tex(l) (DVI format from Stanford).
 *      -g standard plot data as produced by the plot(3X) routines
 *      -v a raster image for devices like the Benson Varian.
 *      -c data produced by cifplot(l).
 *      -f same as -Fr, FORTAN carriage control
 *      -m[mailTo] Send mail upon completion
 *      -s Use symbolic links.
 *      -J jobname  Specify the job name to print on the burst page
 *      -T title specify the title used by pr(1);
 *      -wwidth  specify the page width for pr.
 *      -C class or priority (A - Z)
 *      -R remoteAccount
 *      -#num number of copies of each file to be printed.
 *      -i[numcols] Cause the output to be indented
 *      -b The files are assumed to contain binary data
 *      -Z extra options
 *      -D[n] debug level
 *      -X Use an Xperimental version of LPD
 *      -Uuser Used by root process to specify a user
 *      -HHost Used by root process to specify a Host
 ****************************************************************************
 * Implementation:
 * 	Each time lpr is invoked it creates a "job" entry in the appropriate
 * spool directory.  Each job consists of a control file and zero or more
 * data files.  The control file contains lines that specify the job
 * parameters, such as job Name, etc., and the Names of the data files.
 *      Control file format
 *      First character in the line flags kind of entry, remainder of line is
 *          the arguemnt.
 *
 *		C -- "class Name" on banner page
 *		H -- "Host Name" of machine where lpr was done
 *		I -- "indent" amount to indent output
 *		J -- "job Name" on banner page
 *		L -- "literal" user's Name to print on banner
 *		M -- "mail" to user when done printing
 *		N -- "Name" of file (used by lpq)
 *		P -- "Person" user's login Name
 *		R -- account id  for charging 
 *		U -- "unlink" Name of file to remove after we print it
 *		W -- "width" page width for PR
 *		X -- "header" header title for PR
 *		Z -- xtra options to filters 
 *
 *	Lower case letters are formats, and are together with the Name
 *      of the file to print
 *		f -- "file Name" Name of text file to print
 *		l -- "file Name" text file with control chars
 *		p -- "file Name" text file to print with pr(1)
 *		t -- "file Name" troff(1) file to print
 *		n -- "file Name" ditroff(1) file to print
 *		d -- "file Name" dvi file to print
 *		g -- "file Name" plot(1G) file to print
 *		v -- "file Name" plain raster file to print
 *		c -- "file Name" cifplot file to print
 ***************************************************************************/

/***************************************************************************
 * main(int argc, char **argv)
 * 1. get the Host computer Name and user Name
 * 2. get the parameters and other information
 * 3. set up signals to handle abrupt termination.
 * 4. set up the control file for the job
 * 5. if we are spooling from stdin, copy stdin to a file.
 * 6. if we have -p option (use pr), run the input files through pr
 *    and save to a single file.
 * 7. create a job entry
 * 8. start the server
 ****************************************************************************/

extern int cleanup();

main(argc, argv)
	int argc;
	char **argv;
{
	int i;						/* ACME Integers, Inc. */
	struct passwd *pw_ent;		/* user entry in /etc/passwd */
	int fd, job_size;	/* size of file and job */

	/*
	 * set umask to avoid problems with user umask
	 */
	(void)umask(0);
	/*
	 * Set fd 0, 1, 2 to /dev/null if not open
	 */
	Std_environ();
#	ifdef XPERIMENT
		Setup_test();
#	endif XPERIMENT

	/*
     * set up the pathnames for information files
	 */
	Tailor_names();
	/*
	 * set up the From information
	 */
	From = Host;
	/*
	 * get user name
	 */
	if( (pw_ent = getpwuid( getuid() )) == 0 ){
		logerr_die( XLOG_INFO, "getpwuid failed on uid %d", getuid());
	}
	(void)strcpy( LOGNAME, pw_ent->pw_name );
	Person = LOGNAME;
	if( getuid() == 0 ){
		/* we are being invoked by root */
		Is_root = 1;
	}
	/*
	 * Get the home directory for the use
	 */
	(void)Get_home();
	/*
	 * setup parameters
	 */
	Setup_parms(argc, argv);
	/*
	 * set up chatty information for user
	 */
	if( BNRNAME[0] == 0 ){
		if( strcmp( LOGNAME, pw_ent->pw_name ) == 0 ){
			(void)strncpy( BNRNAME, pw_ent->pw_gecos, MAXPARMLEN );
		} else {
			(void)strcpy( BNRNAME, LOGNAME );
		}
	}
	/*
	 * set signals
	 */
	(void)signal(SIGPIPE, SIG_IGN);
	(void)signal(SIGHUP, cleanup);
	(void)signal(SIGINT, cleanup);
	(void)signal(SIGQUIT, cleanup);
	(void)signal(SIGTERM, cleanup);
	/**************************************************************************
	 * The following possibilities exist:
	 *                         Files              No Files
	 * p format,no 'f' PF      PR ->spool         input->PR -> spool
	 * p format, 'f' PF        PR->PF->spool      input->PR->PF->spool
	 * ? format, no PF         files->spool files input->spool
	 * ? format, PF            PF(files) -> file  input->spool
	 * 
	 * If we have a prefilter for a file format,  we have to run the files
	 * through the prefilter,  and spool the output of the prefilter.
	 * The prefilter will create a single output file which is printed
	 *
	 * If we have 'p' format,  we will create a printer process, and run
	 * its output into a temporary file in the spool directory.
	 * If there are no names specified, we copy the input to a temporary
	 * file in the spool directory.  The Read_stdin file is the name of the
	 * output file.  This is also used to hold the name of the output of
	 * the PR program.
	 *
	 * If we have a prefilter,  we place its output in the Read_filter
	 * file.
	 *************************************************************************/
	if( Format == 'p' ){
		/*
		 * run PR and put the output in a spool file
		 */
		if(Debug>3)log(XLOG_DEBUG,"using PR" );
		if( Run_pr() == 0 ){
			Diemsg( "nothing to print" );
		}
		Format = 'f';
	} else if( Parmcount == 0 ){
		if(Debug>3)log(XLOG_DEBUG,"Copying stdin" );
		if( Copy_stdin()  == 0 ){
			Diemsg( "nothing to print" );
		}
	} else {
		/*
		 * check to see that the input files are printable
		 */
		job_size = 0;
		for(i = 0; i < Parmcount; ++i ){
			fd = Is_printable( Parms[i].str, &LO_statb );
			if( fd < 0 ){
				Parms[i].str = 0;
			} else {
				job_size = 1;
			}
			(void)close(fd);
		}
		if( job_size == 0 ){
			Diemsg( "nothing to print" );
		}
	}
	/*
	 * now we check for prefilter;
	 * if we have one, then we have to run all the files through it;
	 * we invoke the prefilter with the appropriate parameters.
	 * The output of the prefilter (on stdout) is spooled
	 */
	if( Prefilter_name[Format - 'a'] ){
		/* yes, we have prefilter */
		if(Debug>3)log(XLOG_DEBUG,"Prefilter %c '%s'",Format,
			Prefilter_name[Format - 'a'] );
		if( Do_prefilter(Prefilter_name[Format - 'a'], Read_stdin) <= 0 ){
			Diemsg( "nothing to print" );
		}
	}
	/*
	 * we now either have to spool a single file, produced by the
	 * PR and/or Prefilters, or we have to spool all the input files
	 */
	Make_job();
	/*
	 * start up the server
	 */
	(void)Startserver();
	exit( 0 );
}
/***************************************************************************
 * cleanup()
 * remove the temp files
 ***************************************************************************/

cleanup()
{
	(void)sigblock(sigmask(SIGCHLD)|sigmask(SIGHUP)
		|sigmask(SIGINT)|sigmask(SIGQUIT)|sigmask(SIGTERM));
	if( geteuid() && geteuid() != getuid() ){
		/*
		 * whoops, we must have been caught as user
		 * try and force to EUID root
		 */
		if( setreuid( geteuid(), 0 ) < 0 ){
			logerr( XLOG_INFO, "cleanup: setreuid( %d, %d) failed",
				geteuid(), 0 );
			exit(1);
		}
	}
	if( geteuid() == 0 && setreuid( -1, Daemon_uid ) < 0 ){
		logerr( XLOG_INFO, "cleanup: setreuid( %d, %d) failed",
			-1, Daemon_uid );
			exit(1);
	}
	Remove_temp();
	exit( 1 );
}
