/*************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 *************************************************************************
 * MODULE: lp.h
 * Includes and definitions for all programs
 *************************************************************************
 * Revision History: Created Sun Jan  3 15:37:08 CST 1988
 * $Header: lp.h,v 3.2 88/06/24 17:15:52 papowell Exp $
 * $Log:	lp.h,v $
 * Revision 3.2  88/06/24  17:15:52  papowell
 * MODS for VAX 4.3BSD UNIX
 * 
 * 
 * Revision 3.1  88/06/18  09:34:30  papowell
 * Version 3.0- Distributed Sat Jun 18 1988
 * 
 * Revision 2.3  88/05/29  13:09:55  papowell
 * Added Header string for RCS purposes
 * 
 * Revision 2.2  88/05/14  10:18:16  papowell
 * Use long format for job file names;
 * Added 'fd', no forward flag;
 * Control file has to have hostname and origination agree.
 * 
 * Revision 2.1  88/05/09  10:10:48  papowell
 * PLP: Released Version
 * 
 * Revision 1.12  88/05/09  10:03:39  papowell
 * Revised effects of -h option
 * 
 * Revision 1.11  88/05/05  20:08:53  papowell
 * Added a NOHEADER option that allows user to suppress banner
 * 
 * Revision 1.10  88/04/29  07:48:55  papowell
 * Added USE_LOCKF flags
 * 
 * Revision 1.9  88/04/28  17:32:47  papowell
 * fixed Data General Options
 * 
 * Revision 1.8  88/04/21  21:49:40  papowell
 * BADSETREUID: this flag is provided for situations where setreuid()
 * does not allow changing back to root after changing to a user.
 * This is a problem in security,  and should be avoided.
 * 
 * Revision 1.7  88/04/07  12:29:13  papowell
 * Removed AF_UNIX socket definitions
 * 
 * Revision 1.6  88/04/07  09:09:23  papowell
 * Apollo Workstation Modifications
 * 
 * Revision 1.5  88/04/06  12:13:40  papowell
 * Minor updates, changes in error message formats.
 * Elimination of the AF_UNIX connections, use AF_INET only.
 * Better error messages.
 * 
 * Revision 1.4  88/03/25  14:59:54  papowell
 * Debugged Version:
 * 1. Added the PLP control file first transfer
 * 2. Checks for MX during file transfers
 * 3. Found and fixed a mysterious bug involving the SYSLOG facilities;
 * 	apparently they open files and then assume that they will stay
 * 	open.
 * 4. Made sure that stdin, stdout, stderr was available at all times.
 * 
 * Revision 1.3  88/03/11  19:29:10  papowell
 * Minor Changes, Updates
 * 
 * Revision 1.2  88/03/05  15:02:09  papowell
 * Minor Corrections,  Lint Problems
 * 
 * Revision 1.1  88/03/01  12:42:54  papowell
 * Initial revision
 * 
 *************************************************************************/

/*************************************************************************
 * Make sure that you set the DEBUG flag if XPERIMENT is set
 *
 *************************************************************************/
#ifdef XPERIMENT
#define DEBUG 1
#endif XPERIMENT
/*************************************************************************
 * Portability Definitions
 * Several systems do not have the same definitions for these items.
 * You will have to add your own local definitions.
 * Ahh...  Dream of the day of a standard set of definitions
 *************************************************************************/
#ifdef IS_SUN
#define uid_t	int	/* keep lint on the sun happy */
#endif IS_SUN

#ifdef IS_VAX4BSD
#define SETREUID4BSD 1
#endif IS_VAX4BSD

#ifdef IS_DATAGEN
#define fd_set	int	/* keep lint happy */
#define uid_t	int	/* keep lint happy */
#define NOSYMLINK	/* no symbolic links */
#define USE_LOCKF	/* use the lockf() function for locking */
#define F_TLOCK	2	/* test and lock a section (non-blocking) */
#endif IS_DATAGEN

#ifdef IS_UMAX
#undef B19200
#undef B38400
#define B19200 EXTA
#define B38400 EXTB
#define time_t long
#define uid_t int
#endif IS_UMAX

#ifdef IS_APOLLO
#undef B19200
#undef B38400
#define B19200 EXTA
#define B38400 EXTB
#define uid_t int
#define USE_STRINGS		/* use <strings.h> instead of <string.h> */
#define NO_A_OUT_H		/* no a.out.h include file */
#endif IS_APOLLO

/******************************************************************
 * System Include Files
 ******************************************************************/
#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/dir.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/resource.h>
#include <netinet/in.h>
#include <netdb.h>
#include <pwd.h>
#include <signal.h>
#include <sys/wait.h>
#include <sgtty.h>
#include <ctype.h>
#ifdef USE_STRINGS
#include <strings.h>
#else USE_STRINGS
#include <string.h>
#endif USE_STRINGS
#include <errno.h>
#include <grp.h>


/******************************************************************
 * Declare Standard Routines.
 * Note: most of these are not declared in include files.
 * This leads to some interesting problems with LINT. Declare these
 * here.  Some specialized routines are declared in the individual
 * routines that use them.
 ******************************************************************/
extern char	*malloc(), *realloc();
extern char	*getenv();
extern char	*gets();
extern int errno, sys_nerr;
extern char *sys_errlist[];
extern char *index(), *rindex();
extern char *sprintf();	/* sigh... sprintf strikes again */
extern long lseek(), atol();

extern uid_t getuid(), geteuid();
extern time_t time();	/* watch this one */

/*
 * This should be declared in <signal.h>
 */
#ifndef sigmask
#define sigmask(m)	(1 << ((m)-1))
#endif

/*************************************************************************
 * PRINTCAP entries and associated variables.
 * Each printcap entry has a corresponding variable; for example
 * ":af=accnt:"
 *   -> AF = "accnt";
 *************************************************************************/
extern int    AB;		/* Always have a banner flag, ignore lpr -h option */
extern char  *AF;		/* accounting file */
extern char  *BP;		/* banner printer filter */
extern int    BK;		/* Berkeley compatible remote and local */
extern int    BR;		/* baud rate if lp is a tty */
extern int    CO;		/* cost of printing in dollars */
extern char  *EP;		/* end printer filter */
extern int    FD;		/* No forwarding, accept only from original site */
extern int    FO;		/* print a form feed when device is opened */
extern int    FC;		/* flags to clear if lp is a tty */
extern char  *FF;		/* form feed string */
extern int    FJ;		/* send control file  first to remote site */
extern int    FQ;		/* form feed on quitting */
extern int    FS;		/* flags to set if lp is a tty */
extern char  *FX;		/* allowable formats */
extern char  *LD;		/* leader string on opening */
extern char  *LF;		/* log file for error messages */
extern int    LH;		/* use long host name */
extern char  *LO;		/* lock file name */
extern char  *LN;		/* group allowed to use links */
extern char  *LP;		/* line printer device name */
extern int    MC;		/* maximum number of copies allowed */
extern int    MX;		/* maximum number of blocks to copy */
extern int    NW;		/* Networked file system, do not make copies */
extern int    PL;		/* page length */
extern char  *PR;		/* pr program name name */
extern char  *PS;		/* printer status file name */
extern int    PW;		/* page width */
extern int    PX;		/* page width in pixels */
extern int    PY;		/* page length in pixels */
extern char  *QH;		/* queue handler */
extern char  *RG;		/* restrict use to group */
extern char  *RM;		/* remote machine name */
extern char  *RP;		/* remote printer name */
extern int    RT;		/* max retries */
extern int    RW;		/* open LP for reading and writing */
extern int    SB;		/* short banner instead of normal header */
extern int    SC;		/* suppress multiple copies */
extern char  *SD;		/* spool directory */
extern int    SF;		/* suppress FF on each print job */
extern int    SH;		/* suppress header page */
extern char  *SS;		/* name of queue that the server serves  */
extern char  *ST;		/* status file name */
extern char  *SV;		/* names of servers */
extern char  *TR;		/* trailer string to be output when Q empties */
extern char  *TY;		/* terminal characteristics, stty options */
extern int    XC;		/* flags to clear for local mode */
extern int    XS;		/* flags to set for local mode */
extern char  *XT;		/* format checked for text only */
extern char  *XU;		/* restrict use to users whose names are in file */
/*
 * Filter_name[] is an array of filter names, indexed by the first letter
 * of the printcap tag. For example:
 * ":if=/usr/lib/iffilter -n -a:"
 *     -> Filter_name['i'-'a'] = "/usr/lib/iffilter -n -a";
 */
extern char *Filter_name[26];
#define	IF	(Filter_name['i'-'a'])
#define	OF	(Filter_name['o'-'a'])
/*
 * Prefilter_name[] is similar to Filter_name[], but for prefilter entries.
 */
extern char *Prefilter_name[26];

/**********************************************************************
 * Globally accessed variables and routines
 **********************************************************************/
extern char	*Name;				/* program name */
extern char	*Printer;			/* printer name */
extern char *Person;			/* user name */
extern char	Host[64];			/* Host machine name */
extern char	*From;				/* client's machine name */
extern int	Debug;				/* Debugging level */
extern int	Echo_on_stdout;		/* stderr output on stdout as well */
extern char *First_name;		/* first name in printcap entry */
extern FILE *Lfd;				/* lock file */
extern int Optind, Opterr;		/*  option index, error message suppression */
extern char *Optarg;			/*  option value */
extern char *Opt_flag;			/*  option staring flags */
extern char Lpdlogf[];		/* = DEFLPDLOGF; */
extern char Masterlock[];		/*  = MASTERLOCK; */
extern int	Lpr_port_num;		/* port number to connect to */
extern int Maxportno;			/*  = MAXPORTNO; */
extern int Minportno;			/*  = MINPORTNO; */
extern char Permfile[];			/*  = PERMFILE; */
extern char Printcap[];			/*  = PRINTCAP; */
extern char Last_errormsg[];	/* last errormessage */
extern int Request;				/* current lpd request code */
extern int Print_fd;			/* output printer FILE */
extern int Short_format;		/* short status format */
extern int  Is_root;			/* is this the root user? */
extern int  Is_local;			/* doing this locally or remotely? */
extern struct stat LO_statb;	/* used to stat lockfile */
extern void Print_close(), Link_close(); /* close these things */
extern int Daemon_uid;			/* daemon UID */
extern int Daemon_gid;			/* daemon GID */
extern char *estrcp();			/* handy form of strcp() */
extern char *Time_str();		/* ctime with \n removed */
extern char *Setup_filter();	/* set up argv for a filter */
extern int Reapchild();         /* wait3() for a child */
extern int Getopt();			/* get command line option */
extern char *Errormsg();		/* printable error message */
extern int	Errorcode;			/* exit() value on fatal termination */
extern char *Decode_status();	/* decode a status returned by wait() */
extern FILE	*fopen_daemon();	/* open a file as daemon */
extern int	open_daemon();		/* open a file as daemon */

/*******************************************************************
 *  struct queue
 *    used to record entries in the spool directory for printing
 *    and status reporting.
 *  NOTE: control and data file names in spool directory have the form
 *  c f <priority> <job number> <Hostname>  <terminating 0>
 *  d f <seq>      <job number> <Hostname>  <terminating 0>
 *  1 1 1               3         max 64           1
 * eg: dfA001attila.cs.umn.edu         (attila the SUN, of course)
 * eg: cfZ001attila.cs.umn.edu         (attila the SUN, of course)
 *******************************************************************/
#define CFNAMELEN (sizeof(Host)+8)	/* control or data file name length */
/*
 * fields in the name
 */
#define STARTPR	2	/* df[] */
#define STARTID	3	/* dfX[] */
#define IDLEN	3	/* dfX[NNN] */
#define	STARTFR	6	/* dfXNNN[] */
#define MAXPARMLEN	80
struct queue {
	char	q_name[CFNAMELEN+1];	/* name of the control file */
	time_t	q_time;					/* modification time */
	time_t	q_sp;					/* spooled at time */
	time_t	q_unsp;					/* unspool at time */
	int		q_priority;				/* priority */
	long	q_size;					/* size of the data files */
	char	q_user[32];				/* user name */
	int		q_num;					/* job number */
	char	q_data[MAXPARMLEN+1];	/* data files name */
	int		q_daemon;				/* daemon for this entry */
	char	*q_server;				/* server for this entry */
};

#define	q_from	q_name[STARTFR]
extern int Getq();					/* find queue entries */
extern struct queue *Jobentry;		/* current job entry in queue */
extern struct queue *Queue;			/* Getq generates an array of jobs */
extern int Jobcount;				/* and returns the number of jobs  */

extern int Rec_cnt;					/* number of files in a job */

/********************************************************************
 * File Permissions
 ********************************************************************/

#define LFMODE      0644    /* log file permissions */
#define FILMOD      0600	/* spooling directory file permission */

/*
 * Queue Control is done by using the permissions of the lock file
 * for the queue.  The following permissions are used:
 * 	Disable Printing: owner execute or 0100
 * 	Disable Queing:	group execute or 0010
 * 	Queue handler active (antique) 0001
 */
#define	DISABLE_PRINT	(0100)
#define	ENABLE_PRINT	(0777 & ~ DISABLE_PRINT)
#define	DISABLE_QUEUE	(0010)
#define	ENABLE_QUEUE	(0777 & ~ DISABLE_QUEUE)
#define	FORCE_REQUE		(0001)
#define	CLEAR_REQUE		(0777 & ~ FORCE_REQUE)

/*
 *  syslog(8) message priorities.  These are defined by the values of
 *  global variables.  The variables are initialized either with values
 *  in the <syslog.h> include file,  or by a set of default values according
 *  to the NOSYSLOG option in the Makefile.
 */
extern int XLOG_ERR;			/*4 synonym of LOG_ERROR */
extern int XLOG_CRIT;			/*5	critical information */
extern int XLOG_WARNING;		/*6	warning */
extern int XLOG_NOTICE;			/*7	important information */
extern int XLOG_INFO;			/*8	informational message */
extern int XLOG_DEBUG;			/*9	Debug level info */

/*******************************************************************
 * Printcap Data Structures
 * The printcap file information is extracted using a single pass of
 * the printcap database.  As each entry is found,  it is looked up
 * in a table which has the entry tag,  the type of entry,
 * a default value,  and the variable used to hold the value.
 *
 * The table is sorted alphabetically by the tag values and the update
 * routines use a modified binary search.  The time taken to read the
 * printcap entry is proportional to
 * K  log( M ), where K is the length of the printcap file and M is
 * the number of printcap variables.  Note that this appears to be
 * a much simpler and easier way to implement printcap information
 * extraction.  The "initialization" of the entire set of variables
 * is extremely fast,  apparently taking about the same time  as reading
 * two variables using the original "termcap" code.
 *******************************************************************/
typedef struct pc_entry{
	char pc_name[3];	/* two character name, and the last char */
	int	kind;	/* the kind of entry */
#		define PC_NUM		0	/* integer */
#		define PC_FLAG		1	/* integer */
#		define PC_STRING	2	/* string */
	int idefault;	/* this is the default integer or flag value */
	char *sdefault;	/* this is the default integer or flag value */
	/*
	 * the variable is assumed to be a pointer to char;
	 * this is cast to pointer to int if neccessary. 
	 */
	char **var;
} PC_ENTRY;

/*
 * Routines to look up printer names and printcap entries
 * char ** All_printers():  reads the printcap database and extracts the
 *   names of all the printer entries.
 * char *First_printer(): gets name of first printer
 * Get_pc_entry(): given name of a printer and an array  of PC_ENTRIES,
 *  it finds the printcap entry and extracts all the information
 *  for the variables listed in the array.
 * Set_pc_entry(): same functionality, does not initialize variables.
 */
#define PRNAMELEN	32	/* Maximum of 32 characters for printer name */
#define MAXPCNAMES	100	/* Maximum of 100 printers */
extern int Get_pc_entry( /* char *name; PC_ENTRY *pc_vars; int pc_len */);
extern int Set_pc_entry( /* char *name; PC_ENTRY *pc_vars; int pc_len */);
extern char **All_printers();	/* returns array printer names */
extern char *First_printer();	/* returns array printer names */
/*
 * All_pc_vars[]: all printcap variables, and is used by lpr and lpd;
 * Status_pc_vars[]: a short set needed by lpq, lprm, and lpc.
 * Server_pc_vars[]: a few needed by servers only
 */
extern PC_ENTRY All_pc_vars[ /* All_pc_len */ ];
extern int	All_pc_len;
extern PC_ENTRY Status_pc_vars[ /* Status_pc_len */ ];
extern int	Status_pc_len;
extern PC_ENTRY Server_pc_vars[ /* Server_pc_len */ ];
extern int	Server_pc_len;

/***********************************************************************
 * File Locking Support:
 * see lockfile.c for details.
 ***********************************************************************/
extern FILE *Readlockfile();	/* reads file, returns FILE * */
extern FILE *Getlockfile();		/* locks file, returns FILE * */
extern int   Checklockfile();	/* checks for lock and daemon */
extern FILE *Lockcf();			/* lock a control file */
extern int   Exlockcf();		/* create and lock a control file */

/***********************************************************************
 * Parameter List Support
 * struct parm parmlist[]
 *  is used when parsing a command received from a remote Host
 * It is also used by lpr to determine the command file, and to keep
 * track of the file/datafile name correspondence.
 ***********************************************************************/
#define MAXPARMS 50
struct parm{
	char *str;					/* string parameter */
	int   num;					/* number parameter */
	char filename[CFNAMELEN+1];	/* file name for parameter */
	long size;					/* size of file */
};
extern struct parm Parms[MAXPARMS];		/* array of parmaters */
extern int    Parmcount;				/* number of parameters */

/***********************************************************************
 * Request types
 * A request sent to the LPD daemon has the format:
 * \Xprinter [options],  where \X is a single character or byte value.
 * The following are the values and commands
 ***********************************************************************/
#define REQ_START	1	/* start printer */
#define REQ_RECV	2	/* transfer a job to the Host from a remote site */
#define REQ_DSHORT	3	/* print short form of queue status */
#define REQ_DLONG	4	/* print long form of queue status */
#define REQ_REMOVE	5	/* remove jobs */
#define REQ_CONTROL	6	/* do control operation */
/**************************************************************************
 *      Control file format
 *      First character is kind of entry, remainder of line is
 *          the argument.
 *
 *		1 -- "R font file" for troff -ignore
 *		2 -- "I font file" for troff -ignore
 *		3 -- "B font file" for troff -ignore
 *		4 -- "S font file" for troff -ignore
 *		C -- "class name" on banner page
 *		H -- "Host name" of machine where lpr was done
 *		I -- "indent" amount to indent output
 *		J -- "job name" on banner page
 *		L -- "literal" user's name to print on banner
 *		M -- "mail" to user when done printing
 *		N -- "name" of file (used by lpq)
 *		P -- "Person" user's login name
 *		R -- account id  for charging 
 *		U -- "unlink" name of file to remove after we print it
 *		W -- "width" page width for PR
 *		X -- "header" header title for PR
 *		Z -- xtra options to filters 
 *
 *		Lower case letters are formats
 *		f -- "file name" name of text file to print
 *		l -- "file name" text file with control chars
 *		p -- "file name" text file to print with pr(1)
 *		t -- "file name" troff(1) file to print
 *		n -- "file name" ditroff(1) file to print
 *		d -- "file name" dvi file to print
 *		g -- "file name" plot(1G) file to print
 *		v -- "file name" plain raster file to print
 *		c -- "file name" cifplot file to print
 *
 * CFparm is used to hold the upper case parameters
 */
extern char CFparm[26][MAXPARMLEN+1];
#define CLASSNAME CFparm['C'-'A']
#define WHENSP    CFparm['D'-'A']
#define FROMHOST  CFparm['H'-'A']
#define INDENT    CFparm['I'-'A']
#define JOBNAME   CFparm['J'-'A']
#define BNRNAME   CFparm['L'-'A']
#define FILENAME  CFparm['N'-'A']
#define MAILNAME  CFparm['M'-'A']
#define LOGNAME   CFparm['P'-'A']
#define ACCNTNAME CFparm['R'-'A']
#define NOHEADER  CFparm['S'-'A']
#define WHENUNSP  CFparm['T'-'A']
#define UNLNKFILE CFparm['U'-'A']
#define PWIDTH    CFparm['W'-'A']
#define PRTITLE   CFparm['X'-'A']
#define ZOPTS     CFparm['Z'-'A']

/*
 * printjob return codes
 */
#define JBUSY	-1              /* being done by other means */
#define JFAIL	 0				/* repeat with retry */
#define JSUCC	 1				/* done */
#define JABORT   2				/* done, but problems */

/*
 * Mail program
 */
#ifndef MAIL
#define MAIL "/usr/lib/sendmail"
#endif MAIL

/*
 * File Transfer Protocol Flags
 */
#define CEND 5		/* last file */
#define CNAME 4		/* control file */
#define DFILE 3		/* data file */
#define CFILE 2		/* control file */

/*
 * Local parameters to the spooling system
 * Defaults for line printer capabilities data base
 */
#define DEFLOGF		"log"
#define DEFLOCK		"lock"
#define DEFSTAT		"status"
#define DEFACCT		"acct"
#define	DEFFORMATS	"flp"	/* default formats */
#define	DEFMX		1000
#define	DEFRETRY	3		/* maximum number of retries */
#define DEFMAXCOPIES	0
#define DEFFF		"\f"
#define DEFWIDTH	132
#define DEFLENGTH	66
#define DAEMON		"daemon"	/* daemon user id */
#define DEFPRICE	20	/* cost in dollars per thousand pages */
#define DEFPRIORITY	'Z'	/* default priority level */
#define DEFPR		"/bin/pr"	/* default pr program */

/*
 * REAL, not TEST version
 */

/*
 * path name of files created by lpd.
 */
#define RMASTERLOCK	"/usr/spool/lpd/lpd.lock."
#define	RDEFLPDLOGF		"/usr/spool/lpd/lpd.log."
#ifdef	ETCPC
#	define RPRINTCAP	ETCPC
#else
#	define RPRINTCAP	"/usr/spool/lpd/printcap."
#endif
/*
 * connection services to be used
 */
#define SERVERNAME	"printer"
#define SERVERPROT	"tcp"
/* name of the printer permissions file */
#ifdef	ETCPERMS
#	define	RPERMFILE   ETCPERMS
#else
#	define	RPERMFILE   "/usr/spool/lpd/printer_perms."
#endif
/*
 *	The remote client must call from a port in the following range.
 *	This is used for authentication purposes.  The ports less than
 *	IPPORT_RESERVED are accessible only to SU processes.
 */
#define RMINPORTNO	(IPPORT_RESERVED/2)
#define RMAXPORTNO	(IPPORT_RESERVED)

/*
 *	DEBUG Version, use to avoid screwing up normal operations
 * path name of files created by lpd.
 */
#define TMASTERLOCK 	"/tmp/lpd.lock."
#define	TDEFLPDLOGF		"/tmp/lpd.log."
#define TPRINTCAP	 	"/tmp/printcap."
/*
 * connection services to be used
 */
#define TSERVICENAME	"testlpr"
#define TPORTNUM	1600	/* test port number */
/* name of the printer permissions file */
#define	TPERMFILE   "/tmp/printer_perms."
/*
 *	The remote client must call from a port in the following range.
 *	This is used for authentication purposes.  The ports less than
 *	IPPORT_RESERVED are accessible only to SU processes.
 */
#define TMINPORTNO	(IPPORT_RESERVED+1)
#define TMAXPORTNO	(2*IPPORT_RESERVED)
