/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 ***************************************************************************
 * MODULE:  lpf.c
 ***************************************************************************
 * Revision History: Created Fri Mar  4 19:05:43 CST 1988
 * $Log:	lpf.c,v $
 * Revision 2.2  88/05/19  07:35:38  papowell
 * fixed minor bug with overstrikes
 * 
 * Revision 2.1  88/05/09  10:12:08  papowell
 * *** empty log message ***
 * 
 ***************************************************************************/
#ifndef lint
static char id_str1[] =
	"$Header: lpf.c,v 2.2 88/05/19 07:35:38 papowell Locked $ PLP Copyright 1988 Patrick Powell";
#endif lint
/***************************************************************************
 *	LPF and VPF filters.
 * 	Filter which converts lines with ^H's to overwritten lines.
 *	Thus this works like 'ul' but is much better; it can handle
 *	more than 2 overwrites and it is written with some style.
 *
 *	Also used as the versatec driver, with the VERSATEC defined
 *  Original source for this was the 4.2BSD release,  but there have
 *	been substantial modifications since.  This version has been derived 
 *	from a total rewrite done in 1985.
 ***************************************************************************/

#include <stdio.h>
#include <ctype.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/time.h>

extern int errorcode;
/* set from flags */
extern int debug, width, length, xwidth, ylength, literal, indent;
extern char *zopts, *class, *job, *login, *accntname, *host, *accntfile;
extern char *printer, *format, *name;
extern int npages;	/* number of pages */
extern char *calloc();	/* memory allocation */

#ifdef VERSATEC
#include <sys/vcmd.h>


int	pltmode[] = {VPLOT};
int	prtmode[] = {VPRINT};
#define MAXREP		10

#else  VERSATEC
/* line printer */

#define MAXREP		10
#endif VERSATEC

#define	TIMEOUT		(5*60)	/*	5 minute time out	*/

char	*buf;
int	*maxcol;
int	lineno;


int	timeout();

filter(stop)
	char *stop;
{
	register FILE *p = stdin, *o = stdout;
	register int i, j, col;
	register char *cp;
	int done, linedone, maxrep;
	unsigned int bufsize;
	char ch, *limit;
	int state, partial;

	partial = 0;
	state = 0;
	if( xwidth <= 0 ){
		xwidth = width;
		/* fatal( "bad xwidth value %d", xwidth ); */
	}
	if( width > xwidth || width <= 0 ){
		fatal( "width (%d) out of range, max %d", width, xwidth );
	}
	/*
	 * check on width 
	 */
	bufsize =  (unsigned)( MAXREP * xwidth );
	if( (buf = calloc( bufsize, sizeof(char) )) == 0 
		|| (maxcol = (int *)calloc( (unsigned)( MAXREP ), sizeof(int) )) == 0 ){
		fatal( "malloc failed");
	}
	maxcol[0] = -1;
	state = 0;
	/*
	 * set up timeout
	 */

#	ifdef VERSATEC
	(void) signal( SIGALRM, timeout );
	errorcode = 1;	/* set retry on failure */
	if( ioctl(1, VSETSTATE, prtmode) < 0 ){
		logerr_die( "ioctl failed" );
	}
#	endif VERSATEC


	for( i = 0; i < MAXREP; ++i ){
		maxcol[i] = -1;
	}
	for( i = 0; i < bufsize; ++i ){
		buf[i] = ' ';
	}
	done = 0;

	while (!done) {
		col = indent;
		maxrep = -1;
		linedone = 0;
		while (!linedone) {
			if( state ){
				/* we read a partial stop and want to process it normally */
				ch = stop[partial];
				++partial;
				if( partial == state ){
					state = 0;
				}
			} else {
				ch = getc(p);
				if( stop && ch == *stop){
					/* we have hit the first character in the stop sequence */
					for(state = 1;
						stop[state] && (ch = getc(p)) == stop[state];
						++state );
					/* we either have last, or we have a bad character */
					if( stop[state] == 0 ){
						state = 0; /* suspend yourself!! */
						/*
						 * if this filter is running as the OF
						 * filter, it is used only for banners.
						 * lpd needs to use a different filter to
						 * print data so stop what we are doing and
						 * wait for lpd to restart us.
						 */
						(void)alarm( TIMEOUT );
						if( fflush(stdout) < 0 ){
							logerr_die( "fflush failed" );
						}
						(void)alarm( 0 );
						suspend();
#						ifdef VERSATEC
						if( ioctl(1, VSETSTATE, prtmode) < 0 ){
							logerr_die( "ioctl failed" );
						}
#						endif VERSATEC
					} else {
						/* we don't have all of the characters */
						partial = 0;
						if( ch != EOF ){
							(void)ungetc(ch, stdin);
						}
					}
					/* we want to iterate, using new characters */
					continue;
				}
			}
			switch (ch) {
			case EOF:
				linedone = done = 1;
				ch = '\n';
				break;

			case '\f':
				lineno = length;
			case '\n':
				if (maxrep < 0)
					maxrep = 0;
				linedone = 1;
				break;

			case '\b':
				--col;
				if( col < indent)
					col = indent;
				break;

			case '\r':
				col = indent;
				break;

			case '\t':
				col = ((col - indent) | 07) + indent + 1;
				break;

			default:
				if (col >= width || !literal && !isprint(ch)) {
					col++;
					break;
				}
				if(debug)fprintf(stderr,"ch '%c', col %d\n", ch, col );
				cp = buf+col;
				for (i = 0; i < MAXREP; i++) {
					if (i > maxrep)
						maxrep = i;
					if (*cp == ' ') {
						*cp = ch;
						if (col > maxcol[i])
							maxcol[i] = col;
						break;
					}
					cp += xwidth;
				}
				col++;
			}
		}

		/* print out lines */
		(void)alarm( TIMEOUT );
		/* print out the lines in order of last to first */
		if(debug){
			fprintf(stderr,"maxrep %d\n");
		}
		for (i = maxrep; i >= 0;  --i) {
			cp = buf+i*xwidth;
			if(debug){
				fprintf(stderr,"line %d, col %d, '%s'\n",i,
					maxcol[i], cp);
			}
			if( (col = maxcol[i]+1) > 0 ){
				if(col != fwrite(cp,1,col,o)){
					logerr_die( "write failed" );
				}
			}
			for( j = 0; j < xwidth; ++j ){
				cp[j] = ' ';
			}
			maxcol[i] = -1;
#			ifdef PRINTRONIX
			if( putc('\r', o) < 0 ){
				logerr_die( "putc failed" );
			}
#			else  PRINTRONIX
			if( i > 0 ){
				if( putc('\r', o) < 0 ){
					logerr_die( "putc failed" );
				}
			}
#			endif PRINTRONIX
		}
		if( putc(ch, o) < 0 ){
			logerr_die( "write failed" );
		}
		(void)alarm( 0 );

		/*
		 * update page count
		 */
		if(++lineno >= length){
			npages++;
			lineno = 0;
		}
	}

	(void)alarm( TIMEOUT );	/* set up timeout */
	if (lineno) {		/* be sure to end on a page boundary */
		if( putc('\f', o) < 0 ){
			logerr_die( "putc failed" );
		}
		npages++;
	}
	(void)fflush( o );
	if( ferror(o) ){
		logerr_die( "write failed" );
	}
	(void)alarm( 0 );
    }


timeout()
    {
	fatal( "timeout" );
    }

/*
 * do nothing on cleanup
 */

cleanup()
    {}
