/*****************************************************************

    Copyright 1985. All Rights Reserved Chris Lewis

    Module          : newfonts.c 1.3
    Date submitted  : 86/01/30 09:19:57
    Author          : Chris Lewis
    Origin          : Permission to copy and further distribute is 
		      freely given provided this copyright notice remains 
		      intact and that this software is not sold for profit.
    Description     : Description of the file

******************************************************************/

#ifndef lint
static char SrcId[] = "@(#) newfonts.c:1.3";
#endif
#include <stdio.h>
#include "../fonts/mkfonts/vfont.h"

extern FILE	*diagFile;
#define	DEBUGPRINTF	if (diagFile) debugprintf
extern	char	*fontLib;

static int	dpi = 75;

static struct header header;
static struct dispatch D[256];
static unsigned char imageTable[BUFSIZ*10];

/*	"s" is font name, point is desired point size, if (flag), use
	bigger fonts if possible	*/
loadfont(s, point, quality)
char	*s;
int	point; 
int	quality; {
	static char oldfont[BUFSIZ], buf[BUFSIZ], fontBuf[BUFSIZ];
	FILE   *f;
	register int i;
	sprintf(buf, "%s.%d", s, point);
	if (strcmp(oldfont, buf) == 0)
		return(dpi);
	strcpy(oldfont, buf);
	if (s[0] != '/') {
		strcpy(buf, fontLib);
		strcat(buf, s);
	}
	if (quality > 1) {
		i = point * 4;
		dpi = 300;
		do {
			sprintf(fontBuf, "%s.%d", buf, i);
			DEBUGPRINTF("Trying for font %s\n", fontBuf);
			if (access(fontBuf, 04) == 0)
				goto useit;
			i >>= 1;
			dpi /= 2;
		} while (dpi >= 75);
		dpi = 0;
		return(0);
	} else {
		sprintf(fontBuf, "%s.%d", buf, point);
		dpi = 75;
	}

useit:

	if (!(f = fopen(fontBuf, "r"))) {
		fprintf(stderr, "lcat: Could not load font %s, using native\n",
			fontBuf);
		dpi = 0;
		return(0);
	}
	DEBUGPRINTF("Loaded font %s (dpi: %d)\n", fontBuf, dpi);
	if (fread(&header, sizeof(header), 1, f) != 1) {
		fprintf(stderr, "lcat: Bad font file header\n");
		exit(1);
	}
	if (header.magic != 0436) {
		fprintf(stderr, "lcat: Bad font magic number\n");
		exit(1);
	}
	if (fread(D, sizeof(struct dispatch), 256, f) != 256) {
		fprintf(stderr, "lcat: Could not load font dispatch table\n");
		exit(1);
	}
	if (fread(imageTable, 1, header.size, f) != header.size) {
		fprintf(stderr, "lcat: Error reading image table\n");
		exit(1);
	}
	return(dpi);
}

#define	UNASS	0

static unsigned char flashtovfnt[108] = {
	/*   1  */	'h',	/*h*/
	/*   2  */	't',	/*t*/
	/*   3  */	'n',	/*n*/
	/*   4  */	'm',	/*m*/
	/*   5  */	'l',	/*l*/
	/*   6  */	'i',	/*i*/
	/*   7  */	'z',	/*z*/
	/*   8  */	's',	/*s*/
	/*   9  */	'd',	/*d*/
	/*  10  */	'b',	/*b*/
	/*  11  */	'x',	/*x*/
	/*  12  */	'f',	/*f*/
	/*  13  */	'j',	/*j*/
	/*  14  */	'u',	/*u*/
	/*  15  */	'k',	/*k*/
	/*  16  */	UNASS,	/*unassigned*/
	/*  17  */	'p',	/*p*/
	/*  18  */	UNASS,	/*3/4 em*/
	/*  19  */	';',	/*;*/
	/*  20  */	UNASS,	/*unassigned*/
	/*  21  */	'a',	/*a*/
	/*  22  */	'_',	/*horizontal rule*/
	/*  23  */	'c',	/*c*/
	/*  24  */	'`',	/*` open*/
	/*  25  */	'e',	/*e*/
	/*  26  */	'\'',	/*' close*/
	/*  27  */	'o',	/*o*/
	/*  28  */	UNASS,	/*1/4*/
	/*  29  */	'r',	/*r*/
	/*  30  */	UNASS,	/*1/2*/
	/*  31  */	'v',	/*v*/
	/*  32  */	'-',	/*- hyphen*/
	/*  33  */	'w',	/*w*/
	/*  34  */	'q',	/*q*/
	/*  35  */	'/',	/*/*/
	/*  36  */	'.',	/*.*/
	/*  37  */	'g',	/*g*/
	/*  38  */	UNASS,	/*3/4*/
	/*  39  */	',',	/*,*/
	/*  40  */	'&',	/*&*/
	/*  41  */	'y',	/*y*/
	/*  42  */	UNASS,	/*unassigned*/
	/*  43  */	'%',	/*%*/
	/*  44  */	UNASS,	/*unassigned*/
	/*  45  */	'Q',	/*Q*/
	/*  46  */	'T',	/*T*/
	/*  47  */	'O',	/*O*/
	/*  48  */	'H',	/*H*/
	/*  49  */	'N',	/*N*/
	/*  50  */	'M',	/*M*/
	/*  51  */	'L',	/*L*/
	/*  52  */	'R',	/*R*/
	/*  53  */	'G',	/*G*/
	/*  54  */	'I',	/*I*/
	/*  55  */	'P',	/*P*/
	/*  56  */	'C',	/*C*/
	/*  57  */	'V',	/*V*/
	/*  58  */	'E',	/*E*/
	/*  59  */	'Z',	/*Z*/
	/*  60  */	'D',	/*D*/
	/*  61  */	'B',	/*B*/
	/*  62  */	'S',	/*S*/
	/*  63  */	'Y',	/*Y*/
	/* from here on are actually code 1-45, upper half of font */
	/*  64  */	'F',	/*F*/
	/*  65  */	'X',	/*X*/
	/*  66  */	'A',	/*A*/
	/*  67  */	'W',	/*W*/
	/*  68  */	'J',	/*J*/
	/*  69  */	'U',	/*U*/
	/*  70  */	'K',	/*K*/
	/*  71  */	'0',	/*0*/
	/*  72  */	'1',	/*1*/
	/*  73  */	'2',	/*2*/
	/*  74  */	'3',	/*3*/
	/*  75  */	'4',	/*4*/
	/*  76  */	'5',	/*5*/
	/*  77  */	'6',	/*6*/
	/*  78  */	'7',	/*7*/
	/*  79  */	'8',	/*8*/
	/*  80  */	'9',	/*9*/
	/*  81  */	'*',	/***/
	/*  82  */	'-',	/*minus*/
	/*  83  */	UNASS,	/*fi*/
	/*  84  */	UNASS,	/*fl*/
	/*  85  */	UNASS,	/*ff*/
	/*  86  */	0xa2,	/*cent sign*/
	/*  87  */	UNASS,	/*ffl*/
	/*  88  */	UNASS,	/*ffi*/
	/*  89  */	'(',	/*(*/
	/*  90  */	')',	/*)*/
	/*  91  */	'[',	/*[*/
	/*  92  */	']',	/*]*/
	/*  93  */	UNASS,	/*degree*/
	/*  94  */	UNASS,	/*dagger*/
	/*  95  */	'=',	/*=*/
	/*  96  */	0xa8,	/*registered*/
	/*  97  */	':',	/*:*/
	/*  98  */	'+',	/*+*/
	/*  99  */	UNASS,	/*unassigned*/
	/* 100  */	'!',	/*!*/
	/* 101  */	0xd7,	/*bullet*/
	/* 102  */	'?',	/*?*/
	/* 103  */	UNASS,	/*foot mark*/
	/* 104  */	'|',	/*|*/
	/* 105  */	UNASS,	/*unassigned*/
	/* 106  */	0xa9,	/*copyright*/
	/* 107  */	UNASS,	/*square*/
	/* 108  */	'$'	/*$*/
};

flashrast(ch, points, ftype)
int	ch, points, ftype; {
	register int idx = flashtovfnt[ch];
	register int i,j,H,V;
	register unsigned char *bp;
	V = D[idx].up + D[idx].down;
	H = (D[idx].left + D[idx].right + 7) / 8;
	bp = &imageTable[D[idx].addr];
	DEBUGPRINTF("ch=%d,idx=%d,V=%d,H=%d\n", ch, idx, V, H);
	printf("\033&a-%dV", (D[idx].up * 720) / dpi);
	printf("\033*t%dR", dpi);
	for (i = 0; i < V; i++) {
		printf("\033*r1A");
		printf("\033*b%dW", H);
		for (j = 0; j < H; j++)
			putchar(*bp++);
	}
	printf("\033*rB");
}
