/*
 * otwrite.c -- dump an internal driver-table representation in old-nroff form
 *
 * This code brought to you as a public service by Eric S. Raymond, Feb 1988
 * and is copyrighted (c)1988 by the author. Use, distribute, and mangle
 * freely, but don't try to make money selling it unless you're going to send
 * me a cut. Send bug reports, love letters and death threats to eric@snark
 * aka ...!rutgers!vu-vlsi!snark!eric.
 *
 * This stuff was Bruce Townsend & Ian Darwin's table.c code in a former life,
 * but the data structures are different and cleaner now.
 */
/*LINTLIBRARY*/
#include <stdio.h>
#include "termtab.h"

extern char *strcpy();
extern void exit();

static void addchar(string, pp)
char	*string;
strtab	*pp;
{
    pp->c_pointer[pp->n_strings] = pp->c_end;
    pp->c_end += (pp->c_length[pp->n_strings] = strlen(string + 2) + 2) + 1;
    if (pp->c_end >= pp->c_data + C_SIZE)
    {
	(void) fprintf(stderr, "Table size too small, increase it!\n");
	exit(1);
    }
    /*
     * copy in the first two bytes without checking for a NUL, this is
     * so we handle the (legal!) case of 0-length characters correctly
     */
    *pp->c_pointer[pp->n_strings] = *string++;
    *(pp->c_pointer[pp->n_strings]+1) = *string++;

     /* now copy the rest */
    (void) strcpy(pp->c_pointer[pp->n_strings++] + 2, string);
}

static int findchar(string, pp)
strtab	*pp;
char	*string;
{
    int	c_len, s_len, i;

    for (i = 0; i < pp->n_strings; i++)
    {
	if ((c_len = pp->c_length[i]) >= (s_len = strlen (string+2) + 2))
	{
	    if (!char_comp (string, pp->c_pointer[i] + c_len - s_len, s_len))
		return (pp->c_pointer[i] + c_len - s_len - pp->c_data);
	}
    }
    (void) fprintf(stderr,
		   "Serious bug! character %s not found in table\n", string);
    exit(1);
    /* NOTREACHED */
}

static void write_err()
{
    (void) fprintf(stderr, "Write to file failed\n");
    exit(1);
}

void otwrite(tp, fp)
nrtab_t *tp;
FILE	*fp;
{
    int	i, j, i_len, j_len, ch;
    char	*tail, *start, *char_pointer;
    static nrext_t t_stor;
    static strtab otab;

    newstrings(&otab);

    /*
     * copy the integer values from the initialized structure
     * to the storage structure
     */
    t_stor.bset = tp->bset;
    t_stor.breset = tp->breset;
    t_stor.Hor = tp->Hor;
    t_stor.Vert = tp->Vert;
    t_stor.Newline = tp->Newline;
    t_stor.Char = tp->Char;
    t_stor.Em = tp->Em;
    t_stor.Halfline = tp->Halfline;
    t_stor.Adj = tp->Adj;

    /*
     * force an empty string with a 0-length head character to exist
     * at offset 0 of the otab string table
     */
    (void) addchar("\000\000", &otab);

    /*
     * copy control strings out of the in-core form into the otab string table
     */
    (void) addstring(tp->twinit, &otab);
    (void) addstring(tp->twrest, &otab);
    (void) addstring(tp->twnl, &otab);
    (void) addstring(tp->hlr, &otab);
    (void) addstring(tp->hlf, &otab);
    (void) addstring(tp->flr, &otab);
    (void) addstring(tp->bdon, &otab);
    (void) addstring(tp->bdoff, &otab);
    (void) addstring(tp->iton, &otab);
    (void) addstring(tp->itoff, &otab);
    (void) addstring(tp->ploton, &otab);
    (void) addstring(tp->plotoff, &otab);
    (void) addstring(tp->up, &otab);
    (void) addstring(tp->down, &otab);
    (void) addstring(tp->right, &otab);
    (void) addstring(tp->left, &otab);

    /* copy character expansions to the new table */
    for (ch = CHARMIN; ch < CHARMAX; ch++)
	if (tp->codetab[ch - CHARMIN] != (char *)NULL)
	    addchar(tp->codetab[ch - CHARMIN], &otab);

    /* eliminate strings which are tails of other strings */
    for (i = 0; i < otab.n_strings; i++)
    {
	if (!otab.c_pointer[i])
	    continue;	/* String cleared out */
	i_len = otab.c_length[i];
	for (j = 0; j < otab.n_strings; j++)
	{
	    if (i == j || ! otab.c_pointer[j]) continue;
	    j_len = otab.c_length[j];
	    if (i_len <= j_len)	/* string i could be tail of string j */
	    {
		tail = otab.c_pointer[j] + j_len - i_len;
		if (! char_comp(otab.c_pointer[i], tail, i_len)) {
		    otab.c_pointer[i] = 0;
		    break;
		}
	    }
	}
    }

    /* Compress the otab.c_data array */
    char_pointer = otab.c_data;
    for (i = j = 0; i < otab.n_strings; i++)
    {
	if (! (start = otab.c_pointer[i]))
	    continue;
	otab.c_pointer[j] = char_pointer;
	otab.c_length[j++] = otab.c_length[i];
	for (i_len = otab.c_length[i]; i_len--;)
	    *char_pointer++ = *start++;
	*char_pointer++ = 0;
    }
    otab.n_strings = j;
    otab.c_size = char_pointer - otab.c_data;

    /* Now find each string in this table and provide an index to it */
    t_stor.twinit = findstring(tp->twinit, &otab);
    t_stor.twrest = findstring(tp->twrest, &otab);
    t_stor.twnl = findstring(tp->twnl, &otab);
    t_stor.hlr = findstring(tp->hlr, &otab);
    t_stor.hlf = findstring(tp->hlf, &otab);
    t_stor.flr = findstring(tp->flr, &otab);
    t_stor.bdon = findstring(tp->bdon, &otab);
    t_stor.bdoff = findstring(tp->bdoff, &otab);
    t_stor.iton = findstring(tp->iton, &otab);
    t_stor.itoff = findstring(tp->itoff, &otab);
    t_stor.ploton = findstring(tp->ploton, &otab);
    t_stor.plotoff = findstring(tp->plotoff, &otab);
    t_stor.up = findstring(tp->up, &otab);
    t_stor.down = findstring(tp->down, &otab);
    t_stor.right = findstring(tp->right, &otab);
    t_stor.left = findstring(tp->left, &otab);

    for (ch = CHARMIN; ch < CHARMAX; ch++)
	if (tp->codetab[ch-CHARMIN] == (char *)NULL)
	    t_stor.codetab[ch-CHARMIN] = 0;	/* empty expansion */
	else
	    t_stor.codetab[ch-CHARMIN]=findchar(tp->codetab[ch-CHARMIN],&otab);

    t_stor.zzz = 0;

    /* Write the character storage block size */
    if (fwrite((char *)&otab.c_size, sizeof(otab.c_size), 1, fp) != 1)
	write_err();

    /* now the fixed part */
    if (fwrite(&t_stor, sizeof(t_stor), 1, fp) != 1)
	write_err();

    /* finally, write the code table */
    if (fwrite(otab.c_data,sizeof(*otab.c_data),otab.c_size,fp) != otab.c_size)
	write_err();
}

/* otwrite.c ends here */
