/*
 * otread.c -- read a driver table in old nroff format into core
 *
 * Use this function to read an old-nroff-style driver table into the
 * internal form given in the term.h header file. Note that the terminal
 * name slot is *not* filled in.
 *
 * This function will return NULL if the input file is too short (i.e its
 * length is less than sizeof(int) + sizeof(t_stor) + the byte count
 * in the file's first int). It will also return NULL if it finds an offset
 * larger than the string table size.
 *
 * Warning: the driver structure pointer handed back uses static storage,
 * a second otread() call will overwrite it.
 *
 * Also, the code performs mildly unnatural acts on some structure fields.
 * See the last comment before the end of the routine and beware. If the
 * method fails it's more than likely to result in garbaged pointers in the
 * returned internal-representation structure and core dumps later on.
 *
 * This code brought to you as a public service by Eric S. Raymond, Feb 1988
 * and is copyrighted (c)1988 by the author. Use, distribute, and mangle
 * freely, but don't try to make money selling it unless you're going to send
 * me a cut. Send bug reports, love letters and death threats to eric@snark
 * aka ...!rutgers!vu-vlsi!snark!eric.
 */
/*LINTLIBRARY*/
#include <stdio.h>
#include "termtab.h"

extern char *malloc();

nrtab_t *otread(tfp)
FILE *tfp;
{
    int		c_size, *ip;
    register char	**pp, *mptr;
    static nrext_t	external;
    static nrtab_t	internal;

    /* string table size */
    if (fread((char *)&c_size, sizeof(int), 1, tfp) != 1)
	return((nrtab_t *)NULL);

    /* fixed-size header part */
    if (fread((char *)&external, sizeof(external), 1, tfp) != 1)
	return((nrtab_t *)NULL);

    /* now read the strings table into core */
    if (fread(mptr = malloc((unsigned)c_size), c_size, 1, tfp) != 1)
	return((nrtab_t *)NULL);

    internal.bset = external.bset;
    internal.breset = external.breset;
    internal.Hor = external.Hor;
    internal.Vert = external.Vert;
    internal.Newline = external.Newline;
    internal.Char = external.Char;
    internal.Em = external.Em;
    internal.Halfline = external.Halfline;
    internal.Adj = external.Adj;

    /*
     * Wooo-ah! Tricky-shit alert! We step through the fields of the external
     * and internal representation structures as though they were arrays of
     * (int) and (char *) respectively. C's structure-padding rules *seem*
     * to almost guarantee this will work, but I wouldn't bet the farm on it
     * given some of the weird broken architectures and compilers out there.
     */
    for (ip = &external.twinit, pp = &internal.twinit; pp < &internal.zzz; )
	if (*ip > c_size)
	    return((nrtab_t *)NULL);
	else
	    *pp++ = mptr + *ip++;

    return(&internal);
}

/* otread.c ends here */
