/* termtab.h -- declaration of nroff terminal driver internal representation */

/* you'll probably never need to change these */
#define CHARMIN	32			/* minimum ASCII char nroff uses */
#define CHARMAX	256			/* size of ASCII character set */

#define C_SIZE	10000	/* The maximum amount of character data allowed
			   in the initialized structure t - increase if
			   necessary */

typedef struct    /* string table internals */
{
    char	c_data[C_SIZE];
    char	*c_pointer[CHARMAX - CHARMIN];
    int		c_length[CHARMAX - CHARMIN];
    char	*c_end;
    int		n_strings, c_size;
}
strtab;

typedef struct
{
    char *name;
    int bset;
    int breset;
    int Hor;
    int Vert;
    int Newline;
    int Char;
#ifdef KANJI
    int Kchar;
#endif KANJI
    int Em;
    int Halfline;
    int Adj;
    char *twinit;
    char *twrest;
    char *twnl;
    char *hlr;
    char *hlf;
    char *flr;
    char *bdon;
    char *bdoff;
    char *iton;
    char *itoff;
    char *ploton;
    char *plotoff;
    char *up;
    char *down;
    char *right;
    char *left;
    char *codetab[CHARMAX - CHARMIN];
    char *zzz;

    strtab	pool;
}
nrtab_t;

/*
 * The format of an old-style tab file is:
 *
 * Type	Name		Size on most machines	Description
 * ----	----		---------------------	-----------
 * int	c_size		4 bytes	- The amount of character data in bytes
 *				that follows the t_stor structure.
 *
 * nrext_t oldform	1000 bytes - This is the storage for the "t"
 *			structure with one change. All the elements
 *			of the t structure which were pointers to
 *			strings are now integer indexes to one
 *			large character array.
 *
 * char	array[c_size]	(variable size)- This is the storage for the strings
 *			pointed to by the indexes.
 *
 * The total size of the tabfile in bytes should be:
 *	c_size + sizeof (c_size) + sizeof (t_stor)
 */

typedef struct		/* This structure will be stored in the tab file */
{
    int bset;
    int breset;
    int Hor;
    int Vert;
    int Newline;
    int Char;
    int Em;
    int Halfline;
    int Adj;
    int twinit;
    int twrest;
    int twnl;
    int hlr;
    int hlf;
    int flr;
    int bdon;
    int bdoff;
    int iton;
    int itoff;
    int ploton;
    int plotoff;
    int up;
    int down;
    int right;
    int left;
    int codetab[CHARMAX - CHARMIN];
    int zzz;
}
nrext_t;

extern char *ntnames[];
extern void newstrings();
extern char *addstring();
extern int char_comp(), findstring();
extern nrtab_t *ditread(), *otread();
extern void ditwrite(), otwrite();

/* termtab.h ends here */
