/*
 * termtab.c -- common declarations for nroff table conversion
 *
 * This code brought to you as a public service by Eric S. Raymond, Feb 1988
 * and is copyrighted (c)1988 by the author. Use, distribute, and mangle
 * freely, but don't try to make money selling it unless you're going to send
 * me a cut. Send bug reports, love letters and death threats to eric@snark
 * aka ...!rutgers!vu-vlsi!snark!eric.
 */
/*LINTLIBRARY*/
#include <stdio.h>
#include "termtab.h"

extern char *strcpy();
extern void exit();

char *ntnames[] =	/* [nt]roff character name translation */
{
" ", "!","\"", "#", "$", "%", "&", "'",
"(", ")", "*", "+", ",", "-", ".", "/",
"0", "1", "2", "3", "4", "5", "6", "7",
"8", "9", ":", ";", "<", "=", ">", "?",
"@", "A", "B", "C", "D", "E", "F", "G",
"H", "I", "J", "K", "L", "M", "N", "O",
"P", "Q", "R", "S", "T", "U", "V", "W",
"X", "Y", "Z", "[", "\\","]", "^", "_",
"`", "a", "b", "c", "d", "e", "f", "g",
"h", "i", "j", "k", "l", "m", "n", "o",
"p", "q", "r", "s", "t", "u", "v", "w",
"x", "y", "z", "{", "|", "}", "~","\\|",
"hy", "bu", "sq", "em", "ru", "14", "12", "34", 
"\\-","fi", "fl", "ff", "Fi", "Fl", "de", "dg", 
"sc", "fm", "aa", "ga", "ul", "sl", "\\^", "\\ ", 
"*a", "*b", "*g", "*d", "*e", "*z", "*y", "*h", 
"*i", "*k", "*l", "*m", "*n", "*c", "*o", "*p", 
"*r", "*s", "*t", "*u", "*f", "*x", "*q", "*w", 
"*G", "*D", "*H", "*L", "*C", "*P", "*S", "*T", 
"*U", "*F", "*Q", "*W", "sr", "ts", "rn", ">=", 
"<=", "==", "mi", "~=", "ap", "!=", "->", "<-", 
"ua", "da", "eq", "mu", "di", "+-", "cu", "ca", 
"sb", "sp", "ib", "ip", "if", "pd", "gr", "no", 
"is", "pt", "es", "mo", "pl", "rg", "co", "br", 
"ct", "dd", "rh", "lh", "**", "bs", "or", "ci", 
"lt", "lb", "rt", "rb", "lk", "rk", "bv", "lf", 
"rf", "lc", "rc",
(char *)NULL
 };

void newstrings(sp)
strtab *sp;
{
    sp->c_end = sp->c_data;
}

char *addstring(string, pp)
strtab	*pp;
char	*string;
{
    pp->c_pointer[pp->n_strings] = pp->c_end;
    pp->c_end += (pp->c_length[pp->n_strings] = strlen(string)) + 1;
    if (pp->c_end >= pp->c_data + C_SIZE)
    {
	(void) fprintf(stderr, "Table size too small, increase it!\n");
	exit(1);
    }
    return(strcpy(pp->c_pointer[pp->n_strings++], string));
}

int char_comp(str1, str2, len)
char	*str1, *str2;
int	len;
{
    while (len--)
	if (*str1++ != *str2++)
	    return(1);
    return(0);
}

int findstring(string, pp)
strtab	*pp;
char	*string;
{
    int	c_len, s_len, i;

    for (i = 0; i < pp->n_strings; i++)
    {
	if ((c_len = pp->c_length[i]) >= (s_len = strlen(string))) {
	    if (!char_comp (string, pp->c_pointer[i] + c_len - s_len, s_len))
		return (pp->c_pointer[i] + c_len - s_len - pp->c_data);
	}
    }
    (void) fprintf(stderr, "Serious bug! string not found in table\n");
    exit(1);
    /* NOTREACHED */
}

/* termtab.c ends here */
