/*
 * ditwrite.c -- dump an internal driver-table representation in ditroff form
 *
 * Dumps a driver-table structure in all-ASCII ditroff format. Uses octal
 * escape and \b, \t, \n, \r for nonprintable characters.
 *
 * This code brought to you as a public service by Eric S. Raymond, Feb 1988
 * and is copyrighted (c)1988 by the author. Use, distribute, and mangle
 * freely, but don't try to make money selling it unless you're going to send
 * me a cut. Send bug reports, love letters and death threats to eric@snark
 * aka ...!rutgers!vu-vlsi!snark!eric.
 */
/*LINTLIBRARY*/
#include <stdio.h>
#include <ctype.h>
#include "termtab.h"

static void tdump(fp, label, val)
/* dump a string (in quotes) with a given label prepended */
FILE *fp;
char *label;
char *val;
{
    if (val != (char *)NULL)
    {
	char outbuf[BUFSIZ];

	(void) expand(val, outbuf);
	(void) fprintf(fp, "%-12s\"%s\"\n", outbuf, label);
    }
}

static void cdump(fp, label, width, val)
/* dump a character with its width */
FILE *fp;
char *label;
int width;
char *val;
{
    if (val != (char *)NULL)
    {
	char outbuf[BUFSIZ];

	(void) expand(val, outbuf);
	(void) fprintf(fp, "%s %d %s\n", outbuf, label, width);
    }
}

void ditwrite(tp, fp)
nrtab_t *tp;
FILE	*fp;
{
    register char **ctab = tp->codetab;

    /* first, dump integer parameters */
    (void) fprintf(fp, "bset        %d\n", tp->bset);
    (void) fprintf(fp, "breset      %d\n", tp->breset);
    (void) fprintf(fp, "Hor         %d\n", tp->Hor);
    (void) fprintf(fp, "Vert        %d\n", tp->Vert);
    (void) fprintf(fp, "Newline     %d\n", tp->Newline);
    (void) fprintf(fp, "Char        %d\n", tp->Char);
#ifdef KANJI
    (void) fprintf(fp, "Kchar        %d\n", tp->Kchar);
#endif KANJI
    (void) fprintf(fp, "Em          %d\n", tp->Em);
    (void) fprintf(fp, "Halfline    %d\n", tp->Halfline);
    (void) fprintf(fp, "Adj         %d\n", tp->Adj);

    /* next, dump standard control strings */
    tdump(fp, "twinit", tp->twinit);
    tdump(fp, "twrest", tp->twrest);
    tdump(fp, "twnl", tp->twnl);
    tdump(fp, "hlr", tp->hlr);
    tdump(fp, "hlf", tp->hlf);
    tdump(fp, "flr", tp->flr);
    tdump(fp, "bdon", tp->bdon);
    tdump(fp, "bdoff", tp->bdoff);
    tdump(fp, "iton", tp->iton);
    tdump(fp, "itoff", tp->itoff);
    tdump(fp, "ploton", tp->ploton);
    tdump(fp, "plotoff", tp->plotoff);
    tdump(fp, "up", tp->up);
    tdump(fp, "down", tp->down);
    tdump(fp, "right", tp->right);
    tdump(fp, "left", tp->left);

    /* finally, dump the character table */
    (void) fputs("\ncharset\n", fp);
    for (ctab = ntnames; ctab[0] != (char *)NULL; ctab++)
    {
	char *cstr = tp->codetab[ctab - ntnames];

	if ((cstr[0] || cstr[1]) && strcmp(ctab[0], cstr + 1))
	    cdump(fp, ctab[0], cstr[0], cstr + 1);
    }
}

/* ditwrite.c ends here */
