/*
 * convtab.c -- convert old nroff driver tables to new form and vice-versa
 *
 * This main calls four functions dit{read,write} and ot{read,write} which seal
 * away the operations of reading and writing new (dit*) and old (ot*) style
 * nroff driver tables. All set up or read from the common nrtab_t structure.
 *
 * Common accesses to the structure are implemented in termtab.c, which
 * contains code for a flavor of string storage pool that both use. The
 * escapes.c module provides common character-escape and escape-expansion
 * handling.
 *
 * This code brought to you as a public service by Eric S. Raymond, Feb 1988
 * and is copyrighted (c)1988 by the author. Use, distribute, and mangle
 * freely, but don't try to make money selling it unless you're going to send
 * me a cut. Send bug reports, love letters and death threats to eric@snark
 * aka ...!rutgers!vu-vlsi!snark!eric.
 */
/*LINTLIBRARY*/
#include <stdio.h>
#include "termtab.h"

extern char *mktemp(), *strcpy();
extern void perror();

extern int ignorebad;	/* ditread.o supplies this */

main(argc, argv)
int argc;
char *argv[];
{
    int verbose = 0, debug = 0, filecount = 0;
    FILE *ifp, *ofp;
    nrtab_t *ttab;
    extern errno;

    for (++argv, --argc; argc; argv++, argc--)
    {
	char sw = argv[0][0];
	char opt = argv[0][1];

	if (sw == '-' || sw == '+')	/* a switch argument */
	{
	    switch(opt)
	    {
	    case 'x':
		ignorebad = (sw == '-');
		if (verbose)
		    (void) printf("convtab: ignorebad %s\n",
				  ignorebad ? "set" : "cleared");
		break;

	    case 'v':
		verbose = (sw == '-');
		if (verbose)
		    (void) printf("convtab: verbose %s\n",
				  verbose ? "set" : "cleared");
		break;

	    case 'd':
		if (debug = (sw == '-'))
		    verbose = 1;
		if (verbose)
		    (void) printf("convtab: debug %s\n",
				  debug ? "set" : "cleared");
		break;
	    }
	}
	else				/* a filename argument */
	{
	    char target[BUFSIZ];
	    char tempf[20];

	    filecount++;

	    (void) strcpy(tempf, "/tmp/convtabXXXXX");
	    (void) mktemp(tempf);

	    if (strncmp(argv[0], "tab.", 4) == 0)
	    {
		(void) sprintf(target, "tab%s", argv[0] + 4);
		if (verbose)
		    (void) fprintf(stderr,
			"convtab: %s (ditroff format) to %s (old format)\n",
			argv[0], target);
		if (!debug)
		{
		    ifp = fopen(argv[0], "r");
		    ofp = fopen(tempf, "w");

		    ttab = ditread(ifp);
		    otwrite(ttab, ofp);

		    if (unlink(target) == -1)
			perror("convtab (unlink failed)");
		    if (link(tempf, target) == -1)
			perror("convtab (link failed)");
		    if (unlink(tempf) == -1)
			perror("convtab (unlink failed)");
		}
	    }
	    else if (strncmp(argv[0], "tab", 3) == 0)
	    {
		(void) sprintf(target, "tab.%s", argv[0] + 3);
		if (verbose)
		    (void) fprintf(stderr,
			"convtab: %s (old format) to %s (ditroff format)\n",
			argv[0], target);
		if (!debug)
		{
		    ifp = fopen(argv[0], "r");
		    ofp = fopen(tempf, "w");

		    ttab = otread(ifp);
		    (void) fprintf(ofp, "%s\n", target + 4);
		    ditwrite(ttab, ofp);

		    if (unlink(target) == -1)
			perror("convtab (unlink failed)");
		    if (link(tempf, target) == -1)
			perror("convtab (link failed)");
		    if (unlink(tempf) == -1)
			perror("convtab (unlink failed)");
		}
	    }
	    else
		(void) fprintf(stderr,
			   "convtab: skipping %s, (name prefix no good)\n",
			   argv[0]);
	}
    }

    /* no filenames given? that's OK, just convert new to old as a filter */
    if (filecount == 0)
    {
	ttab = ditread(ifp);
	otwrite(ttab, ofp);
    }

    return(0);
}

/* convtab.c ends here */
