static char *RCSid = "$Header: makedesc.c,v 1.1 87/10/23 19:08:09 sysad Exp $";

/* Read an ascii description of a ditroff font and create the         */
/* corresponding binary font files                                    */


/*
 * $Log:	makedesc.c,v $
 * Revision 1.1  87/10/23  19:08:09  sysad
 * Initial revision
 * 
 * 
 */

#include <stdio.h>
#include <sys/file.h>
#include "dev.h"

#define	SHORT	0xffff
#define	MAXP	128		/* allocate space for point sizes in MAXP chunks */
int compat = 0;		/* compatibility with att "makedev"; duplicate "width"
					 * entries are re-used if this is non-zero.
					 */
char *Progname;
struct dev dev;
extern char *malloc(),*nextword(),*savestr();
extern char **font_names(),*fgets();
extern FILE *fopen();
extern short *p_sizes();

main(argc,argv)
int argc;
char **argv;
{
	FILE *inptr;
	int fdout,nchtab,lchname,i,fsize,biggestfont;
	long fontf_start;
	short *point_list,*funny_ind;
	char *funny_chars;
	char **font_list;
	char mybuf[1024];
	char *str,*descfile;

	Progname = argv[0];
	++argv; --argc;

	if(strcmp(*argv,"-c") == 0)
	{
		++compat;
		++argv;
		--argc;
	}
	if(argc == 0)
	{
		descfile = "DESC";
	}
	else if(argc == 1)
	{
		descfile = argv[0];
	}
	else
	{
		fprintf(stderr,"usage: %s [-c] [descfile]\n",Progname);
		exit(1);
	}

	if((inptr = fopen(descfile,"r")) == (FILE *)0)
	{
		fprintf(stderr,"%s: can't open %s\n",Progname,descfile);
		exit(2);
	}
	sprintf(mybuf,"%s.out",descfile);
	if((fdout = open(mybuf,O_CREAT | O_WRONLY,0644)) < 0)
	{
		fprintf(stderr,"%s: can't create %s\n",Progname,mybuf);
		exit(2);
	}
	dev.filesize = (short)0;
	dev.sizescale = (short)1;
	biggestfont = 0;
	dev.spare = (short)0;
	/* Build the dev structure first */
	while(fgets(mybuf,1024,inptr))
	{
start:	/* we come back here if we read ahead in a font_names() */
		if(!*mybuf || (*mybuf == '#'))
			continue;
		nextword("");	/* reset to beginning of line */
		/* printf("line = %s\n",mybuf); */
		str = nextword(mybuf);
		if(strcmp(str,"charset") == 0)
			break;
		if(strcmp(str,"res") == 0)
			dev.res = (short)atoi(nextword(mybuf));
		else if(strcmp(str,"hor") == 0)
			dev.hor = (short)atoi(nextword(mybuf));
		else if(strcmp(str,"vert") == 0)
			dev.vert = (short)atoi(nextword(mybuf));
		else if(strcmp(str,"unitwidth") == 0)
			dev.unitwidth = (short)atoi(nextword(mybuf));
		else if(strcmp(str,"sizescale") == 0)
			dev.sizescale = (short)atoi(nextword(mybuf));
		else if(strcmp(str,"paperwidth") == 0)
			dev.paperwidth = (short)atoi(nextword(mybuf));
		else if(strcmp(str,"paperlength") == 0)
			dev.paperlength = (short)atoi(nextword(mybuf));
		else if(strcmp(str,"biggestfont") == 0)
		{
			biggestfont = atoi(nextword(mybuf));
			dev.biggestfont = (short)biggestfont;
		}
		else if(strcmp(str,"sizes") == 0)
		{
			/* accumulate the list of legal point sizes */
			point_list = p_sizes(inptr,mybuf,&dev);
		}
		else if(strcmp(str,"fonts") == 0)
		{
			dev.nfonts = (short)atoi(nextword(mybuf));
			font_list = font_names(inptr,mybuf,dev.nfonts);
			goto start;
		}
	}
	nextword("");
	/* Next comes the funny index table and the character strings; read
	 * the description and stuff the information into the binary format 
	 * tables.
	 */
	if(fgets(mybuf,1024,inptr) == (char *)0)
	{
		fprintf(stderr,"%s: no funny char strings table\n",Progname);
		exit(1);
	}
	nchtab = get_funny(inptr,mybuf,&funny_ind,&funny_chars,&lchname);
	dev.nchtab = (short)nchtab;
	dev.lchname = (short)lchname;

	/* We don't have enough information yet to write the dev structure
	 * (don't know how many fonts, or their names...).  We do know how
	 * big it is, and how long the description tables are, so we seek
	 * past all that stuff andd write the font descriptions first.
	 * Later, we'll go back and write the stuff we skipped over.
	 */
	fontf_start = (long)(sizeof(dev) + ((dev.nsizes +1) * sizeof(short))
					+ (nchtab * sizeof(short)) + lchname);
	(void)lseek(fdout,fontf_start,0);

	/* Read the font files, and write the binary equivalents */
	for(i = 0; i < (int)dev.nfonts; ++i)
	{
		fsize = do_font(font_list[i],funny_chars,funny_ind,nchtab,fdout);
		/* keep track of the biggest font */
		if(fsize > biggestfont)
			biggestfont = fsize;
	}
	dev.biggestfont = (short)(biggestfont & SHORT);
	dev.filesize = (unsigned short)(lseek(fdout,0L,2) - sizeof(dev));
	write_desc(fdout,&dev,point_list,funny_ind,funny_chars);
	exit(0);
}

/* Read the point sizes list */

short *
p_sizes(inptr,buf,dev)
FILE *inptr;
char *buf;
struct dev *dev;
{
	short *pl,*ret;
	char *word,*realloc();
	int nwords = 0;
	int n;

	/* allow for MAXP point sizes; we have to reallocate if we exceed that */
	ret = pl = (short *)malloc((unsigned)(MAXP * sizeof(short)));
	if(!pl)
	{
		fprintf(stderr,"can't malloc space for psizes\n",Progname);
		exit(1);
	}
	n = 1;
	while((word = nextword(buf)) || fgets(buf,1024,inptr))
	{
		if(!word)
		{
			nextword("");
			word = nextword(buf);
		}
		if(!word)	/* ran out of words this line, had to fgets more */
		{
			nextword("");
			if(fgets(buf,1024,inptr))
				word = nextword(buf);
			else
			{
				*buf = '\0';
				break;
			}
		}
		nwords++;
		if(nwords >= MAXP)
		{
			/* Oops! ran out os space; get more */
			ret = (short *)realloc((char *)ret,(unsigned)(MAXP * ++n * sizeof(short)));
			pl = &ret[nwords];	/* could have moved */
		}
		*pl = (short)atoi(word);
		if(*pl == (short)0)
			break;
		++pl;
	}
	/* don't count the zero at the end */
	--nwords;
	dev->nsizes = (short)nwords;
	return(ret);
}

/* Read and save the font names; return the list */

char **
font_names(inptr,buf,nfonts)
FILE *inptr;
char *buf;
short nfonts;
{
	char **ret,**next;
	char *word;
	int nwords = 0;

	ret = next = (char **)malloc((unsigned)((nfonts + 1) * sizeof(char *)));

	while((word = nextword(buf)) || fgets(buf,1024,inptr))
	{
		if(!word)
		{
			nextword("");
			word = nextword(buf);
		}
		*next++ = savestr(word);
		if(++nwords >= (int)nfonts)
		{
			/* main() expects a new buffer */
			fgets(buf,1024,inptr);
			break;
		}
	}
	*next = (char *)0;
	if(nwords != (int)nfonts)
		printf("%s: warning; only got %d of %d font names\n",Progname,nwords,(int)nfonts);
	return(ret);
}


/* Read the special character strings, and set up the string table and
 * the index into it.
 */
get_funny(inptr,mybuf,funny_ind,funny_chars,lchname)
FILE *inptr;
char *mybuf;
short **funny_ind;
char **funny_chars;
int *lchname;
{
	char *fct;	/* funny char string table */
	short *fci; /* funny char index		   */
	int i = 0;
	int lastp = 0;
	char *str;

	/* allocate for 256 3-character strings (plus null) 			*/
	/* We should probably check for overflow, but I can't imagine a	*/
	/* character set with more than 256 special chars (FLW)			*/

	*funny_chars = fct = malloc((unsigned)768);
	*funny_ind = fci = (short *)malloc((unsigned)(257 * sizeof(short)));

	/* assume the strings start on a new line */
	fci[0] = (short)0;
	while((str = nextword(mybuf)) || fgets(mybuf,1024,inptr))
	{
		if(!str)
		{
			nextword("");
			str = nextword(mybuf);
			if(!str)
				continue;
		}
		(void)strcpy(fct + lastp,str);
		fci[i++] = (short)(lastp & SHORT);
		lastp += strlen(str) + 1;
		if(i > 256)
		{
			fprintf(stderr,"%s: too many special strings (> 256)\n",Progname);
			break;
		}
	}
	fci[i++] = (short)0;
	*lchname = lastp;
	return(i);
}

/* Write out the dev structure,the sizes table, and the funny char tables */
write_desc(fdout,dev,point_list,funny_ind,funny_chars)
int fdout;
struct dev *dev;
short *point_list,*funny_ind;
char *funny_chars;
{

	long l;

	/* Seek back to the beginning of the file */

	(void)lseek(fdout,0L,0);

	/* dev structure */
	if(write(fdout,(char *)dev,sizeof(struct dev)) != sizeof(struct dev))
	{
		fprintf(stderr,"%s: write dev struct to description file failed\n",Progname);
		exit(1);
	}

	/* point sizes table */
	if(write(fdout,(char *)point_list,(int)(dev->nsizes +1) * 2) != (int)(dev->nsizes + 1) * 2)
	{
		fprintf(stderr,"%s: write size list to description file failed\n",Progname);
		exit(1);
	}

	/* table of indexes into special char strings */
	if(write(fdout,(char *)funny_ind,(int)(dev->nchtab * 2)) != (int)(dev->nchtab * 2))
	{
		fprintf(stderr,"%s: write index list to description file failed\n",Progname);
		exit(1);
	}

	/* special char strings */
	if(write(fdout,funny_chars,(int)(dev->lchname)) != (int)(dev->lchname))
	{
		fprintf(stderr,"%s: write funny char strings to description file failed\n",Progname);
		exit(1);
	}
	l = lseek(fdout,0L,1);
}
