static char *RCSid = "$Header: readdesc.c,v 1.1 87/10/23 19:08:14 sysad Exp $";

/*
 * $Log:	readdesc.c,v $
 * Revision 1.1  87/10/23  19:08:14  sysad
 * Initial revision
 * 
 * 
 */

/* Read a binary "ditroff" font file and write an ascii equivalent.   */
/* The written file is in a form which may be re-compiled.            */
/*                                                                    */

#include <stdio.h>
#include <sys/file.h>
#include "dev.h"

#ifdef SYS5
#define	rindex		strrchr
#endif

#define	SHORT	0xffff

char *Progname;
struct dev dev;
extern char *malloc(),*rdfont(),*rindex();

/* debugging is always compiled off; use adb to set or unset it	*/
int debugging = 0;		/* prints tables to stdout if set		*/

main(argc,argv)
int argc;
char **argv;
{
	int fd,devsize,pointsizes,indexsize,funnysize,i;
	short *points,*char_ind;
	char *funny_chars,*ptr;
	char **font_list,**fl;
	char descbuf[256];
	FILE *descfile;
	char *descfn;

	Progname = argv[0];
	if(argc > 2)
	{
		fprintf(stderr,"usage: %s [descfile]\n",Progname);
		exit(1);
	}
	else if(argc == 2)
		descfn = argv[1];
	else
		descfn = "DESC.out";

	if((fd = open(descfn,0,0)) < 0)
	{
		fprintf(stderr,"%s: can't open %s\n",Progname,descfn);
		exit(2);
	}
	/* copy the name, strip the ".out", and replace it with ".new
	 * to get the name of the new ascii file.
	 */
	sprintf(descbuf,"%s",descfn);
	ptr = rindex(descbuf + 4,'.');
	if(ptr)
		*ptr = '\0';
	strcat(descbuf,".new");
	if((descfile = fopen(descbuf,"w")) == (FILE *)0)
	{
		fprintf(stderr,"%s: can't open new description file %s for writing\n",
				Progname,descbuf);
		exit(1);
	}

	/* Get the dev structure from the description file */
	devsize = read(fd,(char *)&dev,sizeof(dev));
	if(devsize != sizeof(dev))
	{
		fprintf(stderr,"%s: should have been %u bytes\n",Progname,sizeof(dev));
		exit(3);
	}

	/* Allocate space for the sizes array, then read it in */
	points = (short *)malloc((unsigned)(2 * (dev.nsizes + 1)));
	pointsizes = read(fd,(char *)points,2 *(dev.nsizes + 1));
	pointsizes /= 2;
	if(--pointsizes != dev.nsizes)
	{
		fprintf(stderr,"%s: got %d of %d sizes\n",Progname,pointsizes,dev.nsizes);
		exit(3);
	}

	/* Now the funny char index table */
	char_ind = (short *)malloc((unsigned)(dev.nchtab * 2));
	funny_chars = malloc(dev.lchname);
	indexsize = read(fd,(char *)char_ind,dev.nchtab * 2);
	indexsize /= 2;
	if(indexsize != dev.nchtab)
	{
		fprintf(stderr,"%s: got %d of %d index entries\n",Progname,indexsize,dev.nchtab);
		exit(4);
	}

	/* Now the funny char strings themseleves */
	funnysize = read(fd,funny_chars,dev.lchname);
	if(funnysize != dev.lchname)
	{
		fprintf(stderr,"%s: got %d of %d funny chars\n",Progname,funnysize,dev.lchname);
		exit(5);
	}
	
    /* allocate array space to hold pointers to the font names, which */
    /* we accumulate as we read the font descriptions in rdfont().    */

	font_list = (char **)malloc((unsigned)(dev.nfonts * sizeof(char *)));
	fl = font_list;

    /* Now read the font descriptions, print the tables and grab the  */
    /* names String space for the names is allocated by rdfont(), so  */
    /* we don't have to worry about saving them here.                 */

	for(i = 0; i < dev.nfonts; ++i)
		*fl++= rdfont(fd,indexsize,funny_chars,char_ind);
	*fl = (char *)0;
	if(debugging)
		printf("\n\n\n\nwriting %s\n",descbuf);

	/* Now that we've read everything, we can print the ascii description
	 * file; first the stuff from dev, then the funny char strings.
	 */
	pr_dev(descfile,&dev,points,font_list);
	pr_funny(descfile,funny_chars,char_ind,indexsize);
	
	fl = font_list;
	if(debugging)
	{
		/* read the individual files, to see if they match */
		for(i = 0; i < dev.nfonts; ++i)
		{
			if(fd >= 0)
				close(fd);
			if(!*fl)
			{
				fprintf(stderr,"%s: font #%d--no name\n",Progname,i);
				++fl;
				continue;
			}
			sprintf(descbuf,"%s.out",*fl++);
			fprintf(stderr,"checking %s\n",descbuf);
			fd = open(descbuf,O_RDONLY,0);
			if(fd < 0)
				fprintf(stderr,"%s: can't open font file %s\n",Progname,*fl);
			else
				(void)rdfont(fd,indexsize,funny_chars,char_ind);
		}
	}
	exit(0);
}

/* Print the "dev" structure to DESC.new, describing the general      */
/* characteristics of the font style                                  */

pr_dev(descfile,dev,points,fontnames)
FILE *descfile;
struct dev *dev;
short *points;
char **fontnames;
{
	int npoints,i,j;

	/* The first three are printed for reference only, as comments.
	 * They won't be used by mkfont.
	 */
	fprintf(descfile,"#filesize %d\n",(int)(dev->filesize & SHORT));
	fprintf(descfile,"#nchtab %d\n",(int)(dev->nchtab & SHORT));
	fprintf(descfile,"#lchname %d\n",(int)(dev->lchname & SHORT));
	fprintf(descfile,"fonts %d\t",(int)(dev->nfonts & SHORT));
	pr_fonts(descfile,fontnames,(int)(dev->nfonts));
	fprintf(descfile,"\nsizes\t");

	npoints = (int)(dev->nsizes & SHORT);
	for(i=0;i < npoints; )
	{
		for(j=0; (j < 15) && (i < npoints); ++j,++i)
			fprintf(descfile,"%-4d",(int)(points[i] & SHORT));
		fprintf(descfile,"\n\t\t");
	}
	fprintf(descfile," 0\n");
	fprintf(descfile,"res %d\n",(int)(dev->res & SHORT));
	fprintf(descfile,"hor %d\n",(int)(dev->hor & SHORT));
	fprintf(descfile,"vert %d\n",(int)(dev->vert & SHORT));
	fprintf(descfile,"unitwidth %d\n",(int)(dev->unitwidth & SHORT));
	fprintf(descfile,"paperwidth %d\n",(int)(dev->paperwidth & SHORT));
	fprintf(descfile,"paperlength %d\n",(int)(dev->paperlength & SHORT));
	fprintf(descfile,"biggestfont %d\n",(int)(dev->biggestfont & SHORT));
	fprintf(descfile,"sizescale %d\n",(int)(dev->sizescale & SHORT));
}

/* Print the character set to DESC.new                                */

pr_funny(descfile,str,ind,nstr)
FILE *descfile;
char *str;
short *ind;
int nstr;
{
	int i,j,ent;
	char *s;

	fprintf(descfile,"charset\n");
	if(debugging)
		printf("\n\nFunny char table\n\nINDEX\tENT\tSTR\n");
	for(i = 0; i < nstr; )
	{
		for(j = 0; (i < nstr) && (j < 15); ++i,++j)
		{
			ent = (int)(ind[i] & SHORT);
			s = str+ent;
			if(*s == '\0')
				s = "??";
			if(debugging)
				printf("%d\t\t%d\t%s\n",i,ent,s);
			/* The funny index table is null-terminated */
			if((ent == 0) && (i != 0))
			{
				i = nstr;
				break;
			}
			fprintf(descfile,"%4.4s",str+ent);
		}
		fprintf(descfile,"\n");
	}
}

/* Print the names of the fonts to DESC.new.                          */

pr_fonts(descfile,names,nfonts)
FILE *descfile;
char **names;
int nfonts;
{
	int i;

	/* assume they fit on one line */
	if(!names)
		return;
	for(i = 0; i < nfonts; ++i)
	{
		if(names[i])
			fprintf(descfile," %s",names[i]);
		else
			fprintf(descfile," ??");
	}
	fprintf(descfile,"\n");
}
