static char *RCSid = "$Header: rdfont.c,v 1.1 87/10/23 19:08:13 sysad Exp $";

/*
 * $Log:	rdfont.c,v $
 * Revision 1.1  87/10/23  19:08:13  sysad
 * Initial revision
 * 
 * 
 */

#include <stdio.h>
#include "font.h"

#ifdef SYS5
#define	bzero(a,b)	memset(a,0,b)
#endif

#define	SHORT	0xffff		/* mask */
#define	HISHORT	0xffff0000	/* mask */
#define	BYTE	0xff		/* mask */
#define NASC	96			/* number of printable ascii characters */
extern char *malloc(),*savestr(),*pr_font();
extern char *Progname;
extern int debugging;

char *
/* Read a binary font face file */

rdfont(fd,nspec,funny_tab,funny_index)
int fd,nspec;
char *funny_tab;
short *funny_index;
{
	char *widths;
	char *kerning;
	char *code;
	char *font_ind;
	char *fname;
	struct Font font;
	unsigned int nwidths;
	int i;

	/* get the font info from the description file */
	if(read(fd,(char *)&font,sizeof(struct Font)) != sizeof(struct Font))
	{
		fprintf(stderr,"%s: can't read font info\n",Progname);
		return((char *)0);
	}

	/* Allocate space for the tables */
	nwidths = font.nwfont & BYTE;
	widths = malloc(nwidths);
	if(!widths)
	{
		fprintf(stderr,"%s: can't malloc widths\n",Progname);
		return((char *)0);
	}
	kerning = malloc(nwidths);
	if(!kerning)
	{
		fprintf(stderr,"%s: can't malloc kerning\n",Progname);
		free(widths);
		return((char *)0);
	}
	code = malloc(nwidths);
	if(!code)
	{
		fprintf(stderr,"%s: can't malloc code\n",Progname);
		free(widths);
		free(kerning);
		return((char *)0);
	}

	/* Read 'em in */
	if((i = read(fd,widths,nwidths)) != nwidths)
	{
		fprintf(stderr,"%s: read %d of %d widths \n",i,nwidths,Progname);
		free(widths);
		free(kerning);
		free(code);
		return((char *)0);
	}
	if((i = read(fd,kerning,nwidths)) != nwidths)
	{
		fprintf(stderr,"%s: read %d of %d kernings\n",i,nwidths,Progname);
		free(widths);
		free(kerning);
		free(code);
		return((char *)0);
	}
	if((i = read(fd,code,nwidths)) != nwidths)
	{
		fprintf(stderr,"%s: read %d of %d codes\n",i,nwidths,Progname);
		free(widths);
		free(kerning);
		free(code);
		return((char *)0);
	}
	font_ind = malloc(NASC + nspec);
	if(!font_ind)
	{
		fprintf(stderr,"%s: malloc font_ind failed\n",Progname);
		free(widths);
		free(kerning);
		free(code);
		return((char *)0);
	}
	if(read(fd,font_ind,NASC + nspec) != NASC + nspec)
	{
		fprintf(stderr,"%s: read %d of %d of index table\n",i,NASC + nspec,Progname);
		free(font_ind);
		free(widths);
		free(kerning);
		free(code);
		return((char *)0);
	}
	/* Now we can print the font description files; pr_font() also saves
	 * the font name for us, to return to main().
	 */
	fname = pr_font(&font,widths,kerning,code,font_ind,funny_tab,funny_index,nspec);
	free(font_ind);
	free(widths);
	free(kerning);
	free(code);
	return(fname);
}


/* Prints tha ascii font description.  Saves the fontname, properly
 * null-terminated, and returns it to rdfont() for pass back to main().
 */
char *
pr_font(font,widths,kerning,code,font_ind,funny_tab,funny_index,nspec)
struct Font *font;
char *widths,*kerning,*code,*font_ind,*funny_tab;
short *funny_index;
int nspec;
{
	int f,i,j,k,f_ind;
	char *funny_str;
	int nwidths;
	FILE *fontf;
	char fontname[16];
	char intname[16];
	char *fname;
	int rti[4][256];		/* for a "reverse index table" into the font index */

	nwidths = (int)(font->nwfont & BYTE);

	/* make sure we have null-terminated names */
	strncpy(fontname,font->namefont,10);
	strncpy(intname,font->intname,10);
	fontname[10] = '\0';
	intname[10] = '\0';

	/* now save a copy of the processed fontname for return (never freed) */
	fname = savestr(fontname);

	/* In case there's an original file, avoid overwriting it */
	strcat(fontname,".new");

	if((fontf = fopen(fontname,"w")) == (FILE *)0)
	{
		fprintf(stderr,"%s: can't open font file %s for writing\n",Progname,fontname);
		exit(1);
	}
	if(debugging)		/* if compiled for debugging */
		printf("\n\n\n\nwriting %s (%s)\n",fname,intname);

	/* print the header information, from the font structure */
	/* nwfont is printed as a comment, for reference 		 */
	fprintf(fontf,"#nwfont %d\n",nwidths);
	fprintf(fontf,"name %s\n",fname);
	fprintf(fontf,"internalname %s\n",intname);
	if(font->specfont)
		fprintf(fontf,"special\n");
	if(font->ligfont)
		pr_lig(fontf,(char)(font->ligfont & BYTE));

	/* widths[0] is spacewidth (if non-zero); real stuff starts at 1 */
	if(widths[0] & BYTE)
		fprintf(fontf,"spacewidth %u\n",(int)(widths[0] & BYTE));

	widths[0] = '\0';
	fprintf(fontf,"charset\n");
	if(debugging)
		printf("font index table\n\n");

	/* Build a "reverse index table" which permits us to find the character
	 * which corresponds to a given width table entry.
	 */
	bzero(rti,sizeof(rti));
	for(j = 1; j < nspec + NASC ; ++j)
	{
		i = (int)(font_ind[j] & BYTE);
		if(i > nwidths)
		{
			fprintf(stderr,"%s: width table too small ? (%d; need %d)\n",
					Progname,nwidths,i & BYTE);
			continue;
		}
		/* If rti[i] is non-zero, we have two names for the same character,
		 * and it's a pain.  This is a hack, and only allows for four names.
		 * It would be unnecessary if "makefont" simply made a duplicate
		 * width table entry for each duplicate.  It also assumes that
		 * each of the indexes will be < 256.
		 * Tack the new value into the next free byte of the int.
		 */
		if(i && rti[0][i])
		{
			for(k = 1; k < 4; ++k)
			{
				if(rti[k][i] == 0)
				{
					rti[k][i] = j;
					break;
				}
			}
			if(k == 4)
			{
				fprintf(stderr,"%s: too many duplicates, width index %d\n",Progname,i);
				exit(1);
			}
		}
		else
			rti[0][i] = j;
		if(debugging)
		{
			printf("%d\t%d\t",j,i);
			if(j < NASC)
				printf("\t\t\t%c\t%d  %d  %#o\n",j + 32,
					(int)(widths[i] & BYTE),(int)(kerning[i] & BYTE),(int)(code[i] & BYTE));
			else
			{
				f_ind = (int)(funny_index[j - NASC] & SHORT);
				funny_str = funny_tab + (f_ind & SHORT);
				if(!funny_str)
					funny_str = "??";
				printf("(f_ind=%d)\t%s\t%d\t%d\t%#o\n",f_ind,funny_str,
					(int)(widths[i] & BYTE),(int)(kerning[i] & BYTE),(int)(code[i] & BYTE));
			}
		}
	}

	/* Now print the width table, starting at 1 (since width 0 is spacewidth) */
	if(debugging)
	{
		printf("\n\nWidth table\n\n");
		printf("POS\tWIDTH\t\tKERN\t\tCODE\n");
	}
	for(i = 1; i < nwidths; ++i)
	{
		/* position in the font index table tells us what character 
		 * corresponds to this width table entry (if any).  Except we
		 * have to handle the hack for duplicate names...
		 */
		for(k = 0; k < 4; ++k)
		{
			j = rti[k][i];
			if(j == 0)
			{
				break;
			}
			f = (int)(font_ind[j] & BYTE);
			if(f == 0)
			{
				continue;	/* not in this font */
			}
			if(f != i)
			{
				fprintf(stderr,"%s: reverse index table out of sync (%d != %d) at %d\n",Progname,f,i,j);
				exit(1);
			}
			if(j < NASC)
			{
				if(debugging)
					printf("\t\t\t%c\t%d  %d  %#o\n",j + 32,
						(int)(widths[i] & BYTE),(int)(kerning[i] & BYTE),(int)(code[i] & BYTE));
				if(k)
					fprintf(fontf,"%c\t\"\n",j + 32);	/* duplicate */
				else
					fprintf(fontf,"%c\t%d\t%d\t%#o\n",j + 32,
						(int)(widths[i] & BYTE),(int)(kerning[i] & BYTE),(int)(code[i] & BYTE));
			}
			else
			{
				f_ind = (int)(funny_index[j - NASC] & SHORT);
				funny_str = funny_tab + (f_ind & SHORT);
				if(!funny_str)
					funny_str = "??";
				if(debugging)
					printf("(f_ind=%d)\t%s\t%d\t%d\t%#o\n",f_ind,funny_str,
						(int)(widths[i] & BYTE),(int)(kerning[i] & BYTE),(int)(code[i] & BYTE));
				if(k)
					fprintf(fontf,"%s\t\"\n",funny_str);
				else
					fprintf(fontf,"%s\t%d  %d  %#o\n",funny_str,
						(int)(widths[i] & BYTE),(int)(kerning[i] & BYTE),(int)(code[i] & BYTE));
			}
		}
	}
	fclose(fontf);
	printf("%s.out --> %s\n",fname,fontname);
	return(fname);
}

pr_lig(fontf,ligatures)
FILE *fontf;
char ligatures;
{
	fprintf(fontf,"ligatures ");
	if(ligatures & LIG_FF)
		fprintf(fontf," ff");
	if(ligatures & LIG_FI)
		fprintf(fontf," fi");
	if(ligatures & LIG_FL)
		fprintf(fontf," fl");
	if(ligatures & LIG_FFI)
		fprintf(fontf," ffi");
	if(ligatures & LIG_FFL)
		fprintf(fontf," ffl");
	fprintf(fontf," 0\n");
}

/* 'nuff said...  */
union kludge {
	int i;
	char c[4];
} kludge;

/* add byte y to x in the lowest zero-valued byte, if any. */

addbyte(x,y)
int x,y;
{
	int i;

	kludge.i = x;
	for(i = 3; i >= 0; --i)
		if((kludge.c[i] & BYTE) == 0)
		{
			kludge.c[i] = y & BYTE;
			return(kludge.i);
		}
	return(x);
}

/* shift bytes down in an int, zeroing high byte */

shiftdown(x)
int x;
{
	int i;

	kludge.i = x;
	for(i = 3; i > 0; --i)
		kludge.c[i] = kludge.c[i - 1];
	kludge.c[0] = '\0';
	return(kludge.i);
}
