.TH MKFONT  1-P
.SH NAME
mkfont,rdfont \- create/read ditroff font files
.SH SYNOPSIS
.br
.B mkfont
.I \-c
[DESC]
.br
.B rdfont
[DESC.out]
.SH DESCRIPTION
.PP
.I Mkfont
reads ascii format font description files and creates binary format
files usable by
.I ditroff.
The format of the ascii files may be guessed reasonably closely by
reading \fCfont\fP(5) and \fCtroff\fP(5).
Alternatively, if you have existing fonts, you may run
.I rdfont
on them to produce their ascii equivalents (which you may then
modify, if you like, and re-compile with \fImkfont\fP).
The produced binary files are named by the input files suffixed with
.I .out.
.I Ditroff
expects the font description file to be named
.I DESC.out,
so \fImkfont\fP expects an ascii file named \fIDESC\fP in the
current directory if no arguments are given; otherwise, the name
of the description file must be given as argument.
The \fI-c\fP flag causes the binary files produced to be more
nearly compatible with those produced by the ATT \fImakedev\fP
program (\fImakedev\fP does not make duplicate width table entries
in the binary file for characters whose width is given by double
quotes in the ascii file; \fImkfont\fP does, unless \fI-c\fP is
given).
.PP
.I Rdfont
examines a binary format font set and produces a set of ascii files
which describe them.  The ascii files are in a form suitable for
re-compiling with \fImkfont\fP.
If no arguments are given, a description file named \fIDESC.out\fP
is expected.  An alternate description file name may be given as
argument.
The produced files are named by replacing the \fI.out\fP extensions
of the input files by \fI.new\fP, to avoid overwriting existing
description files.  If these files are to be re-compiled, the
extensions should be removed.
.
.SH DIAGNOSTICS
.PP
.SH BUGS
.PP
.I Mkfont
does not do much checking on the validity of the font, although it
could do so.
.I Rdfont
writes a few information items to the ascii file as comment lines.
That's not a bug, but it does make comparison of originals and
duplicates a bit (not muuch) harder.
.SH AUTHOR
.br
Duane H. Hesser
.br
Teltone Corporation
