static char *RCSid = "$Header: nextword.c,v 1.1 87/10/23 19:08:11 sysad Exp $";

/*
 * $Log:	nextword.c,v $
 * Revision 1.1  87/10/23  19:08:11  sysad
 * Initial revision
 * 
 * 
 */

#define	CNULL	(char *)0

/*  nextword: return the next whitespace delimited word from the      */
/*  string passed as argument.  The returned word is null- terminated */
/*  and points to a static copy of the word.  Each time the routine   */
/*  is called with a new string, the old string copy is freed, and a  */
/*  static copy of the new string is made and the first word is       */
/*  returned.  Subsequent calls with the same argument return         */
/*  succeeding words, or null if no words remain.                     */
/*                                                                    */

extern char *savestr();

#include <ctype.h>
char *
nextword(string)
char *string;
{
	static char *ostring = CNULL;
	static char *savedstr = CNULL;
	static char *next = CNULL;
	char *x,*start;

	if((string == CNULL) || !*string)
	{
		/* no string or empty string */
		if(savedstr)
			free(savedstr);
		savedstr = next = ostring = CNULL;
		return(CNULL);
	}

	/* Have we seen this string before? */
	if(string != ostring)
	{
		/* Nope; set up the copy and pointers */
		ostring = string;
		if(savedstr)
			free(savedstr);
		savedstr = savestr(string);
		next = savedstr;
	}
	if(!next || !*next)
		return(CNULL);

	x = next;
	/* strip off leading white space */
	while(*x && (*x != '\n') && isspace(*x))
		++x;
	start = x; 					/* x is the start of the word */
	while(*x && (*x != '\n') && !isspace(*x))
		++x;
	if(*x)
	{
		*x = '\0'; 						/* null terminate the word */
		next = ++x;
	}
	else next = CNULL;		/* end of string, no more words */
	if(*start != '\n' && *start != '\0')
	{
		/* printf("nw = %s\n",start); /**/
		return(start);
	}
	else
		return(CNULL);
}
