static char *RCSid = "$Header: mkfont.c,v 1.1 87/10/23 19:08:10 sysad Exp $";

/*
 * $Log:	mkfont.c,v $
 * Revision 1.1  87/10/23  19:08:10  sysad
 * Initial revision
 * 
 * 
 */

#include <stdio.h>
#include <sys/file.h>
#include "font.h"
#ifdef SYS5
#define	bzero(a,b)	memset(a,0,b)
#endif

#define NCHARMAX	256			/* max chars in font */
#define	NASC		96			/* number of printable ascii chars */
#define	BYTE		0xff		/* mask */
#define	SHORT		0xffff		/* mask */

extern char *malloc(),*savestr(),*nextword(),*fgets();
extern FILE *fopen();
extern char *Progname;
extern int compat;

/* Read the ascii font description files, and write the binary files. */
/*                                                                    */

do_font(fontname,funny_chars,funny_ind,nchtab,fdout)
char *fontname,*funny_chars;
short *funny_ind;
int nchtab,fdout;
{
	FILE *src;
	char mybuf[256];
	/* allocate them just once */
	static char *width,*kern,*code,*fontindex = (char *)0;
	
	struct Font font;
	char *word;
	int dest,spacewidth,nwfont,indx;

	/* The ascii source file, named by the font name. */
	if((src = fopen(fontname,"r")) == (FILE *)0)
	{
		fprintf(stderr,"%s: can't open font %s\n",Progname,fontname);
		exit(1);
	}

	/* create the binary font face file */
	sprintf(mybuf,"%s.out",fontname);
	if((dest = open(mybuf,O_CREAT | O_WRONLY,0644)) < 0)
	{
		fprintf(stderr,"%s: can't create font %s output file\n",Progname,mybuf);
		exit(1);
	}
	fontindex = width = kern = code = (char *)0;

	spacewidth = 0;
	font.ligfont = (char)0;

    /* Build the font structure.                                      */

	while(fgets(mybuf,256,src))
	{
		word = nextword("");	/* reset to beginning of line */
		word = nextword(mybuf);
		if(!word || !*word || (*word == '#'))
			continue;
		if(strcmp(word,"charset") == 0)
			break;
		if(strcmp(word,"name") == 0)
			strncpy(font.namefont,nextword(mybuf),10);
		else if(strcmp(word,"internalname") == 0)
			strncpy(font.intname,nextword(mybuf),10);
		else if(strcmp(word,"spacewidth") == 0)
			spacewidth = atoi(nextword(mybuf)) & BYTE;
		else if(strcmp(word,"special") == 0)
			font.specfont =  0x01;
		else if(strcmp(word,"ligatures") == 0)
		{
			while(word = nextword(mybuf))
			{
				if(*word == '0')
					break;
				else if(strcmp(word,"fi") == 0)
					font.ligfont |= LIG_FI;
				else if(strcmp(word,"fl") == 0)
					font.ligfont |= LIG_FL;
				else if(strcmp(word,"ff") == 0)
					font.ligfont |= LIG_FF;
				else if(strcmp(word,"ffi") == 0)
					font.ligfont |= LIG_FFI;
				else if(strcmp(word,"ffl") == 0)
					font.ligfont |= LIG_FFL;
			}
		}
	}

	/* The next 4 tables are allocated just once, big enough for any font,
	 * then re-used for each font face.
	 */

	if(fontindex == (char *)0)
	{
		fontindex = malloc((unsigned)(NASC + nchtab));
		if(fontindex == (char *)0)
		{
			fprintf(stderr,"%s: can't malloc font index table\n",Progname);
			exit(1);
		}
	}

	if(width == (char *)0)
	{
		width = malloc(NCHARMAX);
		if(width == (char *)0)
		{
			free(fontindex);
			fontindex = (char *)0;
			fprintf(stderr,"%s: can't malloc font widths table\n",Progname);
			exit(1);
		}
	}
	if(kern == (char *)0)
	{
		kern = malloc(NCHARMAX);
		if(kern == (char *)0)
		{
			free(width);
			free(fontindex);
			fontindex = (char *)0;
			width = (char *)0;
			fprintf(stderr,"%s: can't malloc font kern table\n",Progname);
			exit(1);
		}
	}

	if(code == (char *)0)
	{
		code = malloc(NCHARMAX);
		if(code == (char *)0)
		{
			free(width);
			free(kern);
			free(fontindex);
			fontindex = (char *)0;
			width = (char *)0;
			kern = (char *)0;
			fprintf(stderr,"%s: can't malloc font code table\n",Progname);
			exit(1);
		}
	}

	/* clear them */
	bzero(width,NCHARMAX);
	bzero(kern,NCHARMAX);
	bzero(code,NCHARMAX);
	bzero(fontindex,NASC + nchtab);

	/* first width entry is width of space if non-zero */
	width[0] = (char)(spacewidth & BYTE);
	kern[0] = '\0';
	code[0] = '\0';

	nwfont = 1;
	
	/* decode the character set info and stuff the width, kern, code
	 * tables, building the font index table as we go
	 */
	while(fgets(mybuf,256,src))
	{
		nextword("");	/* reset to beginning of line */
		word = nextword(mybuf);
		if(!word || !*word)
			continue;
		if(strlen(word) == 1)
			indx = (*word & BYTE) - 32;		/* printable ascii */
		else
			indx = spcl(word,funny_chars,funny_ind,nchtab); /* troff special chars */
		if(indx < 0)
		{
			fprintf(stderr,"%s: special string \"%s\" is not defined in desc\n",Progname,word);
			fprintf(stderr,"...skipping\n");
			continue;
		}

		/* check for repeat characters ( " in width column) */
		word = nextword(mybuf);

		if(*word == '"')
		{
			/* It appears that att's "makefont" doesn't make a new
			 * width entry for dups--it just reuses the earlier one.
			 * It would be much easier for "rdfont" to decode these
			 * things if we just made a duplicate entry, but for
			 * compatibility with "makefont" (as determined by examination
			 * of compiled fonts delivered to us)...
			 */
			if(!compat)
			{
				/* make a separate width entry for each duplicate */
				width[nwfont] = width[nwfont - 1];
				kern[nwfont] = kern[nwfont - 1];
				code[nwfont] = code[nwfont - 1];
				fontindex[indx] = (char)(nwfont & BYTE);
				nwfont++;
			}
			fontindex[indx] = (char)((nwfont - 1) & BYTE);
			continue;
		}
		fontindex[indx] = (char)(nwfont & BYTE);
		width[nwfont] = (char)(atoi(word) & BYTE);
		word = nextword(mybuf);
		kern[nwfont] = (char)(atoi(word) & BYTE);
		word = nextword(mybuf);
		code[nwfont++] = (char)(atoo(word) & BYTE);
	}

	fclose(src);
	font.nwfont = (short)(nwfont & BYTE);
	printf("%s: nwfont = %d\n",fontname,nwfont);



	/* write the tables, first to the description file, then to the
	 * individual font file.
	 */
	if(write(fdout,(char *)&font,sizeof(struct Font)) != sizeof(struct Font))
	{
		fprintf(stderr,"%s: write font struct to description file failed\n",Progname);
		exit(1);
	}
	if(write(dest,(char *)&font,sizeof(struct Font)) != sizeof(struct Font))
	{
		fprintf(stderr,"%s: write font struct to font output file failed\n",Progname);
		exit(1);
	}
	if(write(fdout,width,nwfont) != nwfont)
	{
		fprintf(stderr,"%s: write width table to description file failed\n",Progname);
		exit(1);
	}
	if(write(dest,width,nwfont) != nwfont)
	{
		fprintf(stderr,"%s: write width table to font output file failed\n",Progname);
		exit(1);
	}
	if(write(fdout,kern,nwfont) != nwfont)
	{
		fprintf(stderr,"%s: write kern table to description file failed\n",Progname);
		exit(1);
	}
	if(write(dest,kern,nwfont) != nwfont)
	{
		fprintf(stderr,"%s: write kern table to font output file failed\n",Progname);
		exit(1);
	}
	if(write(fdout,code,nwfont) != nwfont)
	{
		fprintf(stderr,"%s: write code table to description file failed\n",Progname);
		exit(1);
	}
	if(write(dest,code,nwfont) != nwfont)
	{
		fprintf(stderr,"%s: write code table to font output file failed\n",Progname);
		exit(1);
	}
	if(write(fdout,fontindex,nchtab + NASC) != nchtab + NASC)
	{
		fprintf(stderr,"%s: write font index table to description file failed\n",Progname);
		exit(1);
	}
	if(write(dest,fontindex,nchtab + NASC) != nchtab + NASC)
	{
		fprintf(stderr,"%s: write font index table to font output file failed\n",Progname);
		exit(1);
	}
	close(dest);	/* done with this font file */
	return(nwfont);	/* the return is extraneous here */
}

/* Find the font index of special character strings */

spcl(word,funny_chars,funny_ind,nchtab)
char *word,*funny_chars;
short *funny_ind;
int nchtab;
{
	int i;

	for(i = 0; i < nchtab; ++i)
	{	
		if(strcmp(word,funny_chars + (int)(funny_ind[i] & SHORT)) == 0)
			return(i + NASC);
	}
	return(-1);
}

/* convert an octal string representation to an int */

atoo(str)
char *str;
{
	int i;
	/* cheat */
	sscanf(str,"%o",&i);
	return(i);
}
