#ifndef LINT
static char SccsId[] = "@(#)lp.c	1.2 U of T Physics 12/16/87";
#endif

/*
 * This is an onionskin around the lp spooler.
 * The problem is that the standard lp(1) uses lockfiles, with
 * the well-known window of vulnerability between testing for
 * the existence of the file and trying to create it.
 * Thus, we have moved the standard lp command to "real_lp",
 * and this program becomes "lp".
 * It uses a semaphore to lock and unlock jobs sent to lp.
 *		David Harrison - Dec/87
 */

#include <stdio.h>
#include <signal.h>

char *real_lp_cmd = "real_lp";

char *progname;

main(argc, argv)
int argc;
char *argv[];
{
	void _exit(), perror();
	char *emalloc();
	char *strcpy(), *strcat();
	char **exec_argv;
	int pid, w, status;
	int (*istat)(), (*qstat)();
	int i;

	progname = argv[0];

	/*
	 * put arguments from argv into exec_argv, terminating
	 * with a null.
	 *
	 * First malloc the array size needed ( with one for the NULL
	 * and the end).
	 */
	exec_argv = 
	    (char **) emalloc( (unsigned) ((argc + 1) * sizeof (char *) ));
	/*
	 * Put real_lp_cmd in argv[0]
	 */
	exec_argv[0] = emalloc( (unsigned) (strlen(real_lp_cmd) + 1) );
	(void) strcpy(exec_argv[0], real_lp_cmd);
	/*
	 * Now the other argements
	 */
	if( argc > 1) {
		for(i = 1; i < argc; i++) {
		    exec_argv[i] = emalloc( (unsigned) (strlen(argv[i]) + 1 ));
		    (void) strcpy(exec_argv[i], argv[i]);
		}
	}
	/*
	 * Terminate with a NULL
	 */
	exec_argv[argc] = NULL;

	lockproc();

	switch( (pid = fork()) ) {

		case -1:
			unlockproc();
			Sys_Error("Can't fork\n");
			break;

		case 0:
			execvp( real_lp_cmd , exec_argv );
			unlockproc();
			fprintf(stderr,"%s: can't exec %s\n", 
				progname, real_lp_cmd );
			perror("exec");
			_exit(127);

		default:
			break;
			
	}

	/*
	 * Trap signals and wait for child to finish.
	 */
	istat = signal(SIGINT, SIG_IGN);
	qstat = signal(SIGQUIT, SIG_IGN);
	while( (w = wait(&status)) != pid && w != -1)
		;
	if( w == -1)
		status = -1;
	signal(SIGINT, istat);
	signal(SIGQUIT, qstat);

	unlockproc();
			
	return status;

}

char *
emalloc(n)
unsigned n;
{
	char *p, *malloc();

	p = malloc(n);
	if ( p == 0)
		Sys_Error("Out of memory");
	return p;
}

Sys_Error(s)
char *s;
{
	void exit(), perror();

	fprintf(stderr,"%s: %s\n",progname, s);
	perror("terminating");
	exit(1);

}
