.pl 60
.\" Man Page for LABELS
.TH LABELS 1 "2 Aug 1987"
.SH NAME
labels \- produce formatted output for label printing
.SH SYNOPSIS
.B LNAME
[
.B \-f <form>
] 
[
.B <input file>
[
.B <output file>
] ]
.br
.B LNAME
.B \-h
.br
.B LNAME
.B \-l
.SH DESCRIPTION
.B LNAME accepts a raw
.B <input file>
and produces a formatted
.B <output file>.
If
.B <output file>
is not specified, then formatted output will
go to standard output
.I (stdout).
If
.B <input file>
is not specified in addition to the omission of
.B <output file>,
then input will be taken from the standard input
.I (stdin).
.sp
.\" describe the format of the input file
The format of an input file is simple and straight forward.  The
following is an example:
.nf
.sp
        John Doe
        123 Main St.
        City of DownUnder, AU 9999
        .
        Susan Smith
        Label Products, Inc.
        1000 Broadway Blvd.
        Space City, DD 00001
        .
.sp
.fi
A period "." must be placed at the beginning of a new line
after completing data input for each label.
.\" describe the format of label forms
.sp
By default,
.B LNAME
prepares the output for USC-UCC standard label form (1083), which is 32 characters
wide and 11 lines long per label, and 3 labels across. The optional
.B \-f <form>
can be used to overcome the default label format.  A directory
of preset label formats can be listed by specifying the
.B \-l
parameter alone.  If a desired form is not available, the user
can define one, like the following:
.sp
.nf
        # Standard label size (32 char x 6 lines, 3 columns)

        width = 32, lines = 6, columns = 3

        # other alignments
        hgap = 4, vgap = 1, offset = 4
.fi
.sp
A line that starts with # is treated as a comment.  Various
parameters can be set by specifying the variable name, like
.I width,
and assign it to the a value, like 32.  The above form file
defines the following:
.sp
.nf
        \- Each label has maximum width of 32 characters (width=32).
        \- Each label has maximum lines of 6 (lines=6).
        \- Format for 3 labels across (columns=3).
        \- Set horizontal gap between labels to be 4 characters (hgap=4).
        \- Set vertical gap between labels to be 1 line (vgap=1).
        \- Set data offset to be 4 characters from the left (offset=4).
.fi
.sp
You may also use the
.B :
or a space in the place of
.B =.
In other words, you can use any one of the variations:
.sp
.nf
        width:32        width 32        or width = 32.
.fi
.sp
Also, you may use a semicolon in place of a comma.
.sp
There is a naming convention for such file.  Each form definition
file
.B must
have the extension
.B .lbl
and must be in the current directory in order for it to be
recognized by
.B LNAME.
For example, the above definition may be placed in
a file called
.I myform.lbl.
To format labels from an input file
.I labels.in
and save the formatted output to
.I labels.out
using
.I myform.lbl,
type:
.sp
.nf
        LNAME -f myform labels.in labels.out
.fi
.sp
.B LNAME
will search for
.I myform
from a set of preset forms.  If such form does not exist, it
will then search in user's current directory.
.sp
Many people prefer to print mailing list labels with a "To:"
attached to the first line, and the rest of the lines must
align properly.  The user may create the following form:
.sp
.nf
        # Standard label size (32 char x 6 lines, 3 columns) with "To:"

        lines:6; width:32
        columns:2

        # other alignments
        hgap:4; vgap:1; offset:0

        # format definition for each of the 6 lines in a label
        format for line 1 is " To: %s"
        format for line 2 is "     %s"
        format for line 3 is "     %s"
        format for line 4 is "     %s"
        format for line 5 is "     %s"
        format for line 6 is "     %s"
.fi
.sp
If the sample input data file on page 1 is used, along with the above
form, this is the result:
.nf
.sp
-----------------------------------------------------------------------
|                                |   |                                |
| To: John Doe                   |   | To: Susan Smith                |
|     123 Main St.               |   |     Label Products, Inc.       |
|     City of DownUnder, AU 9999 |   |     1000 Broadway Blvd.        |
|                                |   |     Space City, DD 00001       |
|                                |   |                                |
-----------------------------------------------------------------------
.fi
.sp
The string
.I %s
is substituted with the input data.  Thus by default, each line has
the format of "%s".
If "To:" is desired to be added to the first line, like to above example,
then the format for the first line can be defined as "To: %s".
.sp
Customized printing of labels can also be done.  Initial string of
escape sequences can be sent via the
.I "initial string"
command:
.sp
.nf
        initial string = "^[B"
.fi
.sp
where
.I "^[B"
could be an escape sequence to enable bold printing on a particular
printer.
.sp
Another useful parameter is
.I "initial fill."
Before printing labels on a line printer, the operator often needs
to re-adjust the printer.  By printing the dimensions of the label
forms, the printer can be adjusted properly before printing the
first valid label.  To fill ten rows of labels initially, the
following parameter is specified in the form definition:
.sp
.nf
        initial fill = 10
.fi
.sp
Finally, if you need a quick reminder about the program parameters,
a brief command usage can be reviewed by specifying the
.I \-h
parameter alone.
.SH LIMITATIONS
LNAME assumes that the printer to be used is using a font with
constant widths for all characters.
.SH FILES
PROGDIR/LNAME
.sp
All .lbl files in LIBDIR are predefined label form definitions.
A listing can be obtained by specifying the
.B \-l
parameter.
.SH DIAGNOSIS
Below is a list of common error messages and their descriptions.
.sp
.B "Line xxxx: Line too long (x) - Truncated"
.sp
Length of the input data at line xxxx is longer than the maximum
defined width of x.  The rest of the input on that line is truncated.
.sp
.B "Line xxxx: Line too long after formatting (x) - Truncated"
.sp
The length of the formatted string at line xxxx is longer than the
maximum width permitted, which is x.
.sp
.B "Line xxxx: Lines Exceeded Limit (x) - Ignoring the Rest"
.sp
Number of lines per label is greater than the maximum of x lines.
.sp
.B LNAME
.B ": Cannot read form:"
.I form
.sp
The form you specified with
.B \-f
is not found.  The file name must have the extension .lbl.
.sp
.B LNAME
.B ": Error reading form:"
.I form
.sp
User defined form has improper syntax, which resulted in parsing
errors.  Various parsing errors are also displayed.
.sp
.B LNAME
.B ": Too many arguments"
.sp
Too many arguments specified.  A brief program usage is displayed.
.sp
.B LNAME
.B ": Cannot Open Directory:"
.I dir
.sp
Cannot list preset forms because the directory containing form files
does not exist.
.sp
.SH BUGS
None discovered so far. Please report any bugs you may find
to the author by electronic mail.
.SH AUTHOR
.nf
Joe S. Chen, Consultant, UNIX, VMS, and TOPS-20
Phones: (213) 743-5363, (213) 743-5935
University Computing Services, University of Southern California
UUCP: {sdcrdcf, uscvax}!oberon!wasat!joec
ARPA: joec@wasat.usc.edu, joec@ecla.usc.edu
.fi
