%{
/*			       -- LABELS.Y --

@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@                                                                           @@
@@                       Mailing List Label Formatter                        @@
@@                     Syntax Analyzer for Form Parsing                      @@
@@                      (C) Copyright 1987 by Joe Chen                       @@
@@                           All Rights Reserved                             @@
@@                                                                           @@
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

You may freely distribute this software to others.  But there are
few rules you must follow:

1. You don't profit from it.  You may however ask for minimal fees to
   cover shipping and handling.

2. This program is copyrighted, meaning you may not modify or enhance
   this software and market it.  You may make changes to suit your
   local needs.  Any enhancements are welcomed.

3. Please honor the author by not removing or replacing his name from
   the source codes.


Feel free to contact me if you have any questions.

					Joe Chen

---------------------------------------------------------------------------
Phones at work: (213) 743-5363, (213) 743-5935; at home: (818) 571-5304
University Computing Services, University of Southern California
UUCP: {sdcrdcf, uscvax}!oberon!wasat!joec
ARPA: joec@wasat.usc.edu, joec@ecla.usc.edu
---------------------------------------------------------------------------

Program created by Joe Chen - Jul 24, 1987

*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*

*/
#include <stdio.h>

extern char *malloc(), *realloc();

extern int value, line_no;
extern char yytext[], **fmt_arry, *l_istring;
extern int l_width, l_hgap, l_vgap, l_columns, l_mlines, l_offset, l_cross;
extern int l_ifill, l_foffs, l_poffs, l_lrows;
extern FILE *form;
%}

%union {
  int vars;
};

%token _INITIAL
%token _KSTRING
%token _FORM
%token _PAGE
%token _FILL
%token _WIDTH
%token _HGAP
%token _VGAP
%token _COLUMNS
%token _LINES
%token _ROWS
%token _OFFSET
%token _FORMAT
%token _OF
%token _LINE
%token _IS
%token _ASSIGN
%token _DELIM
%token _VALUE
%token _STRING
%token _WORD

%type <vars> variable

%%

cmd		: stmts
		;

stmts		: stmts delim stmt
		| stmt
		;

delim		: _DELIM delim
		|
		;

stmt		: param_stmt_val
		| fmt_stmt
		| init_stmt
		;

param_stmt_val	: variable is _VALUE
		{
		  switch($1) {
		  case _WIDTH:
		    l_width = value;
		    break;
		  case _HGAP:
		    l_hgap = value;
		    break;
		  case _VGAP:
		    l_vgap = value;
		    break;
		  case _COLUMNS:
		    l_cross = value;
		    break;
		  case _LINES: {
		    if (l_mlines < value) {
		      int i;		/* need to adjust format buffer */
		      fmt_arry=(char **)realloc(fmt_arry,value*sizeof(char *));
		      if (fmt_arry == (char **)NULL)
			goto e;
		      /* add new format lines */
		      for (i=l_mlines; i < value; i++) {
			fmt_arry[i] = malloc(l_width+1);
			if (fmt_arry[i] == (char *)NULL)
			  goto e;
			(void) strcpy(fmt_arry[i], "%s");
		      }
		    } /* adjust the format buffer */
		    l_mlines = value;
		    break;
		  e:
		    fprintf(stderr,"Fatal Error: Insufficient Memory\n");
		    exit(-1);
		  }
		  case _OFFSET:
		    /* label column offset */
		    l_offset = value;
		    break;
		  case _FORM:
		    /* form offset value */
		    l_foffs = value;
		    break;
		  case _PAGE:
		    /* page offset value */
		    l_poffs = value;
		    break;
		  case _ROWS:
		    /* rows per label */
		    l_lrows = value;
		    break;
		  } /* set various variables */
		}
		;

variable	: _WIDTH
		{
		  $$=_WIDTH;
		}
		| _HGAP
		{
		  $$=_HGAP;
		}
		| _VGAP
		{
		  $$=_VGAP;
		}
		| _COLUMNS
		{
		  $$=_COLUMNS;
		}
		| _LINES
		{
		  $$=_LINES;
		}
		| _LINE
		{
		  $$=_LINES;
		}
		| _ROWS
		{
		  $$=_ROWS;
		}
		| _OFFSET
		{
		  $$=_OFFSET;
		}
		| _FORM _OFFSET
		{
		  $$=_FORM;
		}
		| _PAGE _OFFSET
		{
		  $$=_PAGE;
		}
		| _WORD
		{
		  $$=0;
		  fprintf(stderr,"Line %d in %s: Unknown variable: %s\n",
			  line_no, form, yytext);
		}
		;

fmt_stmt	: _FORMAT _OF line _VALUE is _STRING
		{
		  if (value > l_mlines) {
		    fprintf(stderr,"Line %d in %s: Line Number Execeeded ",
			    line_no, form);
		    fprintf(stderr,"Maximum (%d); Format Ignored\n",l_mlines);
		  }
		  else {
		    /* supercede format */
		    (void) strcpy(fmt_arry[value-1], &yytext[1]);
		    /* remove quotes */
		    fmt_arry[value-1][strlen(fmt_arry[value-1])-1] = '\0';
		  }
		}
		;

init_stmt	: _INITIAL _KSTRING is _STRING
		{
		  if ((l_istring = malloc(strlen(yytext))) == (char *)NULL) {
		    fprintf(stderr,"Fatal Error: Insufficient Memory\n");
		    exit(-1);
		  }
		  /* remove the quotations */
		  (void) strcpy(l_istring, &yytext[1]);
		  l_istring[strlen(l_istring)-1] = '\0';
		}
		| _INITIAL _FILL is _VALUE
		{
		  /* initial fill value */
		  l_ifill = value;
		}
		;

line		: _LINE
		|
		;

is		: _IS
		| _ASSIGN
		|
		;

%%

/****************************************************************************
  yyerror() [Public function] - Yacc error trap function

  parameters:	s		Error message from yacc's LR driver

  exit flags:	none
****************************************************************************/

yyerror(s)
     char *s;
{
  if (strcmp(s, "syntax error"))
    fprintf(stderr,"Line %d in %s: %s\n",line_no,form,s);
} /* yyerror() */

