%{
/*			       -- LABELS.L --

@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@                                                                           @@
@@                       Mailing List Label Formatter                        @@
@@                    Lexical Analyzer for Form Parsing                      @@
@@                      (C) Copyright 1987 by Joe Chen                       @@
@@                           All Rights Reserved                             @@
@@                                                                           @@
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

You may freely distribute this software to others.  But there are
few rules you must follow:

1. You don't profit from it.  You may however ask for minimal fees to
   cover shipping and handling.

2. This program is copyrighted, meaning you may not modify or enhance
   this software and market it.  You may make changes to suit your
   local needs.  Any enhancements are welcomed.

3. Please honor the author by not removing or replacing his name from
   the source codes.


Feel free to contact me if you have any questions.

					Joe Chen

---------------------------------------------------------------------------
Phones at work: (213) 743-5363, (213) 743-5935; at home: (818) 571-5304
University Computing Services, University of Southern California
UUCP: {sdcrdcf, uscvax}!oberon!wasat!joec
ARPA: joec@wasat.usc.edu, joec@ecla.usc.edu
---------------------------------------------------------------------------

Program created by Joe Chen - Jul 24, 1987

*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*

*/

#include <stdio.h>

#ifdef UNIX
#include "y.tab.h"
#else
#include "ytab.h"
#endif

int value, line_no = 1;
extern char *form;
%}

cr		\n
tab		\t
space		" "
white_space	({space}|{tab})
spcs		{white_space}*

digit		[0-9]
number		{digit}+

letter		[A-Za-z_]
word		{letter}({letter}|{digit})*

%%

{spcs}			;

#.*			;

{cr}			{	line_no++;		}

initial			{	return(_INITIAL);	}

string			{	return(_KSTRING);	}

fill			{	return(_FILL);		}

form			{	return(_FORM);		}

page			{	return(_PAGE);		}

width			{	return(_WIDTH);		}

hgap			{	return(_HGAP);		}

vgap			{	return(_VGAP);		}

columns			{	return(_COLUMNS);	}

column			{	return(_COLUMNS);	}

format			{	return(_FORMAT);	}

offset			{	return(_OFFSET);	}

of			{	return(_OF);		}

for			{	return(_OF);		}

lines			{	return(_LINES);		}

line			{	return(_LINE);		}

rows			{	return(_ROWS);		}

is			{	return(_IS);		}

","			{	return(_DELIM);		}

";"			{	return(_DELIM);		}

"="			{	return(_ASSIGN);	}

":"			{	return(_ASSIGN);	}


{number}		{
				value = atoi(yytext);
				return(_VALUE);
			}

{word}			{	return(_WORD);		}


\"[^\"]*\"		{	return(_STRING);	}

.			{
			  fprintf(stderr,
			    "Line %d in %s: Illegal Character: '%s'\n",
				  line_no, yytext);
			}

%%

/****************************************************************************
  yywrap() [Public function] - lex's function when EOF is detected from yyin

  parameters:	none

  exit flags:	1		Done matching tokens from input file
****************************************************************************/

yywrap()
{
  return 1;
} /* yywrap() */
