/*
	$Compile: cc -O -o %F %f
*/
#include <stdio.h>
#include <ctype.h>
#include <strings.h>

int 	Special = '\001';   /* magic char after sorting key */

typedef	int       Status;      /* return/exit status of functions */
#define	SUCCESS   ((Status) 0)
#define	FAILURE   ((Status) 1)
typedef	int       Boole;       /* no Boolean type in C */
#define	TRUE      ((Boole) 1)
#define	FALSE     ((Boole) 0)

FILE	*Pioptr;   /* will pipe to sort and sed */

/*FUNCTION main: loop through files in classic UNIX filter style */
main (argc, argv)
int 	argc;     /* argument count */
char	**argv;   /* argument vector */
	{
	Status 	process (); /* process (file, ioptr) will filter files */
	Status	status;     /* return status of filter () */
	int 	firstfile;  /* first file name index returned by initial */
	FILE	*popen ();
	char	command[BUFSIZ];

	firstfile = 1;

	sprintf (command, "sort | sed 's/^.*%c//'", Special);

	if (Pioptr = popen (command, "w"))
		{
		status = filter (argc, argv, firstfile, process);
		pclose (Pioptr);
		}
	else
		{
		fprintf (stderr, "%s: Can't run sorting pipeline\n", argv[0]);
		status = (-1);
		}
	exit (status);
	}

#define	iszipcode(s) \
	(!isdigit (s[-1]) \
	&& isdigit (s[0]) \
	&& isdigit (s[1]) \
	&& isdigit (s[2]) \
	&& isdigit (s[3]) \
	&& isdigit (s[4]) \
	&& !isdigit (s[5]))

process (file, ioptr)
char	*file;
FILE	*ioptr;
	{
	char	line[BUFSIZ];
	char	*ptr;
	int 	zipcode;

	while (fgets (ptr = line, BUFSIZ, ioptr))
		{
		zipcode = 0;
		for (ptr = line; *ptr; ptr++);
		while (ptr > line)
			if (iszipcode (ptr))
				{
				zipcode = atoi (ptr);
				break;
				}
			else ptr--;
		fprintf (Pioptr, "%05d%c%s", zipcode, Special, line);
		}
	}

static
void
errmsg (pgm, file, errorno, dflt)
char	*pgm;       /* name of the program running */
char	*file;      /* file operand to be mentioned (if any) */
int 	errorno;    /* system errno or some bad value */
char	*dflt;      /* default message for bad error numbers */
	{
	extern	char *sys_errlist[];  /* list of error messages */
	extern	int sys_nerr;         /* number of error messages */

	fputs (pgm, stderr);
	putc (':', stderr);
	putc (' ', stderr);
	if (errorno > 0 && errorno < sys_nerr)
		fputs (sys_errlist[errorno], stderr);
	else
		fputs (dflt, stderr);
	if (file)
		{
		putc (' ', stderr);
		putc ('\'', stderr);
		fputs (file, stderr);
		putc ('\'', stderr);
		}
	putc ('\n', stderr);
	}

#define	isstdin(file) (file[0] == '-' && file[1] == '\0')

int
filter (argc, argv, curarg, process)
int 	argc;          /* real number of command line args */
char	**argv;        /* command line argument pointer */
int 	curarg;        /* first argv to filter */
int 	(*process) (); /* status process (char *name, FILE *ioptr) */
	{
	int 	status = 0;         /* return status of this function */
	int 	arg;                /* loop index variable */
	char	*file;              /* name of the current file */
	char	*pgm = argv[0];     /* name of the program */
	FILE	*ioptr;             /* file pointer for opening */
	int 	countstdin = 0;     /* number of times stdin is processed */
	extern	int errno;          /* system error number */

	if (curarg == argc)
		status += ((*process) ("-", stdin));
	else
		{
		/* first check to make sure all files can be opened to read */
		for (arg = curarg; arg < argc; arg++)
			{
			file = argv[arg];
			if (isstdin (file))
				countstdin++;
			else if (access (file, 4))
				{
				errmsg (pgm, file, errno, "Can't access file");
				status++;
				}
			}
		if (countstdin > 1)
			{
			errmsg (pgm, NULL, -1, "Can only read standard input once");
			status++;
			}
		if (status == 0)
			for (arg = curarg; arg < argc; arg++)
				{
				file = argv[arg];
				if (isstdin (file))
					status += ((*process) (file, stdin) != 0);
				else if (ioptr = fopen (file, "r"))
					{
					status += ((*process) (file, ioptr) != 0);
					(void) fclose (ioptr);
					}
				else
					{
					errmsg (pgm, file, errno, "Can't open file");
					status++;
					}
				}
		}
	return (status);
	}
