/*
 * EPSON        -       FOR 10 CHAR/INCH, PICA
 * nroff driving tables
 * width and code tables
 */

#define INCH	240

struct {
	int bset;
	int breset;
	int Hor;
	int Vert;
	int Newline;
	int Char;
	int Em;
	int Halfline;
	int Adj;
	char *twinit;
	char *twrest;
	char *twnl;
	char *hlr;
	char *hlf;
	char *flr;
	char *bdon;
	char *bdoff;
	char *iton;
	char *itoff;
	char *ploton;
	char *plotoff;
	char *up;
	char *down;
	char *right;
	char *left;
	char *codetab[256-32];
	int zzz;
	} t = {
/*bset    */		00,
/*breset  */		00,
/*Hor     */		INCH/10,
/*Vert    */		INCH/12,
/*Newline */		INCH/6,
/*Char    */		INCH/10,
/*Em      */		INCH/10,
/*Halfline*/		INCH/12,
/*Adj     */		INCH/10,
/*twinit  */		"\016{\017",	/* pica */
/*twrest  */		"",
/*twnl    */		"\r\n",
/*hlr     */		"\0338",
/*hlf     */		"\0339",
/*flr     */		"\0337",
/*bdon    */		"",		/* "\016v\017", */
/*bdoff   */		"",		/* "\016w\017", */
/*iton    */		"",		/* "\016|\017", */
/*itoff   */		"",		/* "\016}\017", */
/*ploton  */		"",
/*plotoff */		"",
/*up      */		"",
/*down    */		"",
/*right   */		"",
/*left    */		"",
/*codetab*/
#include "code.epson"
