/*
 * Constructed from the picture files in ./Matrix and by use of the
 * program mat.c.
 *
 * Driver table representations SO-<char>-SI, where '!' <= <char> <= 'q', 
 * are assumed to have one-character width when expanded according to the 
 * table[] entry.
 * 
 * Representations with <char> >= 'r' are assumed to be zero-width,
 * i.e., are control strings.
 *
 * Comments after each entry give the driver table correspondences.
 *
 * Room is left for expansion.
 */

#define TABLE_ELEM_SIZE	105

char  table[][TABLE_ELEM_SIZE] = {
/* bold_vert /* ! */
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,255,255,255,255,255,255,255,255,255,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0
    },
/* left_bot /* " */
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,255,255,252,255,255,254,255,255,255,
      0,  0, 31,  0,  0, 15,  0,  0,  7,  0,  0,  7,  0,  0,  7,
      0,  0,  7,  0,  0,  7,  0,  0,  7,  0,  0,  7,  0,  0,  7,
      0,  0,  7,  0,  0,  7,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0
    },
/* left_top /* # */
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0, 63,255,255,127,255,255,255,255,255,
    248,  0,  0,240,  0,  0,224,  0,  0,224,  0,  0,224,  0,  0,
    224,  0,  0,224,  0,  0,224,  0,  0,224,  0,  0,224,  0,  0,
    224,  0,  0,224,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0
    },
/* right_bot /* $ */
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  7,  0,  0,  7,  0,  0,  7,  0,  0,  7,  0,  0,  7,
      0,  0,  7,  0,  0,  7,  0,  0,  7,  0,  0,  7,  0,  0,  7,
      0,  0, 15,  0,  0, 31,255,255,255,255,255,254,255,255,252,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0
    },
/* right_top /* % */
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
    224,  0,  0,224,  0,  0,224,  0,  0,224,  0,  0,224,  0,  0,
    224,  0,  0,224,  0,  0,224,  0,  0,224,  0,  0,224,  0,  0,
    240,  0,  0,248,  0,  0,255,255,255,127,255,255, 63,255,255,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0
    },
/* propor /* & */
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  1,  0,  0,  7,192,  0, 31,224,  0, 56, 96,  0, 96, 32,
      0,192, 32,  1,128, 32,  3,  0, 96,  2,  0, 64,  2,  0,192,
      1,  0,128,  0,193,  0,  0, 35,  0,  0, 30,  0,  0, 14,  0,
      0, 11,  0,  0, 17,128,  0, 32,192,  0, 64, 64,  0,128, 32,
      1,  0, 32,  2,  0, 32,  2,  0, 32,  2,  0, 96,  3,  0, 64,
      1,128,192,  0,193,128,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0
    },
    { 0 }, /* ' */
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0, 48,  0,  0,120,  0,  0,252,  0,  1,255,  0,
      1,255,  0,  3,255,128,  3,255,128,  3,255,128,  3,255,128,
      7,255,192,  7,255,192,  7,255,192,  7,255,192,  7,255,192,
      7,255,192,  7,255,192,  3,255,128,  3,255,128,  3,255,128,
      3,255,128,  3,255,  0,  1,255,  0,  1,254,  0,  0,252,  0,
      0,120,  0,  0, 48,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* bullet /* ( */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
     15,255,224,  8,  0, 32,  8,  0, 32,  8,  0, 32,  8,  0, 32,
      8,  0, 32,  8,  0, 32,  8,  0, 32,  8,  0, 32,  8,  0, 32,
      8,  0, 32,  8,  0, 32,  8,  0, 32,  8,  0, 32,  8,  0, 32,
      8,  0, 32,  8,  0, 32,  8,  0, 32,  8,  0, 32,  8,  0, 32,
      8,  0, 32,  8,  0, 32,  8,  0, 32,  8,  0, 32,  8,  0, 32,
      8,  0, 32,  8,  0, 32, 15,255,224,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* square /* ) */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0, 24,  0,  0, 36,  0,  0, 66,  0,  0,
    129,  0,  0,129,  0,  0,129,  0,  0,129,  0,  0,129,  0,  0,
    129,  0,  0, 66,  0,  0, 36,  0,  0, 24,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* degree /* * */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0, 64,  0,  0,224,  0,  0,224,  0,  0,224,  0,  0,224,  0,
     24,224,  0, 60,226,  0,120, 71,  0,127,255,254,120, 71,  0,
     60,226,  0, 24,224,  0,  0,224,  0,  0,224,  0,  0,224,  0,
      0,224,  0,  0, 64,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* dagger /* + */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 28,  0,  0, 62,  0,
      0,127,  0, 16, 67,  4, 48,129,134, 40,129,198, 41,  0,194,
     73,  0,193, 75,  0, 97, 75,  0, 97, 71,  0,113, 67,  0,105,
     67,  0,105, 65,  0, 73, 33,128, 73, 49,128,138, 16,192,138,
     16, 65,  6,  0, 97,  6,  0,126,  0,  0, 62,  0,  0, 28,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* section /* , */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  7,192,  0, 31,224,
      0, 56, 96,  0, 96, 32,  0,192, 32,  1,128, 32,  3,  0, 32,
      2,  0, 32,  2,  0, 32,  2,  0, 96,  2,  0, 64,  2,  0,192,
      1,  0,128,  0,193,  0,  0, 35,  0,  0, 30,  0,  0, 14,  0,
      0, 11,  0,  0, 17,128,  0, 32,192,  0, 64, 64,  0,128, 32,
      1,  0, 32,  2,  0, 32,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* alpha /* - */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  4,  0,  0,  8,  0,  0, 48,  0,  0, 64,
      0,  0,128,  0,  3,  0,  0,  4,128,  0, 24, 64,  0, 32, 64,
      0,200, 64,  1,  8, 64,  2,  8, 32,  2,  8, 32,  2,  8, 32,
      2,  8, 32,  2,  8, 32,  2,  8, 32,  2,  8, 32,  2, 12, 32,
      2, 18, 32,  2, 18, 32,  1, 19, 32,  1,225,192,  0,224,192,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* beta /* . */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,128,  0,  1,128,  0,
      1,  0,  0,  3,  0,  0,  3,  0,  0,  3,  0,  0,  3,  0,  0,
      1,  0,  0,  1,  0,  0,  0,128, 32,  0, 96,224,  0, 31,128,
      0,  2,  0,  0,  4,  0,  0,  8,  0,  0, 48,  0,  0, 64,  0,
      0,128,  0,  3,  0,  0,  2,  0,  0,  2,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* gamma /* / */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  7,  0,  0,  7,128,
      1,143,192,  3,152,192,  3,216, 64,  2, 80, 32,  2, 96, 32,
      2, 96, 32,  2, 32, 32,  2, 32, 32,  2, 32, 32,  2, 32, 32,
      2, 32, 32,  2, 32, 32,  2, 32, 32,  1, 16, 64,  0,144, 64,
      0, 24,192,  0, 15,128,  0, 15,128,  0,  7,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* delta /* 0 */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 14,  0,  0, 31,128,
      0, 63,192,  0,125,192,  0,248, 96,  0,200, 96,  1,136, 32,
      1,136, 32,  1,  8, 32,  1,  8, 32,  1,  8, 32,  1,  0, 32,
      1,  0, 32,  1,  0, 32,  1,  0,  0,  1,  0,  0,  1,  0,  0,
      1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* epsilon /* 1 */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  0,  7,128,
      0,  7,128,  0, 12,128,  0,  8,128,  0,  8,128,  0,  8,128,
      0, 16,128,  2, 16,160,  1, 16,160,  1, 32,160,  1, 32,160,
      1, 64,160,  1, 64,160,  1,192,160,  1,128,160,  1,128,160,
      1,  0,224,  2,  0, 64,  2,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* zeta /* 2 */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,128,  0,
      0,128,  0,  1,  0,  0,  1,  0,  0,  2,  0,128,  2,  7,  0,
      2, 56,  0,  1,224,  0,  0, 64,  0,  0,128,  0,  0,128,  0,
      1,  0,  0,  2,  0,  0,  2,  0,  0,  2,  0,  0,  2,  0,  0,
      2,  0,  8,  1,  0, 16,  1,  0, 96,  0,131,128,  0,124,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* eta /* 3 */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,128,  0,  7,192,
      0, 14, 32,  0, 24, 32,  0, 56, 32,  0, 56, 32,  0,104, 32,
      0,104, 32,  0,200, 64,  0,200,192,  0,136,128,  1,137,128,
      1,137,  0,  3, 11,  0,  2, 10,  0,  2, 10,  0,  2, 12,  0,
      2, 12,  0,  2, 24,  0,  2, 48,  0,  1,224,  0,  0,192,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* theta /* 4 */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  1,128,  0,  3,192,  0,  4, 32,
      0,  8, 32,  0, 16, 32,  0, 32, 32,  0, 64, 32,  0,128, 32,
      0,128, 64,  1,  0,128,  2,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* iota /* 5 */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 32,  0,  0, 96,
      0,  1,192,  0,  3,  0,  0,  6,  0,  0, 28,  0,  0, 60,  0,
      0,104,  0,  0,200,  0,  1,136,  0,  3, 12,  0,  2, 20,  0,
      0, 54,  0,  0, 35,  0,  0, 97,128,  0, 64,192,  0,192, 64,
      1,128, 32,  3,128, 32,  3,  0,  0,  3,  0,  0,  2,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* kappa /* 6 */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 32,
      0,  0, 96,  0,  0, 96,  4,  0,224,  6,  1,192,  7,  3,128,
      3,135,  0,  1,198,  0,  0,252,  0,  0,120,  0,  0, 60,  0,
      0,  6,  0,  0,  7,  0,  0,  3,128,  0,  1,192,  0,  0,224,
      0,  0, 96,  0,  0, 32,  0,  0, 32,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* lambda /* 7 */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0, 24,  0,  0, 32,
      0,  0,192,  0,  3,  0,  0, 12,  0,  0, 63,192,  0,192, 32,
      3,  0, 32,  0,  0, 32,  0,  0, 32,  0,  0, 32,  0,  0, 64,
      0,  0, 64,  0,  0,128,  0,  0,128,  0,  1,192,  0,  6, 32,
      0, 24, 32,  0, 96, 32,  1,128, 32,  2,  0, 64,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* mu /* 8 */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 32,
      2,  0,224,  2,  3,224,  2, 15,224,  2, 63, 32,  2,252, 32,
      3,240, 32,  3,192, 64,  3,  0, 64,  0,  0, 64,  0,  0,128,
      0,  0,128,  0,  1,  0,  0,  2,  0,  0,  4,  0,  0,  8,  0,
      0, 16,  0,  0, 32,  0,  3,192,  0,  3,192,  0,  3,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* nu /* 9 */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,224,
      0,  1,224,  0,  3,224,  0,102, 32,  4,252, 32, 10,216, 32,
      2,136, 36,  3,136, 36,  3,  8, 36,  2,  8, 40,  2,  8, 40,
      2,  8, 40,  2,  8, 56,  2, 24, 48,  2, 24, 32,  2,  0,  0,
      4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	 /* xi/* : */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 60,  0,  0,126,  0,
      0,127,  0,  0,195,  0,  1,129,128,  1,128,128,  1,  0,192,
      2,  0,192,  2,  0,192,  2,  0,192,  2,  0,192,  2,  0,192,
      2,  0,128,  2,  1,  0,  2,  1,  0,  2,  3,  0,  3,  6,  0,
      1,158,  0,  1,252,  0,  0,248,  0,  0, 96,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* omicron /* ; */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,192,  0,  1,128,  0,
      3,  0, 32,  3,  0,224,  7,  3,224,  7, 15,224,  7,252,  0,
      7,240,  0,  7,  0,  0,  7,  0,  0,  7,  0,  0,  7,  0,  0,
      7,  0,  0,  7,  0,  0,  7, 15,224,  7,127,224,  7,240,224,
      7,128, 32,  7,  0,  0,  7,  0,  0,  6,  0,  0,  4,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* pi /* < */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0, 12,  0, 60,252,  0,127,252,
      0,127,240,  0,195,  0,  1,129,128,  1,128,128,  1,  0,128,
      2,  0,128,  2,  0,128,  2,  0,128,  2,  0,128,  2,  0,128,
      2,  0,128,  2,  1,  0,  2,  1,  0,  2,  3,  0,  3,  6,  0,
      1,158,  0,  1,252,  0,  0,248,  0,  0, 96,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* rho /* = */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 60,  0,  0,126,  0,
      0,127,  0,  0,195,  0,  1,129,128,  1,128,128,  1,  0,128,
      2,  0,128,  2,  0,128,  2,  0,128,  2,  0,128,  2,  0,128,
      2,  0,128,  2,  1,  0,  2,  1,  0,  2,  3,  0,  3,  6,  0,
      3,158,  0,  3,252,  0,  3,248,  0,  3,224,  0,  3,128,  0,
      3,128,  0,  3,128,  0,  3,128,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* sigma /* > */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,128,  0,  1,  0,  0,  1,  0,  0,  3,  0,  0,
      3,  0,  0,  3,  0, 96,  3,  1,224,  3,  7,192,  3, 24,  0,
      3,224,  0,  3,  0,  0,  3,  0,  0,  3,  0,  0,  3,  0,  0,
      3,  0,  0,  3,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* tau /* ? */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,
      3,  0,  0,  3,  0, 64,  3,224,224,  0,255,224,  0, 31, 32,
      0,  0, 32,  0,  0, 32,  0,  0, 32,  0,  0, 64,  0,  0, 64,
      0,  0,128,  0,  1,  0,  0,  2,  0,  0,  4,  0,  0,  8,  0,
      0, 16,  0,  0, 32,  0,  0, 64,  0,  3,128,  0,  3,  0,  0,
      2,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* upsilon /* @ */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 30,  0,  0, 63,132,
      0, 97,200,  0,192,112,  1,128, 32,  1,  0, 96,  2,  0,160,
      2,  1, 32,  2,  2, 32,  2,  4, 32,  2,  8, 32,  2, 16, 32,
      2, 32, 32,  2, 64, 96,  2,128, 96,  3,  0, 64,  2,  0,128,
      6,  1,128,  9,  7,  0, 17,142,  0,  0,248,  0,  0,112,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* phi /* A */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  2,  0, 32,
      2,  0, 64,  3,  0,128,  3,  1,  0,  1,129,  0,  0,194,  0,
      0, 98,  0,  0, 52,  0,  0, 28,  0,  0, 12,  0,  0, 14,  0,
      0, 19,  0,  0, 17,  0,  0, 32,128,  0, 64,192,  0,128, 64,
      3,  0, 32,  0,  0, 32,  0,  0, 32,  0,  0, 32,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* chi /* B */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      2,  0,  0,  2,  0,  0,  2,  0,192,  2,  7,228,  1,255, 56,
      0,248, 32,  0,  0,224,  0,  3, 32,  0, 12, 64,  0, 48, 64,
      0, 64, 64,  1,129,128,  6,  3,128,  8, 14,  0,  0, 60,  0,
      0,240,  0,  1,192,  0,  3,  0,  0,  2,  0,  0,  2,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* psi /* C */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  7,128,  0, 24, 64,
      0, 96, 32,  0,128, 32,  1,  0, 32,  2,  0, 32,  0,  0, 32,
      0,  0, 64,  0,  0, 64,  0,  0,128,  0,  1,  0,  0, 15,128,
      0,  0, 64,  0,  0, 32,  0,  0, 32,  0,  0, 32,  0,  0, 32,
      0,  0, 32,  2,  0, 64,  1,128,128,  0, 97,  0,  0, 30,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* omega /* D */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  8,  0, 32,  8,  0, 32, 15,255,224,
     15,255,224, 15,255,224,  8,  0, 32,  8,  0, 32,  8,  0,  0,
      8,  0,  0,  8,  0,  0,  8,  0,  0,  8,  0,  0,  8,  0,  0,
      8,  0,  0,  8,  0,  0,  8,  0,  0,  8,  0,  0,  8,  0,  0,
      8,  0,  0,  8,  0,  0,  8,  0,  0, 12,  0,  0, 14,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* Gamma /* E */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 32,  0,  0, 96,
      0,  1,160,  0,  2, 32,  0, 12, 32,  0, 16, 32,  0, 32, 32,
      0, 64, 32,  1,128, 32,  2,  0, 32, 12,  0, 32,  6,  0, 32,
      3,  0, 32,  1,128, 32,  0,224, 32,  0,112, 32,  0, 24, 32,
      0, 14, 32,  0,  7, 32,  0,  1,160,  0,  0,224,  0,  0, 96,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* Delta /* F */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 60,  0,  0,126,  0,
      0,199,  0,  1,131,128,  3,  1,128,  6,  0,192,  4,124, 64,
      8, 56, 32,  8, 16, 32,  8, 16, 32,  8, 16, 32,  8, 16, 32,
      8, 16, 32,  8, 56, 32,  4,124, 64,  6,  0,192,  2,  0,128,
      1,  1,128,  1,131,  0,  0,198,  0,  0,126,  0,  0, 60,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* Theta /* G */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0, 32,  0,  0, 32,  0,  0, 96,
      0,  1,160,  0,  2,  0,  0, 12,  0,  0, 16,  0,  0, 32,  0,
      0, 64,  0,  1,128,  0,  2,  0,  0, 12,  0,  0, 14,  0,  0,
      7,  0,  0,  3,128,  0,  1,224,  0,  0,240,  0,  0,120,  0,
      0, 30,  0,  0, 15,  0,  0,  7,160,  0,  1,224,  0,  0,224,
      0,  0, 96,  0,  0, 32,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* Lambda /* H */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 32,  0,  8,192,
      1, 49,192, 14,112,192,  6, 48,192,  6, 48,192,  6, 48,192,
      6, 48,192,  6, 48,192,  6, 48,192,  6, 48,192,  6, 48,192,
      6, 48,192,  6, 48,192,  6, 48,192,  6, 48,192,  6, 48,192,
      6, 48,192,  6, 48,224,  6, 56,192,  7, 49,  0, 14, 64,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* Xi /* I */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  8,  0, 32,  8,  0, 32,
     15,255,224, 15,255,224, 15,255,224,  8,  0, 32,  8,  0, 32,
      8,  0,  0,  8,  0,  0,  8,  0,  0,  8,  0,  0,  8,  0,  0,
      8,  0,  0,  8,  0,  0,  8,  0,  0,  8,  0, 32,  8,  0, 32,
     15,255,224, 15,255,224, 15,255,224,  8,  0, 32,  8,  0, 32,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* Pi /* J */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  8,  0, 32, 12,  0, 96,
     14,  0,224, 13,  1, 96, 12,130, 96, 12, 68, 96, 12, 40, 96,
     12, 16, 96, 12,  0, 96, 12,  0, 96, 12,  0, 96, 12,  0, 96,
     12,  0, 96, 12,  0, 96, 12,  0, 96, 12,  0, 96, 12,  0, 96,
     12,  0, 96, 12,  0, 96, 12,  0, 96,  4,  0,224,  2,  1,224,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* Sigma /* K */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  7,  0,  0, 15,  0,  0,
     12,  0,  0, 12,  0,  0, 12,  0,  0, 14,  0,  0,  7,  0,  0,
      3,128, 32,  3,192, 32,  1,255,224,  0,255,224,  1,255,224,
      3,  0, 32,  2,  0, 32,  4,  0,  0,  4,  0,  0,  8,  0,  0,
      8,  0,  0,  8,  0,  0,  8,  0,  0,  8,  0,  0,  6,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* Upsilon /* L */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0, 28,  0,  0, 62,  0,  0,127,  0,
      0,247,128,  0,193,128,  1,128,192,  1,  0, 64,  1,  0, 64,
     18,  0, 36, 18,  0, 36, 31,255,252, 31,255,252, 31,255,252,
     18,  0, 36, 18,  0, 36, 17,  0, 64,  1,  0, 64,  1,128,192,
      0,193,128,  0,247,128,  0,127,  0,  0, 62,  0,  0, 28,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* Phi /* M */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,192,  0,  1,128,  0,
      3,  0,  0,  3,  0,  0,  1,255,  0,  0,255,128,  0,  0,192,
      8,  0, 72,  8,  0,104, 15,255,248, 15,255,248, 15,255,248,
      8,  0,104,  8,  0, 72,  0,  0,192,  0,255,128,  1,255,  0,
      3,  0,  0,  3,  0,  0,  1,128,  0,  0,192,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* Psi /* N */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0, 64,  0, 56, 96,  0,252, 32,
      1,254, 32,  3,198, 32,  3,  3, 32,  7,  1,160,  4,  1,160,
     12,  0,224, 12,  0,  0, 12,  0,  0,  8,  0,  0, 12,  0,  0,
     12,  0,  0, 12,  0,224,  4,  1,160,  7,  1,160,  3,  3, 32,
      3,198, 32,  1,254, 32,  0,252, 32,  0, 56, 96,  0,  0, 64,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* Omega /* O */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,192,  0,  0,192,  0,
      1,192,  0,  1,128,  0,  3,224,  0,  0,248,  0,  0,127,128,
      0, 31,224,  0,  7,224,  0,  1,224,  0,  0,192,  0,  1,128,
      0,  3,  0,  0,  6,  0,  0, 28,  0,  0, 56,  0,  0,224,  0,
      1,192,  0,  7,  0,  0, 14,  0,  0, 24,  0,  0,112,  0,  0,
     96,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* square root /* P */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,224,  0,  1,240,  0,
      3,120,  0,  2, 28,  0,  2, 12, 64,  2,  6, 32,  2,  7, 32,
      2,  3,224,  3,  1,192,  1,128,192,  0,192,  0,  0,224,  0,
      0, 96,  0,  0, 32,  0,  0, 32,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* terminal sigma /* Q */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  8,  0, 65,  8,  0, 65,
      8,  0,195, 12,  0,130,  4,  1,134,  4,  1,132,  4,  1,  4,
      6,  3, 12,  2,  2,  8,  2,  2,  8,  2,  6, 24,  3,  4, 16,
      1, 12, 48,  1,  8, 48,  1,  8, 32,  1,152, 96,  0,144, 64,
      0,144, 64,  0,240,192,  0, 96,192,  0, 97,128,  0, 65,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* >= /* R */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 33,  0,  0, 49,128,
      0,113,128,  0, 88,192,  0,200, 64,  0,200, 64,  0,136, 64,
      0,140, 96,  0,132, 32,  1,134, 48,  1,  2, 16,  1,  2, 16,
      3,  3, 24,  2,  1,  8,  2,  1,140,  6,  0,132,  4,  0,132,
      4,  0,198,  4,  0, 66, 12,  0, 66,  8,  0, 99,  8,  0, 33,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* <= /* S */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      6, 24, 96,  6, 24, 96,  6, 24, 96,  6, 24, 96,  6, 24, 96,
      6, 24, 96,  6, 24, 96,  6, 24, 96,  6, 24, 96,  6, 24, 96,
      6, 24, 96,  6, 24, 96,  6, 24, 96,  6, 24, 96,  6, 24, 96,
      6, 24, 96,  6, 24, 96,  6, 24, 96,  6, 24, 96,  6, 24, 96,
      6, 24, 96,  6, 24, 96,  6, 24, 96,  6, 24, 96,  6, 24, 96,
      6, 24, 96,  6, 24, 96,  6, 24, 96,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* ident == /* T */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0, 35,  0,  0, 99,  0,  0, 67,  0,  0,195,  0,  0,131,  0,
      1,131,  0,  1,  3,  0,  3,  3,  0,  2,  3,  0,  2,  3,  0,
      3,  3,  0,  1,  3,  0,  1,131,  0,  0,131,  0,  0,195,  0,
      0, 67,  0,  0, 99,  0,  0, 35,  0,  0, 51,  0,  0, 19,  0,
      0, 19,  0,  0, 19,  0,  0, 51,  0,  0, 99,  0,  0, 67,  0,
      0,195,  0,  0,131,  0,  1,131,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* approx = /* U */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  4,  0,  0, 12,  0,  0,  8,  0,  0, 24,  0,  0, 16,  0,
      0, 48,  0,  0, 32,  0,  0, 96,  0,  0, 64,  0,  0, 64,  0,
      0, 96,  0,  0, 32,  0,  0, 48,  0,  0, 16,  0,  0, 24,  0,
      0,  8,  0,  0, 12,  0,  0,  4,  0,  0,  6,  0,  0,  2,  0,
      0,  2,  0,  0,  2,  0,  0,  6,  0,  0, 12,  0,  0,  8,  0,
      0, 24,  0,  0, 16,  0,  0, 48,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* approximates /* V */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0, 97,128,  0, 97,129,  0, 97,131,  0, 97,134,  0, 97,140,
      0, 97,152,  0, 97,176,  0, 97,224,  0, 97,192,  0, 97,128,
      0, 99,128,  0,103,128,  0,109,128,  0,121,128,  0,113,128,
      0, 97,128,  0,225,128,  1,225,128,  3, 97,128,  6, 97,128,
     12, 97,128, 24, 97,128,208, 97,128, 64, 97,128,  0, 97,128,
      0, 97,128,  0, 97,128,  0, 97,128,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* not equal /* W */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0, 56,  0,  0, 56,  0,  0, 56,  0,  0, 56,  0,  0, 56,  0,
      0, 56,  0,  0, 56,  0,  0, 56,  0,  0, 56,  0,  0, 56,  0,
      0, 56,  0,  0, 56,  0,  0, 56,  0,  0, 56,  0,  0, 56,  0,
      0, 56,  0,  0, 56,  0,  0, 56,  0,  0, 56,  0,  0, 56,  0,
      0, 56,  0,  0, 56,  0,  0, 56,  0,  1,255,  0,  0,254,  0,
      0,124,  0,  0, 56,  0,  0, 16,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* right arrow /* X */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0, 16,  0,  0, 56,  0,  0,124,  0,  0,254,  0,  1,255,  0,
      0, 56,  0,  0, 56,  0,  0, 56,  0,  0, 56,  0,  0, 56,  0,
      0, 56,  0,  0, 56,  0,  0, 56,  0,  0, 56,  0,  0, 56,  0,
      0, 56,  0,  0, 56,  0,  0, 56,  0,  0, 56,  0,  0, 56,  0,
      0, 56,  0,  0, 56,  0,  0, 56,  0,  0, 56,  0,  0, 56,  0,
      0, 56,  0,  0, 56,  0,  0, 56,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* left arrow /* Y */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  8,  0,  0,
     24,  0,  0, 56,  0,  0,127,255,255,255,255,255,127,255,255,
     56,  0,  0, 24,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* up arrow /* Z */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 16,
      0,  0, 24,  0,  0, 28,255,255,254,255,255,255,255,255,254,
      0,  0, 28,  0,  0, 24,  0,  0, 16,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* down arrow /* [ */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0, 48,  0,  0, 48,  0,  0, 48,  0,  0, 48,  0,  0, 48,  0,
      0, 48,  0,  0, 48,  0,  0, 48,  0,  0, 48,  0,  0, 48,  0,
      3, 51,  0,  3, 51,  0,  3, 51,  0,  3, 51,  0,  3, 51,  0,
      3, 51,  0,  3, 51,  0,  0, 48,  0,  0, 48,  0,  0, 48,  0,
      0, 48,  0,  0, 48,  0,  0, 48,  0,  0, 48,  0,  0, 48,  0,
      0, 48,  0,  0, 48,  0,  0, 48,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* divide /* \ */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,255,248,  0,255,254,  0,
      0,  7,  0,  0,  3,128,  0,  0,128,  0,  0,192,  0,  0, 64,
      0,  0, 96,  0,  0, 96,  0,  0, 96,  0,  0, 96,  0,  0, 96,
      0,  0, 96,  0,  0, 96,  0,  0,192,  0,  0,128,  0,  1,128,
      0,  1,  0,  0,  3,  0,  0,  6,  0,255,252,  0,255,248,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* cup /* ] */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,255,252,  7,255,252,
     14,  0,  0, 24,  0,  0, 48,  0,  0, 48,  0,  0, 32,  0,  0,
     96,  0,  0, 96,  0,  0, 96,  0,  0, 96,  0,  0, 96,  0,  0,
     96,  0,  0, 96,  0,  0, 32,  0,  0, 48,  0,  0, 48,  0,  0,
     16,  0,  0, 28,  0,  0, 15,  0,  0,  3,255,252,  0,255,252,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* cap /* ^ */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,124,  0,  0,255,  0,  1,131,128,  3,  1,192,  2,  0,192,
      6,  0, 96, 12,  0, 96, 12,  0, 96, 12,  0, 96, 12,  0, 96,
     12,  0, 96, 12,  0, 96, 12,  0, 96, 12,  0, 96, 12,  0, 96,
     12,  0, 96, 12,  0, 96, 12,  0, 96, 12,  0, 96, 12,  0, 96,
     12,  0, 96, 12,  0, 96, 12,  0, 96, 12,  0, 96, 12,  0, 96,
     12,  0, 96, 12,  0, 96, 12,  0, 96,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* subset of /* _ */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
     12,  0, 96, 12,  0, 96, 12,  0, 96, 12,  0, 96, 12,  0, 96,
     12,  0, 96, 12,  0, 96, 12,  0, 96, 12,  0, 96, 12,  0, 96,
     12,  0, 96, 12,  0, 96, 12,  0, 96, 12,  0, 96, 12,  0, 96,
     12,  0, 96, 12,  0, 96, 12,  0, 96, 12,  0, 96, 12,  0, 96,
     12,  0, 96,  4,  0,192,  6,  0,192,  3,  1,128,  1,131,  0,
      1,231,  0,  0,126,  0,  0, 56,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* superset of /* ` */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      1,240, 48,  3,252, 48,  6, 14, 48, 12,  7, 48,  8,  3, 48,
     24,  1,176, 48,  1,176, 48,  1,176, 48,  1,176, 48,  1,176,
     48,  1,176, 48,  1,176, 48,  1,176, 48,  1,176, 48,  1,176,
     48,  1,176, 48,  1,176, 48,  1,176, 48,  1,176, 48,  1,176,
     48,  1,176, 48,  1,176, 48,  1,176, 48,  1,176, 48,  1,176,
     48,  1,176, 48,  1,176, 48,  1,176,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* improper subset /* a */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
     48,  1,152, 48,  1,152, 48,  1,152, 48,  1,152, 48,  1,152,
     48,  1,152, 48,  1,152, 48,  1,152, 48,  1,152, 48,  1,152,
     48,  1,152, 48,  1,152, 48,  1,152, 48,  1,152, 48,  1,152,
     48,  1,152, 48,  1,152, 48,  1,152, 48,  1,152, 48,  1,152,
     48,  1,152, 16,  3, 24, 24,  3, 24, 12,  6, 24,  6, 12, 24,
      7,156, 24,  1,248, 24,  0,224, 24,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* improper superset /* b */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0, 30,  0,  0, 63,  0,  0,127,128,  0,225,192,  0,192,224,
      0,128,224,  0,128, 96,  0,128, 96,  0,192,192,  0,224,192,
      0,115,128,  0, 63,  0,  0, 15,  0,  0, 31,  0,  0, 51,  0,
      0, 97,192,  0,192,192,  0,128, 96,  0,128, 96,  0,128, 96,
      0,128, 96,  0,192, 96,  0,192,224,  0,113,192,  0, 63,128,
      0, 31,  0,  0, 14,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* infinity /* c */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 28,  0,  0,127,  0,
      0,255,128,  9,227,192, 25,128,192, 59,  0, 96,107,  0, 96,
     99,  0, 96, 99,  0, 96, 99,  0, 96, 99,  0, 96, 99,  0, 96,
     99,  0, 96, 49,  0, 64, 17,192,192, 24,227,192,  8,255,128,
     12, 63,  0,  6, 28,  0,  3,248,  0,  1,240,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* partial derivative /* d */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  8,  0,  0, 12,  0,  0,
     14,  0,  0, 15,128,  0, 15,224,  0, 14,112,  0, 14, 24,  0,
     14, 14,  0, 14,  7,128, 14,  1,192, 14,  0, 96, 14,  1,224,
     14,  3,192, 14,  7,128, 14, 30,  0, 14, 60,  0, 14,120,  0,
     14,224,  0, 15,192,  0, 15,128,  0, 15,  0,  0, 12,  0,  0,
      8,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* gradient /* e */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,112,  0,  0,112,  0,  0,112,  0,  0,112,  0,  0,112,  0,
      0,112,  0,  0,112,  0,  0,112,  0,  0,112,  0,  0,112,  0,
      0,112,  0,  0,112,  0,  0,112,  0,  0,112,  0,  0,112,  0,
      0,127,  0,  0,127,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* not /* f */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0, 14,  0,  0, 31,  0,  0, 63,  0,  0, 31,  0,  0, 14,
      0,  0,  6,  7,255,254, 15,255,252, 31,255,248, 63,255,240,
     96,  0,  0,112,  0,  0,248,  0,  0,248,  0,  0,112,  0,  0,
     32,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* integral sign /* g */
    },
    {
     27,'p',  1, 27,'&',  0,'A','A',  4, 28,  5,
      0,  0,  0,  0,  0,  0,  0,120,  0,  0,252,  0,  1,254,  0,
      1,254,  0,  3,255,  0,  3, 51,  0,  6, 49,128,  6, 49,128,
     12, 48,192, 12, 48,192, 24, 48, 96, 24, 48, 96, 24, 48, 96,
     24, 48, 96, 24, 48, 96, 24, 48, 96, 24, 48, 96, 24, 48, 96,
     24, 48, 96, 24, 48, 96, 24, 48, 96, 24, 48, 96, 24, 48, 96,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
     27,'%',  1,'A', 27,'%',  0, 27,'p',  0	/* member of /* h */
    },
    { 0 },	/* i */
    { 0 },	/* j */
    { 0 },	/* k */
    { 0 },	/* l */
    { 0 },	/* m */
    { 0 },	/* n */
    { 0 },	/* o */
    { 0 },	/* p */
    { 0 },	/* q */
    { 0 },	/* start zero-width symbols /* r */
    { 0 },	/* s */
    {
    ESC,'U',  1,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0	/* unidirectional on /* t */
    },
    {
    ESC,'U',  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0	/* unidrectional off /* u */
    },
    {
    ESC,'E',  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0	/* emphasized on /* v */
    },
    {
    ESC,'F',  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0	/* emphasized off /* w */
    },
    {
    ESC,'x',  1,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0	/* nlq  /* x */
    },
    {
    ESC,'x',  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0	/* draft /* y */
    },
    {
    ESC,'M',  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0	/* elite (12 per inch) /* z */
    },
    {
    ESC,'P',  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0	/* pica (10 per inch) /* { */
    },
    {
    ESC,'4',  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0	/* italic on /* | */
    },
    {
    ESC,'5',  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0	/* italic off /* } */
    },
    {
    ESC,'@',  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0	/* reset all /* ~ */
    },
    {
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0	/* dummy /* del */
    },
    };

#define TABLE_ARRAY_SIZE		sizeof(table) / TABLE_ELEM_SIZE

