/* epf */

/*-
 * This filter for Epson LQ-1500 compatibles prints the nroff Non-ASCII 
 * Special Characters.
 *
 * Greek characters and mathematical characters are implemented. 
 *
 * Neqn displays are not bad.
 *
 * Assumes the nroff driver tables were written for representations
 * compatible with "col", ie SO-<single printable char>-SI and 
 * ESC-[789] for line movements.
 *
 * The table of user-defined-character strings is in matrix.h.
 *
 * Author:
 * John Nellen, Delft Univ. of Technology 
 * ..!{decvax,philabs}!mcvax!dutesta!john 
 *
 * Source:
 * Newsgroups: net.sources
 * Subject: Epson filter to type nroff Non-ASCII char's (no 1 of 4)
 * Message-ID: <371@dutesta.UUCP>
 * Date: 30 Oct 85 09:54:20 GMT
 *
 * Rewritten Jul 1, 1989:
 * J.A. Rupley
 * rupley!local@megaron.arizona.edu
 */


#include	<stdio.h>

#define		LINE		30	/* 180 / 6 -- Epson ESC-J scale */
#define		HALFLINE	15	/* LINE / 2 */

#define		NORMAL		0
#define		GRAPHICS	1

#define		ESC	27
#define		SO	'\016'		/* shift out to alternate char set */
#define		SI	'\017'

#include	"matrix.h"

int
main()
{
	int             j, cnt, state;
	int             c, curchar;

	state = NORMAL;
	curchar = getchar();
	while (curchar != EOF) {
		if (curchar == ESC) {
			if ((c = getchar()) == EOF)
				break;
			switch (c) {
			case '8':
				putchar(ESC);	/* reverse half line feed */
				putchar('j');	/* not passed by "col" */
				putchar(HALFLINE); /* therefore useless? */
				break;
			case '9':
				putchar(ESC);	/* forward half line feed */
				putchar('J');
				putchar(HALFLINE);
				break;
			case '7':
				putchar(ESC);	/* reverse full line feed */
				putchar('j');	/* not passed by "col" */
				putchar(LINE);	/* therefore useless? */
				break;
			default:
				putchar(ESC);	/* put ESC back on line */
				putchar(c);
			}
		} else if (curchar == SI) {
			state = NORMAL;
		} else if (curchar == SO) {
			state = GRAPHICS;
		} else if (state == GRAPHICS) {
			cnt = (curchar - '!');
			if (cnt < 0 || cnt >= TABLE_ARRAY_SIZE) {
				putchar(curchar);
			} else {
				for (j = 0; j < TABLE_ELEM_SIZE; j++) {
					putchar(table[cnt][j]);
				}
			}
		} else {
			putchar(curchar);
		}
		curchar = getchar();
	}

	return 0;
}
