#ifndef		FONTDIR
#define		FONTDIR		"/usr/lib/ditroff"
#endif

#define		DEF_DEV		"dvi"
#define		NFONTS		100
#define		NSIZES		20

#define		RULE_CHAR	0201		/* put here by tfm2desc */

char		*strcpy(), *sprintf();

typedef		unsigned char	uchar;

extern char	pageoffset;
extern char	*prog_name;

/*
**	characteristics of a typesetter
*/

typedef struct tdev {
      unsigned  short filesize;	/* number of bytes in file, */
				/* excluding dev part */
	short	res;		/* basic resolution in goobies/inch */
	short	hor;		/* goobies horizontally */
	short	vert;
	short	unitwidth;	/* size at which widths are given, in effect */
	short	nfonts;		/* number of fonts physically available */
	short	nsizes;		/* number of sizes it has */
	short	sizescale;	/* scaling for fractional point sizes */
	short	paperwidth;	/* max line length in units */
	short	paperlength;	/* max paper length in units */
	short	nchtab;		/* number of funny names in chtab */
	short	lchname;	/* length of chname table */
	short	spare1;		/* in case of expansion */
	short	spare2;
	} tdev;

typedef struct tfont {		/* characteristics of a font */
	uchar	nwfont;		/* number of width entries for this font */
	char	specfont;	/* 1 == special font */
	char	ligfont;	/* 1 == ligatures exist on this font */
	char	spare1;		/* unused for now */
	char	namefont[10];	/* name of this font (e.g., "R" */
	char	intname[10];	/* internal name on device, in ascii */
	} tfont;

/* ligatures, ORed into ligfont */

#define	LFF	01
#define	LFI	02
#define	LFL	04
#define	LFFI	010
#define	LFFL	020

typedef struct lookup {
	char		*chname;
	short		ordinal;
	} lookup;

typedef struct settings {
	char		s_ts_name[20];		/* name of typesetter */
	char		*s_font_name;		/* current font name */
	int		s_font_num;		/* current font number */
	int		s_point_size;		/* current point size */
	int		s_point_index;		/* index into pstab and raster */
	int		s_page_num;		/* current page number */
	int		s_H, s_V;		/* H and V ints */
	int		s_resolution, s_horizontal,
			s_vertical;		/* of typesetter */
	} settings;

typedef	struct fontdes {
	tfont		*tfontp;		/* font entry */
	uchar		*widtab;		/* width table */
	uchar		*kerntab;		/* kerning table */
	uchar		*codetab;		/* code table */
	uchar		*fitab;			/* font index table */
	int		texfont[NSIZES];	/* number of font in DVI file */
	} fontdes;

/* define some macros for convenient reference to fields */
#define	n_width		tfontp->nwfont		/* first thing in font entry */
#define	font_name	tfontp->namefont	/* array of char */
#define	int_name	tfontp->intname		/* array of char */

extern tdev	dev;
extern int	halfwidth;
extern short	*pstab;
extern lookup	*specialtab;
extern settings	engine;				/* where we are at now */
extern fontdes	fonts[NFONTS];
