#include	<stdio.h>
#include	<ctype.h>
#include	"ditdvi.h"

/*
**	The heart of the converter, read ditroff, spit out DVI.
*/

#undef		DEBUG_INPUT
#undef		USE_PUT

/* same values as TeX82 uses */
#define		FIX		(1<<16)
#define		CPIN		7227		/* centipoints in an inch */
#define		NUM		25400000
#define		DEN		(CPIN*FIX)
#define		UNITY		1000

/* paper dimensions */
#define		HEIGHT		(11*72*FIX)	/* height in scaled pts */
#define		WIDTH		(17*36*FIX)	/* width in scaled pts */

/* goobies to scaled points */
#define		gtosp(g)	((g)*scale)

#define		vmove(n)	down(gtosp(n)), engine.s_V += (n)

settings	engine	= {
	DEF_DEV, "R",			/* s_ts_name, s_font_name */
	0, 0,				/* s_font_num, s_point_size */
	0,				/* s_point_index */
	0,				/* s_page_num */
	0, 0,				/* s_H, s_V */
	0, 0, 0,			/* resolution, horizontal, vertical */
};

int	counters[10]	= { 0 };
int	scale		= 0;
int	last_move	= 0;
char	fontchanged	= 0;

int	mag		= UNITY;
int	back		= -1;		/* back pointer for bop */
char	bopsent		= 0;

int	fontind		= 0;

struct fonttab {
	int		font;
	int		size;
	} fonttab[NFONTS];

static int getnum()
{
	register int	i, c;

	while (isspace(c = getchar()))
		;
	(void)ungetc(c, stdin);
	for (i = 0; isdigit(c = getchar()); )
		i = i * 10 + c - '0';
	(void)ungetc(c, stdin);
	return (i);
}

static int getint()
{
	register int	i;
	register char	c, flag = 0;

	while (isspace(c = getchar()))
		;
	if (c == '-')
		flag = 1;
	else
		(void)ungetc(c, stdin);
	for (i = 0; isdigit(c = getchar()); )
		i = i * 10 + c - '0';
	(void)ungetc(c, stdin);
	return (flag ? -i : i);
}

static resolve_name(font, size, name, newmag)
	char		*name;
	int		font, size;
	double		*newmag;
{
	char		*index();

	*newmag = 1.0;
	(void)strcpy(name, fonts[font].int_name);
	if (size <= 10)
	{
		/* stop at first digit */
		for ( ; *name != '\0'; ++name)
			if (isdigit(*name))
				break;
		/* overlay the size spec */
		(void)sprintf(name, "%d", size);
	}
	else switch (size)
	{
		case 11:
			*newmag = 1.095445;
			break;
		case 12:
			*newmag = 1.2;
			break;
		case 14:
			*newmag = 1.44;
			break;
		case 17:
			*newmag = 1.728;
			break;
		case 24:
		case 25:
			*newmag = 2.48832;
			break;
		default:
			(void)fprintf(stderr, "Can't handle point size %d\n",
				size);
			break;
	}
}

static loadfont(font, sizeindex)
	int		font, sizeindex;
{
	register int	size	= pstab[sizeindex];
	double		newmag;
	char		fontfile[256];

	fontchanged = 0;
	/* defined yet? */
	if (fonts[font].texfont[sizeindex] < 0)
	{
		resolve_name(font, size, fontfile, &newmag);
		fnt_def(fontind, 0, (int)(newmag * (double)(size * (1<<16))),
			size * (1<<16), "", fontfile);
		fonttab[fontind].font = font;
		fonttab[fontind].size = size;
		fonts[font].texfont[sizeindex] = fontind++;
	}
	fnt_num(fonts[font].texfont[sizeindex]);
}

static outchar(ch)
	int		ch;
{
	register int	c, i, index, code, width;
	register fontdes	*f;
	register int	savedfont = -1;

#ifdef	DEBUG_OUTPUT
	(void)fprintf(stderr, "<%c>\n", ch);
#endif	DEBUG_OUTPUT
	c = ch - 32;
	f = &fonts[engine.s_font_num];
	index = f->fitab[c];				/* char to index */
	if (index != 0)
	{
		code = f->codetab[index];
		width = f->widtab[index];
	}
	else						/* a special then */
	{
		for (i = 1; i <= dev.nfonts; ++i)
		{
			f = &fonts[i];
			if (!f->tfontp->specfont)
				continue;
			if (f->fitab == 0)		/* font not available */
				continue;
			if ((index = f->fitab[c]) != 0)
			{
				savedfont = engine.s_font_num;
				engine.s_font_num = i;
				fontchanged = 1;
				code = f->codetab[index];
				width = f->widtab[index];
				break;
			}
		}
	}
	if (index != 0)
	{
		if (fontchanged)
			loadfont(engine.s_font_num, engine.s_point_index);
/*
**	Rule height is roughly 1/18th of point size
*/
#ifdef	USE_PUT
		if (code != RULE_CHAR)
			put_char(code);
		else
			put_rule(gtosp(engine.s_resolution *
			engine.s_point_size / (72 * 18)), gtosp(width));
#else
		if (code != RULE_CHAR)
			set_char(code);
		else
			set_rule(gtosp(engine.s_resolution *
			engine.s_point_size / (72 * 18)), gtosp(width));
		last_move += (width * engine.s_point_size + halfwidth) / dev.unitwidth;
#endif
		if (savedfont >= 0)
		{
			engine.s_font_num = savedfont;
			fontchanged = 1;
		}
	}
	else if (ch != ' ')		/* kludge, space glyph not in fonts */
		(void)fprintf(stderr, "Font %s, glyph %d not found\n",
			fonts[engine.s_font_num].font_name, ch);
}

static outstring(s)
	char		*s;
{
	register int	low, mid, high;
	register char	*t, *m;

#ifdef	DEBUG_OUTPUT
	(void)fprintf(stderr, "<%s>\n", s);
#endif	DEBUG_OUTPUT
	low = 0;
	high = dev.nchtab - 1;
	while (low <= high)
	{
		mid = (low + high) / 2;
		t = s;
		m = specialtab[mid].chname;
		while (*t == *m && *t != '\0')
			++t, ++m;
		if (*t > *m)
			low = mid + 1;
		else if (*t < *m)
			high = mid - 1;
		else				/* equal, found it */
		{
			outchar(specialtab[mid].ordinal + 128);
			break;
		}
	}
}

static hmove(n)
	int		n;
{
	engine.s_H += n;
	if (n == last_move)
	{
		last_move = 0;
		return;
	}
	n -= last_move;
	last_move = 0;
	right(gtosp(n));
}

static hgoto(n)
	int		n;
{
#ifdef	USE_PUT
	engine.s_H += last_move;
	last_move = 0;
	if (n == engine.s_H)
		return;
	hmove(n - engine.s_H);
#else
	pop();
	push();
	down(gtosp(engine.s_V));
	right(gtosp(n));
	engine.s_H = n;
	last_move = 0;
#endif
}

static vgoto(n)
	int		n;
{
	if (n == engine.s_V)
		return;
	vmove(n - engine.s_V);
}

static specialchar()
{
	register char	c, *p;
	char		special[10];

	for (p = special; isprint(c = getchar()); )
		*p++ = c;
	*p = '\0';
	outstring(special);
}

static finishpage()
{
	/* finish previous page */
	if (bopsent)
	{
		pop();
		eop();
		++engine.s_page_num;
	}
	bopsent = 0;
}

static newpage(n)
{
	finishpage();
	last_move = engine.s_H = engine.s_V = 0;
	counters[0] = n;
	back = bop(counters, back);
	/* DVI output origin is at (1in,1in), need to cancel */
	if (pageoffset)
	{
		down(-CPIN * FIX / 100);	/* up 1 in */
		right(-CPIN * FIX / 100);	/* left 1 in */
	}
	push();
	bopsent = 1;
}

static nextword()
{
	register int	c;

	while (!isspace(getchar()))
		;
	while (isspace(c = getchar()))
		;
	(void)ungetc(c, stdin);
}

static getstring(s, len)
	char		*s;
	int		len;
{
	register char	c;

	--len;				/* for the '\0' terminator */
	while (len > 0 && !isspace(c = getchar()))
		*s++ = c;
	*s = '\0';
}

/*
**	If you expect to load fonts above ditroff's limit of 10
**	you may need this routine.
*/
static fontposition(i, s)
	int		i;
	char		*s;
{
}

static postamble()
{
	register int	i;
	double		newmag;
	char		fontfile[256];

	finishpage();		/* ship off pending page */
	/* we use one level of stack */
	post(back, NUM, DEN, mag, HEIGHT, WIDTH, 1, engine.s_page_num);
	for (i = 0; i < fontind; ++i)
	{
		register struct fonttab	*ft = &fonttab[i];

		resolve_name(ft->font, ft->size, fontfile, &newmag);
		fnt_def(i, 0, (int)(newmag * (double)(ft->size * (1<<16))),
			ft->size * (1<<16), "", fontfile);
	}
	post_post();
}

static setfontsize(n)
	int		n;
{
	register int	i;

	for (i = 0; i < dev.nsizes; ++i)
		if (pstab[i] == n)
			break;
	if (i >= dev.nsizes)
	{
		(void)fprintf(stderr, "%d is not a legal point size\n", n);
		return;
	}
	engine.s_point_size = n;
	engine.s_point_index = i;
}

static int devcntl()
{
	register char	c;
	register int	i;
	char		comment[256];
	char		fontname[256];

	while (isspace(c = getchar()))
		;
	switch (c)
	{
	case 'i':			/* initialize */
		nextword();
		(void)sprintf(comment, "Generated by %s from ditroff output for %s at resolution %d",
			prog_name, engine.s_ts_name, engine.s_resolution);
		if (!readfontdir())
			fatal("Can't read DESC file\n");
		pre(NUM, DEN, mag, comment);
		break;
	case 'T':			/* typesetter name */
		nextword();
		getstring(engine.s_ts_name, sizeof(engine.s_ts_name));
		break;
	case 'r':			/* resolution */
		nextword();
		engine.s_resolution = getnum();
		if (engine.s_resolution <= 0)
			fatal("Resolution should be positve, is %d\n",
				engine.s_resolution);
		scale = 72 * (1<<16) / engine.s_resolution;
		engine.s_horizontal = getnum();
		engine.s_vertical = getnum();
		break;
	case 'p':			/* pause */
		break;
	case 's':			/* stop */
		nextword();
		postamble();
		return(1);
	case 't':			/* trailer */
		nextword();
		break;
	case 'f':			/* associate font with number */
		nextword();
		i = getnum();
		nextword();
		getstring(fontname, sizeof(fontname));
		fontposition(i, fontname);
		break;
	case 'H':			/* set character height */
		break;
	case 'S':			/* set slant */
		break;
	default:
		fatal("Unknown device control %c\n", c);
		break;
	}
	return (0);
}

static graphics()
/*
**	Conversion to tpic output left as an exercise for hacker.
**	Should generate xxx commands in DVI.
*/
{
	register char	c;
	register int	p1, p2, p3;

	switch (c = getchar())
	{
	case 'l':
		break;
	case 'c':
		break;
	case 'e':
		break;
	case 'a':
		break;
	case '~':
		break;
	default:
		fatal("Unknown drawing function %c\n", c);
		break;
	}
	/* eat up the rest of the line */
	while (getchar() != '\n')
		;
}

reader()
/*
**	Switch to appropriate routine depending on character read in
*/
{
	register int	c;

	while ((c = getchar()) != EOF)
	{
#ifdef	DEBUG_INPUT
		(void)fprintf(stderr, "%c", c);
#endif	DEBUG_INPUT
/*
**	The code generated by pcc for switch statements is sufficiently
**	inefficient to take out the most common cases. (Loop to match, gag!)
*/
		if (c == 'h')
		/* this is used often enough to justify making it inline
		instead of calling getnum */
		{
			register int	hmotion;

			for (hmotion = 0; isdigit(c = getchar()); )
				hmotion = hmotion * 10 + c - '0';
			(void)ungetc(c, stdin);
			hmove(hmotion);
		}
		else if (c == 'c')
			outchar(getchar());
		else if (isdigit(c))
		{
			register int	hmotion;
			register char	c1;

			if (!isdigit(c1 = getchar()))
			{
				fatal("Non-digit in nn\n");
				return;
			}
			hmotion = (c - '0') * 10 + c1 - '0';
			hmove(hmotion);
			outchar(getchar());
		}
		/* for the less common cases we can afford some inefficiency */
		else switch (c)
		{
		case 'H':
			hgoto(getnum());
			break;
		case 'v':
			vmove(getnum());
			break;
		case 'V':
			vgoto(getint());
			break;
		case 'C':
			specialchar();
			break;
		case 's':
			setfontsize(getnum());
			fontchanged = 1;
			break;
		case 'f':
			engine.s_font_num = getnum();
			engine.s_font_name = fonts[engine.s_font_num].font_name;
			fontchanged = 1;
			break;
		case 'p':
			newpage(getnum());
			break;
		case 'n':
			(void)getnum();		/* no action required */
			(void)getnum();
			break;
		case 'w':
			break;			/* no action required */
		case 'x':
			if (devcntl())		/* stop? */
				return;
			break;
		case 'D':
			graphics();
			break;
		case '\0':			/* discard whitespace and noise */
		case ' ':
		case '\n':
			break;
		default:
			fatal("Unrecognized ditroff command: %c\n", c);
			break;
		}
	}
}
