#include	<stdio.h>
#include	"ditdvi.h"

/*
**	Routines to read ditroff DESC file.
*/

tdev	dev;
int	halfwidth;
short	*pstab;
lookup	*specialtab;
fontdes	fonts[NFONTS];

static char *smalloc(n)
	int		n;
/*
**	Get memory, or die
*/
{
	register char	*p;
	char		*malloc();

	if ((p = malloc(n)) == NULL)
		fatal("No more memory\n");
	return (p);
}

int readfontdir()
/*
**	Read in the information from the DESC file, storing it in
**	the font info array.
*/
{
	register int	i;
	register char	*filedata, *chname;
	register short	*chtab;
	register FILE	*f;
	char		fname[100];
	char		*sprintf();

	(void)sprintf(fname, "%s/dev%s/DESC.out", FONTDIR, engine.s_ts_name);
	if ((f = fopen(fname, "r")) == NULL)
	{
		perror(fname);
		return (0);
	}
	if (fread((char *)&dev, sizeof(char), sizeof(tdev), f) != sizeof(tdev))
		return (0);
	halfwidth = dev.unitwidth / 2;
	if (dev.nfonts >= NFONTS)
		fatal("Font capacity of %d fonts exceeded, reconfigure\n", NFONTS - 1);
	if (dev.nsizes >= NSIZES)
		fatal("Pointsize capacity of %d sizes exceeded, reconfigure\n", NSIZES);

	for (i = 0; i < NFONTS; ++i)		/* zero descriptors */
	{
		register fontdes	*f;
		register int		j;

		f = &fonts[i];
		f->tfontp = (tfont *)0;
		f->codetab = f->fitab = (uchar *)0;
		for (j = 0; j < NSIZES; ++j)
			f->texfont[j] = -1;	/* initially unloaded */
	}

	filedata = smalloc(dev.filesize);
	if (fread(filedata, sizeof(char), dev.filesize, f) != dev.filesize)
		fatal("Short read on %s\n", fname);
	(void)fclose(f);
	pstab = (short *)filedata;
	filedata += (dev.nsizes + 1) * sizeof(short);
	chtab = (short *)filedata;
	filedata += dev.nchtab * sizeof(short);
	chname = filedata;
	filedata += dev.lchname;
	makespecialtab(dev.nchtab, chname, chtab);
#ifdef	DEBUG_FONTS
	dumptables();
#endif	DEBUG_FONTS
	for (i = 1; i <= dev.nfonts; i++)
	{
		register int		nw;

		fonts[i].tfontp = (tfont *)filedata;
		nw = fonts[i].n_width;
		filedata += sizeof(tfont);
		fonts[i].widtab = (uchar *)filedata;
		filedata += nw;
		fonts[i].kerntab = (uchar *)filedata;
		filedata += nw;
		fonts[i].codetab = (uchar *)filedata;
		filedata += nw;
		fonts[i].fitab = (uchar *)filedata;
		filedata += dev.nchtab + (128 - 32);
	}
#ifdef	DEBUG_FONTS
	dumpfonts();
#endif	DEBUG_FONTS
	return (1);
}

static int speccmp(l1, l2)
	lookup		*l1, *l2;
{
	return (strcmp(l1->chname, l2->chname));
}

makespecialtab(nspecials, strings, offsets)
	int		nspecials;
	char		*strings;
	short		offsets[];
{
	register int	i;

	specialtab = (lookup *)smalloc(nspecials * sizeof(lookup));
	for (i = 0; i < nspecials; ++i)
	{
		specialtab[i].ordinal = i;
		specialtab[i].chname = strings + offsets[i];
	}
	qsort((char *)specialtab, nspecials, sizeof(lookup), speccmp);
#ifdef	DEBUG_FONTS
	for (i = 0; i < nspecials; ++i)
		printf("%s %d\n", specialtab[i].chname, specialtab[i].ordinal);
#endif	DEBUG_FONTS
}

#ifdef	DEBUG_FONTS
static dumptables()
/*
**	Print font size tables
*/
{
	register int		i;

	printf("Point size table\n");
	for (i = 0; i <= dev.nsizes; ++i)
	{
		printf("%3d", pstab[i]);
		if (i % 20 == 19)
			putchar('\n');
		else
			putchar(' ');
	}
	putchar('\n');
	printf("Special chars\n");
	for (i = 0; i < dev.nchtab; ++i)
	{
		printf("%s", &chname[chtab[i]]);
		if (i % 20 == 19)
			putchar('\n');
		else
			putchar(' ');
	}
	putchar('\n');
}

static dumpfonts()
/*
**	Print out a human readable representation of fonts for
**	debugging purposes.
*/
{
	register int		i;

	for (i = 1; i < NFONTS; ++i)
	{
		if (fonts[i].tfontp != NULL)
			dumponefont(i);
	}
}

static dumponefont(n)
	int			n;
/*
**	Say all we know about this font
*/
{
	register tfont		*tf;
	register uchar		*t;
	register int		i, nw;

	tf = fonts[n].tfontp;
	printf("%s (%s), %d entries,%s%s\n",
		tf->namefont, tf->intname, (int)tf->nwfont,
		tf->specfont ? " special" : " ",
		tf->ligfont ? " ligatures" : " ");
	nw = tf->nwfont;
	t = fonts[n].widtab;
	printf("Width table\n");
	for (i = 0; i < nw; ++i)
	{
		printf("%3d", t[i]);
		if (i % 20 == 19)
			putchar('\n');
		else
			putchar(' ');
	}
	putchar('\n');
	t = fonts[n].codetab;
	printf("Code table\n");
	for (i = 0; i < nw; ++i)
	{
		printf("%3d", t[i]);
		if (i % 20 == 19)
			putchar('\n');
		else
			putchar(' ');
	}
	putchar('\n');
	t = fonts[n].fitab;
	printf("Font index table\n");
	for (i = 0; i < dev.nchtab; ++i)
	{
		printf("%3d", t[i]);
		if (i % 20 == 19)
			putchar('\n');
		else
			putchar(' ');
	}
	putchar('\n');
}
#endif	DEBUG_FONTS
