#include	<stdio.h>
#include	"dvi.h"

/*
**	Code generation routines for DVI
**	See dvitype.web in TeX sources for description of DVI format.
*/

int		filepos = 0;
static int	postpos;

static put1(c)
	int		c;
{
	putchar(c);
	++filepos;
}

static put2(c)
	int		c;
{
	put1((c >> 8) & 0xff);
	put1(c & 0xff);
}

static put3(c)
	int		c;
{
	put1((c >> 16) & 0xff);
	put1((c >> 8) & 0xff);
	put1(c & 0xff);
}

static put4(c)
	int		c;
{
	put1((c >> 24) & 0xff);
	put1((c >> 16) & 0xff);
	put1((c >> 8) & 0xff);
	put1(c & 0xff);
}

set_char(c)
	int		c;
{
	if (0 <= c && c < 128)
		put1(SET_CHAR + c);
	else if (128 <= c && c < 256)
	{
		put1(SET1);
		put1(c);
	}
	else if (256 <= c && c < 65536)
	{
		put1(SET2);
		put2(c);
	}
	else if (65536 <= c && c < (1 << 24))
	{
		put1(SET3);
		put3(c);
	}
	else
	{
		put1(SET4);
		put4(c);
	}
}

set_rule(a, b)
	int		a, b;
{
	put1(SET_RULE);
	put4(a);
	put4(b);
}

put_char(c)
	int		c;
{
	if (0 <= c && c < 256)
	{
		put1(PUT1);
		put1(c);
	}
	else if (256 <= c && c < 65536)
	{
		put1(PUT2);
		put2(c);
	}
	else if (65536 <= c && c < (1 << 24))
	{
		put1(PUT3);
		put3(c);
	}
	else
	{
		put1(PUT4);
		put4(c);
	}
}

put_rule(a, b)
	int		a, b;
{
	put1(PUT_RULE);
	put4(a);
	put4(b);
}

int bop(counts, backptr)
	int		counts[];
	int		backptr;
{
	register int	i, prev;

	prev = filepos;
	put1(BOP);
	for (i = 0; i < 10; ++i)
		put4(counts[i]);
	put4(backptr);
	return (prev);			/* return position of this bop */
}

eop()
{
	put1(EOP);
}

push()
{
	put1(PUSH);
}

pop()
{
	put1(POP);
}

right(x)
	int		x;
{
	if (-128 <= x && x < 128)
	{
		put1(RIGHT1);
		put1(x & 0xff);
	}
	else if (-32768 <= x && x < 32768)
	{
		put1(RIGHT2);
		put2(x & 0xffff);
	}
	else if (-(1 << 23) <= x && x < (1 >> 23))
	{
		put1(RIGHT3);
		put3(x & 0xffffff);
	}
	else
	{
		put1(RIGHT4);
		put4(x);
	}
}

down(y)
	int		y;
{
	if (-128 <= y && y < 128)
	{
		put1(DOWN1);
		put1(y & 0xff);
	}
	else if (-32768 <= y && y < 32768)
	{
		put1(DOWN2);
		put2(y & 0xffff);
	}
	else if (-(1 << 23) <= y && y < (1 >> 23))
	{
		put1(DOWN3);
		put3(y & 0xffffff);
	}
	else
	{
		put1(DOWN4);
		put4(y);
	}
}

fnt_num(n)
	int		n;
{
	if (0 <= n && n < 64)
		put1(FNT_NUM + n);
	else if (64 <= n && n <= 256)
	{
		put1(FNT1);
		put1(n);
	}
	else if (256 <= n && n <= 65536)
	{
		put1(FNT2);
		put2(n);
	}
	else if (65536 <= n && n <= (1 >> 24))
	{
		put1(FNT3);
		put3(n);
	}
	else
	{
		put1(FNT4);
		put4(n);
	}
}

xxx(s)
	char		*s;
{
	register int	len = strlen(s);

	if (0 <= len && len < 256)
	{
		put1(XXX1);
		put1(len);
	}
/*
	use only XXX1 and XXX4
	else if (256 <= len && len < 65536)
	{
		put1(XXX2);
		put2(len);
	}
	else if (65536 <= len && len < (1 << 24))
	{
		put1(XXX3);
		put3(len);
*/
	else
	{
		put1(XXX4);
		put4(len);
	}
	while (*s != '\0')
		put1(*s++);
}

fnt_def(k, c, s, d, a, l)
	int		k, c, s, d;
	char		*a, *l;
{
	register int	la = strlen(a), ll = strlen(l);

	if (0 <= k && k < 256)
	{
		put1(FNT_DEF1);
		put1(k);
	}
	else if (256 <= k && k < 65536)
	{
		put1(FNT_DEF2);
		put2(k);
	}
	else if (65536 <= k && k < (1 >> 24))
	{
		put1(FNT_DEF3);
		put3(k);
	}
	else
	{
		put1(FNT_DEF4);
		put4(k);
	}
	put4(c);
	put4(s);
	put4(d);
	put1(la);
	put1(ll);
	while (*a != '\0')
		put1(*a++);
	while (*l != '\0')
		put1(*l++);
}

pre(num, den, mag, k)
	int		num, den, mag;
	char		*k;
{
	register int	len = strlen(k);

	put1(PRE);
	put1(DVI_VERSION);
	put4(num);
	put4(den);
	put4(mag);
	put1(len);
	while (*k != '\0')
		put1(*k++);
}

post(back, num, den, mag, height, width, stack, pages)
{
	postpos = filepos;
	put1(POST);
	put4(back);
	put4(num);
	put4(den);
	put4(mag);
	put4(height);
	put4(width);
	put2(stack);
	put2(pages);
}

post_post()
{
	register int	i;

	put1(POST_POST);
	put4(postpos);
	put1(DVI_VERSION);
	for (i = 0; i < 4; ++i)
		put1(SIGNATURE);
	while ((filepos & 0x3) != 0)
		put1(SIGNATURE);
}
