/*
 *	ftbl -- font table management routines
 *  Copyright (C) 1990 Vassilis Prevelakis
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation and included with this distribution in the
 *  file named LICENSE.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Bugs fixes, comments etc. to:
 *       Vasilis Prevelakis
 *       Centre Universitaire d'Informatique (CUI)
 *       12 Rue du Lac, Geneva, Switzerland CH-1207
 *  email: vp@cui.unige.ch
 *  uucp:  ...!mcsun!cui!vp
 */

#include <stdio.h>

#define FT_SIZE 16

static FILE* fd;

static struct ft_ent {
	short fid;
	char name[256];
} ft_tbl[FT_SIZE];
static char fname[256];
static int nextent;

ft_init(fontdir)
char* fontdir;
{
	char buf[256];
	int c, i, ent;
	char *vp;
	int fid;

	/* initialize table */
	for (ent=0; ent<FT_SIZE; ent++)
		ft_tbl[ent].fid = -1;
	nextent = 0;
		
	sprintf(fname, "%s/font.tbl", fontdir);
	if ((fd = fopen(fname, "rt")) == NULL)
	{
		fprintf(stderr,
			"Couldn't open cache file: %s, ignored\n", fname);
		return;
	}

	/* load table */
	for (ent=0; ent<FT_SIZE; ent++)
	{
		if (fscanf(fd, "%d: %s", &fid, buf) != 2)
			break;
		ft_tbl[ent].fid = fid;
		strcpy(ft_tbl[ent].name, buf);
	}
	fclose(fd);
}

short ft_getnextent()
{
	return(ft_tbl[nextent++].fid);
}

char* ft_getname(fid)
short fid;
{
	int i;

	for (i=0; i < FT_SIZE; i++)
		if (ft_tbl[i].fid == fid)
			return(ft_tbl[i].name);
	return(NULL);
}

int ft_isthere(fid)
short fid;
{
	int i;

	for (i=0; i < FT_SIZE; i++)
		if (ft_tbl[i].fid == fid)
			return(1);
	return(0);
}

ft_delent(fid)
short fid;
{
	int i;

	for (i=0; i < FT_SIZE; i++)
		if (ft_tbl[i].fid == fid)
			ft_tbl[i].fid = -1;
}

int ft_addent(fid, s)
short fid;
char* s;
{
	int i;

	for (i=0; i < FT_SIZE; i++)
		if (ft_tbl[i].fid < 0)
		{
			ft_tbl[i].fid = fid;
			strcpy(ft_tbl[i].name, s);
			return(i);
		}
	return(0);
}

ft_close()
{
	int i;

	unlink(fname);
	if ((fd = fopen(fname, "wt")) == NULL)
	{
		fprintf(stderr, "Couldn't open font cache file: %s\n", fname);
		exit(1);
	}
	
	for (i=0; i < FT_SIZE; i++)
		if (ft_tbl[i].fid > 0)
			fprintf(fd, "%d: %s\n", ft_tbl[i].fid, ft_tbl[i].name);
	fclose(fd);
}


