/*
 *  djinfo.c -- prints information contained in an HP DeskJet soft font file.
 *  Copyright (C) 1990 Vassilis Prevelakis
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation and included with this distribution in the
 *  file named LICENSE.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Bugs fixes, comments etc. to:
 *       Vasilis Prevelakis
 *       Centre Universitaire d'Informatique (CUI)
 *       12 Rue du Lac, Geneva, Switzerland CH-1207
 *  email: vp@cui.unige.ch
 *  uucp:  ...!mcsun!cui!vp
 */

#include <stdio.h>

typedef unsigned char u_char;
typedef unsigned short u_short;

FILE* fd;

struct fdb {
	u_short	size;		/* always 72 */
	u_char	format;		/* DeskJet only: header format (5 or 9) */
	u_char	ftype;		/* zero for 7-bit font */
	short	xxx1;		/* RESERVED, must be zero */
	u_short	baseline;	/* in dots */
	u_short cell_width;	/* in dots */
	u_short cell_height;	/* in dots */
	u_char orientation;	/* 0 portrait, 1 landscape */
	u_char spacing;		/* 0 fixed, 1 proportional */
	u_short symbol;
	u_short pitch;		/* in quarter dots */
	u_short height;		/* in quarter dots */
	u_short xHeight;	/* in quarter dots -- IGNORED */
	u_char w_type;		/* IGNORED, == 0 */
	u_char style;
	char str_weight;
	u_char typeface;
	u_char	slant;		/* DeskJet only */
	u_char s_style;
	u_char quality;		/* DeskJet only */
	u_char placement;	/* DeskJet only */
	char ud_dst;
	u_char ud_height;	/* IGNORED, == 3 */
	u_short	t_height;	/* IGNORED, == 0 */
	u_short t_width;	/* IGNORED, == 0 */
	u_short firstcode;	/* DeskJet only */
	u_short lastcode; 	/* DeskJet only */
	u_char ext_pitch;	/* IGNORED by DeskJet == 0 */
	u_char ext_height;	/* IGNORED by DeskJet == 0 */
	short xxx5[3];		/* RESERVED, must be zero */
#define MAXNAME 16
	char fname[MAXNAME];
	/* following fields DeskJet only */
	u_short hres;		/* horizontal resolution == 600 */
	u_short vres;		/* vertical resolution == 300 */
	char ud2_dst;
	u_char ud2_height;
	char bud_dst;
	u_char bud_height;
	u_short psbs;		/* number of subsequent bytes == 20 */
	u_short font_size;
	char oneway;
	char compressed;
	u_char holdtime;
	char nohalfpitch;
	char nodoublepitch;
	char nohalfheight;
	char nobold;
	char nodraft;
	char boldmethod;
	char xxx7;		/* RESERVED, must be zero */
	u_short baseoff2;
/* following fields used by DeskJet PLUS **ONLY** */
	u_short baseoff3;
	u_short baseoff4;
} myfdb;

void loc_char(cc)
char cc;
{
	int c;

	while ((c = getc(fd)) != cc)
		if (c < 0)
			exit(0);
}
	
main(argc, argv)
int argc;
char **argv;
{
	int c;
	int i;
	struct fdb myfdb;
	u_char *vp;

	if (argc != 2)
	{
		printf("usage: xx filename\n");
		exit(1);
	}

	if ((fd = fopen(argv[1], "rb")) == NULL)
	{
		printf("Couldn't open %s.\n", argv[1]);
		exit(1);
	}
	do {
		do {
			loc_char(0x1b);
		} while (getc(fd) != ')');
	} while (getc(fd) != 's');
	loc_char('W');
	/* printf("now at %ld\n", ftell(fd)); */
	fread(&myfdb, sizeof(struct fdb), 1, fd);

#define vp_swab(X) ((((u_short)X & 0xff) << 8) | (((u_short)X & 0xff00) >> 8))
	myfdb.size = vp_swab(myfdb.size);
	myfdb.baseline = vp_swab(myfdb.baseline);
	myfdb.cell_width = vp_swab(myfdb.cell_width);
	myfdb.cell_height = vp_swab(myfdb.cell_height);
	myfdb.symbol = vp_swab(myfdb.symbol);
	myfdb.pitch = vp_swab(myfdb.pitch);
	myfdb.height = vp_swab(myfdb.height);
	myfdb.xHeight = vp_swab(myfdb.xHeight);
	myfdb.t_height = vp_swab(myfdb.t_height);
	myfdb.t_width = vp_swab(myfdb.t_width);
	myfdb.firstcode = vp_swab(myfdb.firstcode);
	myfdb.lastcode = vp_swab(myfdb.lastcode);
	myfdb.hres = vp_swab(myfdb.hres);
	myfdb.vres = vp_swab(myfdb.vres);
	myfdb.psbs = vp_swab(myfdb.psbs);
	myfdb.font_size = vp_swab(myfdb.font_size);
	myfdb.baseoff2 = vp_swab(myfdb.baseoff2);
	myfdb.baseoff3 = vp_swab(myfdb.baseoff3);
	myfdb.baseoff4 = vp_swab(myfdb.baseoff4);
	
	myfdb.fname[MAXNAME-1] = '\0';
printf("Font name: %s.\n", myfdb.fname);
printf("size=%d, format=%d, ftype=%d, baseline=%d, width=%d, height=%d\n",
	(int)myfdb.size, (int)myfdb.format, (int)myfdb.ftype,
	(int)myfdb.baseline,
	(int)myfdb.cell_width, (int)myfdb.cell_height);

printf("orien=%d, spacing=%d, pitch=%d, height=%d, xHeight=%d, w_type=%d\n",
	(int)myfdb.orientation, (int)myfdb.spacing, (int)myfdb.pitch,
	(int)myfdb.height,
	(int)myfdb.xHeight, (int)myfdb.w_type);

printf("style=%d, str_weight=%d, typeface=%d, slant=%d, s_style=%d\n",
	(int)myfdb.style, (int)myfdb.str_weight,(int)myfdb.typeface,
	(int)myfdb.slant, (int)myfdb.s_style);

printf("quality=%d, placement=%d, t_height=%d, t_width=%d, Fcode=%d, Lcode=%d\n",
	(int)myfdb.quality, (int)myfdb.placement, (int)myfdb.t_height,
	(int)myfdb.t_width,
	(int)myfdb.firstcode, (int)myfdb.lastcode);

printf("hres=%d, vres=%d, psbs=%d, size=%u\n",
	(int)myfdb.hres, (int)myfdb.vres,
	(int)myfdb.psbs, (unsigned int)myfdb.font_size);

printf("baseoff2=%d, baseoff3=%d, baseoff4=%d\n",  
	(int)myfdb.baseoff2, (int)myfdb.baseoff3, (int)myfdb.baseoff4);
}
	

