/*****************************************************************
 *
 *   Copyright 1985. Chris Lewis
 *
 *   Module          : lcat.c 1.5
 *   Date submitted  : 86/01/21 13:23:21
 *   Author          : Chris Lewis
 *   Origin          : Permission to copy and further distribute is 
 * 		       freely given provided this copyright notice remains 
 *		       intact and that this software is not sold for profit.
 *   Description     : Driver for troff WANG/CAT to HP laserjet filter.
 *
 *   Modifications (by vp@cui.unige.ch):
 *
 *	- modications for compatibility with BSD vfonts
 *	- modifications for porting to MS-LOSS
 *	- converted to use soft fonts instead of graphics mode
 *	- removed multiple resolutions option since with soft fonts
 *	  you don't get to chose.
 *
******************************************************************/

#ifndef lint
static char SrcId[] = "@(#)lcat.c:1.5";
#endif

#include <stdio.h>
#include <ctype.h>
#include <string.h>
extern void terminate();

#define	ESC	0x80
#define	FLASH	0x00
#define	CONTROL	0x40
#define	LEAD	0x60
#define	SIZE	0x50

#define	DOWN	0
#define	UP	1
#define	LOWER	2
#define	UPPER	3
#define	FORWARD	4
#define	BACKWARD 5

#ifdef UNIX
FILE	*inFile = stdin;
FILE	*outFile = stdout;
#else
FILE	*inFile = (FILE *) NULL;
FILE	*outFile = (FILE *) NULL;
#endif
FILE	*diagFile = (FILE *) NULL;
#define	DEBUGPRINTF	if (diagFile) fprintf


/*
 * note: the BSD4.3 vfonts are really too big at 75 dpi, so we have to
 * always print them at a higher resolution (in this case 300 dpi).
 *
 * Unfortunately at this resolution they are too small, so for a given
 * pointsize request we have to select a larger pointsize.
 *
 * We try to select the one closest to the requested size plus 4 points.
 */
#ifdef ORIG
char ptab[16] = { 7, 8, 10, 11, 12, 14, 18, 9, 6, 16, 20, 22, 24, 28, 36, 72};
char ptab[16] = { 10, 12, 14, 14, 16, 22, 22, 12, 10, 22, 24, 24, 28, 28, 36, 72 };
#else
char ptab[16] = { 11, 12, 16, 16, 18, 22, 28, 14, 9, 24, 28, 36, 36, 36, 36, 36};
#endif
int	points;
int	vertChanged = 0;
int	quality	= 1;
int lcat;


/*	Scale factors:
		(td/ld) * (lu / tu)
		Where:
			td: troff dimension in inches
			ld: laserjet dimension in inches
			lu: laserjet precision/inch
			tu: troff precision/inch

		td = 6.5 (width), 11 (length)
		tu = 432
		ld = 6.5 (width), 10 (length)
		lu = 720
*/

#define	XSF	1.6666666	/* X Scale factor (troff to laserjet units) */
#define	YSF	1.5151515	/* Y Scale factor (troff to laserjet units) */

long	xpos, oldypos = -9999, ypos = -153;

char *words[] = {
	"down", "up", "lower", "upper", "forward", "backwards"
	};

static char	fontFamily[BUFSIZ];
static char	djfontFamily[BUFSIZ];
char	*fontName;
#ifdef UNIX
char	*fontLib = "/usr1/tmp/vfonts/";
#else
char	*fontLib = "/usr/vfonts/";
#endif

#define	CTOINT(val,sig)	((~c)&sig)

#define	UNITS	432
#define	FONT4		/* 4 Font device */

/*
 * calcfont -- calculate new font depending on the rail, mag and tilt options
 */
#ifdef	FONT4
#define	calcfont	((mag == UPPER)<<1)|((rail == UPPER))
#else
#define	calcfont	((mag == UPPER)<<2)|((rail == UPPER)<<1)|(tilt==DOWN)
#endif

main(argc, argv)
int	argc;
char	**argv; {
	register int nc, c;
	register char *rp;
	register int i,j;
	register int decipoints;
	register int units;
	register int font, rail, mag, tilt, half, escape, lead;
	char* ofile;
	char* infile;

	lead=half=rail=mag=tilt=font=0;
	
#ifdef UNIX
	/* under UNIX default input and output files are the
	 * standard input and output respectively.
	 * Under MS-LOSS we have to use explicit files because of I/O
	 * redirection probs.
	 */
	infile = NULL;
	ofile = NULL;
	fontName = "times.";
#else
	infile = "/tmp/out";
	ofile = "prn:";
	/* under MSLOSS (the system that likes to say no)
	   filenames can only have one dot, so we use a '-' instead */
	fontName = "times-";
#endif
	quality = 1;
	lcat = (argv[0][strlen(argv[0])-4] == 'l');
	argv++;
	argc--;
	if (argc > 0)	/* process parameters */
	{
		while (argc > 0 && **argv == '-')
		{
			switch (*(*argv+1)) {
			case 'D':	/* diagnostic output */
				diagFile = fopen("diag.txt", "w");
				if (!diagFile)
				{
					fprintf(stderr, "Could not open diagnostics file\n");
					exit(1);
				}
				argv++;
				argc--;
				break;
			case 'f':	/* select different font family */
				fontName = *++argv;
				argv++;
				argc -= 2;
				break;
			case 'O':	/* specify output file */
				ofile = *++argv;
				argv++;
				argc -= 2;
				break;
			case 'l':	/* select low (draft) quality */
				/* this option is valid ONLY for the lcat version */
				quality = 2;
				argv++;
				argc -= 1;
				if (lcat)
					break;
				/* otherwise fall through to the error code */
			default:
				usage();
				exit(1);
			}
		}
		if (argc > 0)
		{
			infile = *argv;
			argv++;
			argc--;
		}
	}
	

	/* if not absolute path, prepend vfont directory path */
#ifdef UNIX
	if (fontName[0] == '/' || fontName[1] == ':')
		sprintf(fontFamily, "%s", fontName);
	else
		sprintf(fontFamily, "%s%s", fontLib, fontName);
#else
	if (fontName[0] == '/' || fontName[1] == ':')
	{
		char *vp;
		sprintf(fontFamily, "%s", fontName);
		/* isolate path to font directory */
		vp = strrchr(fontName, '/');
		*vp = '\0';
		sprintf(djfontFamily, "%s/djfonts", fontName);
		ft_init(djfontFamily);
		sprintf(djfontFamily, "%s/djfonts/%s", fontName, vp+1);
	} else {
		sprintf(fontFamily, "%s%s", fontLib, fontName);
		sprintf(djfontFamily, "%sdjfonts", fontLib);
		ft_init(djfontFamily);
		sprintf(djfontFamily, "%sdjfonts/%s", fontLib, fontName);
	}
#endif

	DEBUGPRINTF(diagFile, "font family: %s\n", fontFamily);
	if (ofile != NULL)
		if ((outFile = fopen(ofile, "wb")) == NULL)
		{
			fprintf(stderr, "Couldn't open output file %s\n", ofile);
			exit(1);
		}
	if (infile != NULL)
		if ((inFile = fopen(infile, "rb")) == NULL)
		{
			fprintf(stderr,
				"Couldn't open input file %s\n", infile);
			exit(1);
		}
	vf_init(quality, fontFamily, djfontFamily);
	while (!feof(inFile)) {
		c = getc(inFile);
		switch(c) {
		case 0x00:
			DEBUGPRINTF(diagFile, "NOP\n");
			break;
		/* Flash (print character) codes */
		case 0x01: case 0x02: case 0x03: case 0x04: 
		case 0x05: case 0x06: case 0x07: case 0x08: 
		case 0x09: case 0x0a: case 0x0b: case 0x0c: 
		case 0x0d: case 0x0e: case 0x0f: case 0x10: 
		case 0x11: case 0x12: case 0x13: case 0x14:
		case 0x15: case 0x16: case 0x17: case 0x18: 
		case 0x19: case 0x1a: case 0x1b: case 0x1c: 
		case 0x1d: case 0x1e: case 0x1f: case 0x20: 
		case 0x21: case 0x22: case 0x23: case 0x24: 
		case 0x25: case 0x26: case 0x27: case 0x28:
		case 0x29: case 0x2a: case 0x2b: case 0x2c: 
		case 0x2d: case 0x2e: case 0x2f: case 0x30: 
		case 0x31: case 0x32: case 0x33: case 0x34: 
		case 0x35: case 0x36: case 0x37: case 0x38: 
		case 0x39: case 0x3a: case 0x3b: case 0x3c:
		case 0x3d: case 0x3e: case 0x3f:
			/* This is terribly kludgey:
				In 432 units per inch, 4752 is 11 inches.
				When we go beyond this, we subtract 4752
				and ignore anything printed on this line.
			*/
			while (ypos >= 4752) {
				ypos -= 4752;
				oldypos = -9999;
				DEBUGPRINTF(diagFile, "Page break\n", 0, 0);
				vf_newpage();
			}
			if (ypos <= 20) {
				DEBUGPRINTF(diagFile, "Ignoring: %d, %d\n", xpos, ypos);
				break; /* ignore anything less than this
					from the beginning of a page */
			}
			c &= 0x3f;
			DEBUGPRINTF(diagFile, "Flash %02d %s font %d\n", c&0x3f, 
				words[half], font);
/*
printf("font(%d)=%s,rail(%d)=%s,mag(%d)=%s,tilt(%d)=%s,half(%d)=%s\n",
	font, words[font], rail, words[rail], mag, words[mag],
	tilt, words[tilt], half, words[half]);
*/
			DEBUGPRINTF(diagFile, "x,y=%ld,%ld; font=%d; rail=%s; mag=%s; tilt=%s; half=%s\n",
				xpos,ypos,font+1,words[rail],words[mag],words[tilt],
				words[half]);
			/*	Find the C/A/T code */
			if (half == UPPER) {
				if (c > 46) {
					fprintf(stderr, "Illegal upper flash: %d\n", c);
					terminate(1);
				}
				nc = c + 62;
			} else
				nc = c - 1;

			/*
			 * the new version of flashrast needs to know
			 * where the letter will be placed.  Thus we
			 * call a routine in newfonts.c that can then save
			 * these numbers.
			 */
			vf_move((long) (xpos*XSF), (long) (ypos*YSF));
			oldypos = ypos;
			vertChanged = 0;
			flashrast(nc, points, font);
			vertChanged = 1;
			break;
		/* Control codes */
		case 0x40:
			DEBUGPRINTF(diagFile, "Initialize\n");
			xpos = 0;
			ypos = -153;
			escape = FORWARD;
			lead = FORWARD;
			half = LOWER;
			rail = LOWER;
			mag = LOWER;
			tilt = DOWN;
			font = calcfont;
			break;
		case 0x41:
			DEBUGPRINTF(diagFile, "Rail lower\n");
			rail = LOWER;
			font = calcfont;
			break;
		case 0x42:
			DEBUGPRINTF(diagFile, "Rail upper\n");
			rail = UPPER;
			font = calcfont;
			break;
		case 0x43:
			DEBUGPRINTF(diagFile, "Mag upper\n");
			mag = UPPER;
			font = calcfont;
			break;
		case 0x44:
			DEBUGPRINTF(diagFile, "Mag lower\n");
			mag = LOWER;
			font = calcfont;
			break;
		case 0x45:
			DEBUGPRINTF(diagFile, "half lower\n");
			half = LOWER;
			break;
		case 0x46:
			DEBUGPRINTF(diagFile, "half upper\n");
			half = UPPER;
			break;
		case 0x47:
			DEBUGPRINTF(diagFile, "Escape forward\n");
			escape = FORWARD;
			break;
		case 0x48:
			DEBUGPRINTF(diagFile, "Escape backward\n");
			escape = BACKWARD;
			break;
		case 0x49:
			DEBUGPRINTF(diagFile, "STOP\n");
			break;
		case 0x4a:
			DEBUGPRINTF(diagFile, "Lead forward\n");
			lead = FORWARD;
			break;
		case 0x4b:
			DEBUGPRINTF(diagFile, "Software cut!\n");
			break;
		case 0x4c:
			DEBUGPRINTF(diagFile, "Lead backward\n");
			lead = BACKWARD;
			break;
		case 0x4d:
			DEBUGPRINTF(diagFile, "UNKNOWN CONTROL CODE!\n");
			terminate(0);
		case 0x4e:
			DEBUGPRINTF(diagFile, "Tilt up\n");
			tilt = UP;
			font = calcfont;
			break;
		case 0x4f:
			DEBUGPRINTF(diagFile, "Tilt down\n");
			tilt = DOWN;
			font = calcfont;
			break;

		/* Size changes */
		case 0x50: case 0x51: case 0x52: case 0x53:
		case 0x54: case 0x55: case 0x56: case 0x57:
		case 0x58: case 0x59: case 0x5a: case 0x5b:
		case 0x5c: case 0x5d: case 0x5e: case 0x5f:
			DEBUGPRINTF(diagFile, "Size change %02x\n", c&0xf);
			points = ptab[c&0xf];
			break;
		/* Lead (vertical motion) codes */
		case 0x60: case 0x61: case 0x62: case 0x63:
		case 0x64: case 0x65: case 0x66: case 0x67:
		case 0x68: case 0x69: case 0x6a: case 0x6b:
		case 0x6c: case 0x6d: case 0x6e: case 0x6f:
		case 0x70: case 0x71: case 0x72: case 0x73:
		case 0x74: case 0x75: case 0x76: case 0x77:
		case 0x78: case 0x79: case 0x7a: case 0x7b:
		case 0x7c: case 0x7d: case 0x7e: case 0x7f:

			DEBUGPRINTF(diagFile, "Lead(vertical) %02x\n", c&0x1f);
			units = CTOINT(c,0x1f);
			if (lead == FORWARD) {
				ypos += 3*units;
			} else {
				ypos -= 3*units;
			}
			break;
		/* Escape (horizontal motion) codes */
		case 0x80: case 0x81: case 0x82: case 0x83:
		case 0x84: case 0x85: case 0x86: case 0x87:
		case 0x88: case 0x89: case 0x8a: case 0x8b:
		case 0x8c: case 0x8d: case 0x8e: case 0x8f:
		case 0x90: case 0x91: case 0x92: case 0x93:
		case 0x94: case 0x95: case 0x96: case 0x97:
		case 0x98: case 0x99: case 0x9a: case 0x9b:
		case 0x9c: case 0x9d: case 0x9e: case 0x9f:
		case 0xa0: case 0xa1: case 0xa2: case 0xa3:
		case 0xa4: case 0xa5: case 0xa6: case 0xa7:
		case 0xa8: case 0xa9: case 0xaa: case 0xab:
		case 0xac: case 0xad: case 0xae: case 0xaf:
		case 0xb0: case 0xb1: case 0xb2: case 0xb3:
		case 0xb4: case 0xb5: case 0xb6: case 0xb7:
		case 0xb8: case 0xb9: case 0xba: case 0xbb:
		case 0xbc: case 0xbd: case 0xbe: case 0xbf:
		case 0xc0: case 0xc1: case 0xc2: case 0xc3:
		case 0xc4: case 0xc5: case 0xc6: case 0xc7:
		case 0xc8: case 0xc9: case 0xca: case 0xcb:
		case 0xcc: case 0xcd: case 0xce: case 0xcf:
		case 0xd0: case 0xd1: case 0xd2: case 0xd3:
		case 0xd4: case 0xd5: case 0xd6: case 0xd7:
		case 0xd8: case 0xd9: case 0xda: case 0xdb:
		case 0xdc: case 0xdd: case 0xde: case 0xdf:
		case 0xe0: case 0xe1: case 0xe2: case 0xe3:
		case 0xe4: case 0xe5: case 0xe6: case 0xe7:
		case 0xe8: case 0xe9: case 0xea: case 0xeb:
		case 0xec: case 0xed: case 0xee: case 0xef:
		case 0xf0: case 0xf1: case 0xf2: case 0xf3:
		case 0xf4: case 0xf5: case 0xf6: case 0xf7:
		case 0xf8: case 0xf9: case 0xfa: case 0xfb:
		case 0xfc: case 0xfd: case 0xfe:

			units = CTOINT(c,0x7f);
			if (escape == FORWARD) {
				xpos += units;
			} else {
				xpos -= units;
			}
			DEBUGPRINTF(diagFile, "ESC (hor): %02x\n", c&0x7f);
			break;

		case 0xff:
			DEBUGPRINTF(diagFile, "Illegal: %02x\n", c);
			break;
		}
	}
	vf_newpage();
	terminate(0);
}

void terminate(xx)
int xx;
{
#ifndef UNIX
	ft_close();
#endif
	exit(xx);
}


usage()
{
	if (lcat)
		fprintf(stderr, "usage: lcat [-f fontname] [-l] [-O file] [file]\n");
	else
		fprintf(stderr, "usage: vcat [-f fontname] [-O file] [file]\n");
}

