/*
 *  bm.c -- byte tranfer routine, used by the lcat program
 *  Copyright (C) 1990 Vassilis Prevelakis
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation and included with this distribution in the
 *  file named LICENSE.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Bugs fixes, comments etc. to:
 *       Vasilis Prevelakis
 *       Centre Universitaire d'Informatique (CUI)
 *       12 Rue du Lac, Geneva, Switzerland CH-1207
 *  email: vp@cui.unige.ch
 *  uucp:  ...!mcsun!cui!vp
 */

#ifndef UNIX
#pragma inline
#endif
#define LCAT
#include "lcat.h"

u_char raster[NLINES][RASTWIDTH];

/*
 * bit_move -- move a number of bytes aligned on a byte boundary
 * to a destination that is defined by a byte address plus
 * a bit offset.
 *
 * Note that we are ORing source with destination because the character
 * cells may have a partial overlap (called overhang in tp jargon).
 *
 * Also the #%$#% CAT is printing in both directions so we cannot
 * sure whether the previous character is to our left or to our right.
 *
 * Anyway we can be sure that when we start a new line the raster
 * is cleared to zeros (the printing routine clears the raster
 * as its sending the bytes to the printer.
 */
bit_move(dst_addr, bit, src_addr, nbytes)

u_char huge* dst_addr, huge* src_addr;
int bit, nbytes;
{
	u_char a, b;
	int i;

	if (bit == 0)
	{
		for(i = 0; i < nbytes; i++)
			*dst_addr++ |= *src_addr++;
		/*	memcpy(dst_addr, src_addr, nbytes);	*/
		return;
	}
	bit = 8-bit;
	/*	*dst_addr &= (0xff << bit);	*/
	for (i = 0; i < nbytes; i++)
	{
#ifdef USE_C
	/*
	 * this is the C version of the assembly code below.
	 * note that I haven't tested this!
	 */
	register unsigned short a;

	a = (*src_addr++) << bit;
	*dst_addr++ |= ((a>>8) & 0xff);
	*dst_addr |= (a & 0xff);
#else
		b = *dst_addr;
		a = *src_addr++;
		_BH = b;
		_AL = a;
		_AH = 0;
		_CL = bit;
		asm shl ax, cl;
		asm or	ah, bh;
		a = _AH;
		b = _AL;
		*dst_addr++ = a;
		*dst_addr |= b;
#endif
	}
}
