#include "th.h"

int xpos, ypos, cx, cy;
int font, cfont, size, csize, tfont, tsize;
char *pstr, *cstr();

main()
{
	int c, i;
	int sflag;
	int hdist, vdist;
	int esc, lead;
	int fh;

	hdist = vdist = 0;
	cfont = csize = -1;
	tfont = font = 0;
	tsize = size = 12;
	esc = lead = 1;
	cy = ypos = 1692;
	cx = xpos = 0;
	sflag = 0;
	prolog();
	newpage();
	while ((c = getchar()) != EOF) {
		font = tfont;
		size = tsize;
		if (c & 0x80)
			hdist += ~c & 0x7f;
		else if ((c & 0xe0) == 0x60)
			vdist += ~c & 0x1f;
		if ((c & 0xc0) == 0) {
			if ((c & 0x3f) != 0) {
				if (hdist || vdist) {
					xpos += esc * hdist;
					ypos -= lead * vdist;
					if (ypos <= 0) {
						endpage();
						newpage();
						while (ypos < 0)
							ypos += 1584;
					}
					hdist = 0;
					vdist = 0;
				}
				sflag = 1;
				if (table[(font % 4) == 3][fh][c & 0x3f] == ' ') {
					if (font % 4 != 3)
						if (fh == 0)
							switch (c & 0x3f) {
							case 18:
								pstr = "\\320";
								break;	/* \(em */
							case 28:
								illegal("1/4");
								break;	/* \(14 */
							case 30:
								illegal("1/2");
								break;	/* \(12 */
							case 38:
								illegal("3/4");
								break;	/* \(34 */
							default:
								fprintf(stderr, ">>>>> L%d/%d\n", font, c & 0x3f);
							}
						else
							switch (c & 0x3f) {
							case 19:
								pstr = "\\320";
								break;	/* \- */
							case 20:
								pstr = "\\256";
								break;	/* fi */
							case 21:
								pstr = "\\257";
								break;	/* fl */
							case 22:
								pstr = "ff";
								break;	/* ff */
							case 23:
								pstr = "\\242";
								break;	/* cent */
							case 24:
								pstr = "f\\257";
								break;	/* ffl */
							case 25:
								pstr = "f\\256";
								break;	/* ffi */
							case 30:
								fontps(3, size, "\\260");
								break;	/* degree */
							case 31:
								pstr = "\\262";
								break;	/* dagger */
							case 33:
								fontps(3, size, "\\322");
								break;	/* reg */
							case 38:
								pstr = "\\267";
								break;	/* bullet */
							case 40:
								fontps(3, size, "\\242");
								break;	/* footmark */
							case 43:
								fontps(3, size, "\\323");
								break;	/* c'right */
							case 44:
								pstr = "\\250";
								break;	/* square ? */
							default:
								fprintf(stderr, ">>>>> U%d/%d\n", font, c & 0x3f);
							}
					else if (fh == 0)
						switch (c & 0x3f) {
						case 18:
							fontps(0, size, "@");
							break;	/* @ */
						case 19:
							pstr = "\\257";
							break;	/* down arrow */
						case 22:
							pstr = cstr('|');
							break;	/* OR */
						case 24:
							fontps(0, size, "\"");
							break;	/* " */
						case 28:
							pstr = "\\254";
							break;	/* <- */
						case 30:
							pstr = "\\255";
							break;	/* up arrow */
						case 33:
							fontps(0, size, "\\\\");
							break;	/* Backslash ! */
						case 35:
							illegal("Bell Logo");
							break;	/* Bell Logo */
						case 36:
							pstr = "\\245";
							break;	/* infinity */
						case 38:
							pstr = "\\312";
							break;	/* impr. super */
						case 39:
							pstr = "\\265";
							break;	/* proportional */
						case 40:
							pstr = "\\336";
							break;	/* right hand */
						case 43:
							pstr = "\\321";
							break;	/* grad */
						case 48:
							pstr = "\\310";
							break;	/* union */
						case 49:
							pstr = "\\140";
							break;	/* sqrtroof */
						case 54:
							pstr = "\\362";
							break;	/* integral */
						case 56:
							pstr = "\\314";
							break;	/* subset */
						case 57:
							pstr = "\\311";
							break;	/* superset */
						case 58:
							pstr = cstr('~');
							break;	/* approximate */
						case 59:
							pstr = "\\256";
							break;	/* partial */
						case 61:
							pstr = "\\326";
							break;	/* sqrt */
						case 63:
							pstr = "\\273";
							break;	/* ~= */
						default:
							fprintf(stderr, ">>>>> L%d/%d\n", font, c & 0x3f);
						}
					else
						switch (c & 0x3f) {
						case 5:
							pstr = "\\307";
							break;	/* intersect */
						case 7:
							pstr = "\\330";
							break;	/* not */
						case 8:
							pstr = "\\371";
							break;	/* righceil, sq */
						case 9:
							pstr = "\\354";
							break;	/* leftop, curly */
						case 10:
							pstr = "\\357";
							break;	/* bold vertical */
						case 11:
							pstr = "\\355";
							break;	/* lefcent, curly */
						case 12:
							pstr = "\\356";
							break;	/* leftbot, curly */
						case 13:
							pstr = "\\374";
							break;	/* rightop, curly */
						case 14:
							pstr = "\\375";
							break;	/* righcen, curly */
						case 15:
							pstr = "\\376";
							break;	/* rightbot, curly */
						case 16:
							pstr = "\\373";
							break;	/* rigfloor, sq */
						case 17:
							pstr = "\\353";
							break;	/* lefloor, sq */
						case 18:
							pstr = "\\351";
							break;	/* leftceil, sq */
						case 19:
							pstr = "\\264";
							break;	/* times */
						case 20:
							pstr = "\\270";
							break;	/* divide */
						case 21:
							pstr = "\\261";
							break;	/* +- */
						case 22:
							pstr = "\\243";
							break;	/* <= */
						case 23:
							pstr = "\\263";
							break;	/* >= */
						case 24:
							pstr = "\\272";
							break;	/* ident. equ */
						case 25:
							pstr = "\\271";
							break;	/* != */
						case 28:
							fontps(0, size, "\\302");
							break;	/* acute */
						case 29:
							fontps(0, size, "\\301");
							break;	/* grave */
						case 30:
							fontps(0, size, "^");
							break;	/* ^ */
						case 32:
							pstr = "\\334";
							break;	/* left hand */
						case 33:
							pstr = "\\316";
							break;	/* Member of */
						case 35:
							pstr = "\\306";
							break;	/* Empty set */
						case 37:
							fontps(0, size, "\\263");
							break;	/* doubdagg */
						case 38:
							pstr = "\\275";
							break;	/* box vertical */
						case 40:
							pstr = "\\315";
							break;	/* impr. subset */
						case 41:
							illegal("circle");
							break;	/* circle */
						case 44:
							pstr = "\\256";
							break;	/* -> */
						case 45:
							fontps(0, size, "\\247");
							break;	/* section */
						default:
							fprintf(stderr, ">>>>> U%d/%d\n", font, c & 0x3f);
						}
				}
				else {
					switch (table[(font % 4) == 3][fh][c & 0x3f]) {
					case '(':
						pstr = "\\(";
						break;
					case ')':
						pstr = "\\)";
						break;
					default:
						pstr = cstr(table[(font % 4) == 3][fh][c & 0x3f]);
						break;
					}
				}
				tprint();
			}
		}
		else if ((c & 0xf0) == 0x50) {
			switch (c & 0x0f) {
			case 0:
				size = 7;
				break;
			case 1:
				size = 8;
				break;
			case 2:
				size = 10;
				break;
			case 3:
				size = 11;
				break;
			case 4:
				size = 12;
				break;
			case 5:
				size = 14;
				break;
			case 6:
				size = 18;
				break;
			case 7:
				size = 9;
				break;
			case 8:
				size = 6;
				break;
			case 9:
				size = 16;
				break;
			case 10:
				size = 20;
				break;
			case 11:
				size = 22;
				break;
			case 12:
				size = 24;
				break;
			case 13:
				size = 28;
				break;
			case 14:
				size = 36;
				break;
			default:
				fprintf(stderr, "Size: %x\n", c & 0x0f);
			}
			crsize(csize, size);
			tsize = size;
		}
		else if ((c & 0xf0) == 0x40) {
			c &= 0xf;
			switch (c) {
			case 0:/* fprintf(stderr,"INIT\n"); */
				break;
			case 1:
				font &= 30;
				break;
			case 2:
				font |= 1;
				break;
			case 3:
				font |= 2;
				break;
			case 4:
				font &= 29;
				break;
			case 5:
				fh = 0;
				break;
			case 6:
				fh = 1;
				break;
			case 7:
				esc = 1;
				break;
			case 8:
				esc = -1;
				break;
			case 9:/* fprintf(stderr,"STOP\n"); */
				break;
			case 10:
				lead = 1;
				break;
			case 12:
				lead = -1;
				break;
			case 14:
				font |= 4;
				break;
			case 15:
				font &= 27;
				break;
			default:
				fprintf(stderr, "ILLEGAL\n");
				break;
			}
			tfont = font;
		}
	}
	if (sflag)
		endpage();
}

tprint()
{
	if (font != cfont || size != csize) {
		printf("%d ", size * 6);
		switch (font) {
		case 0:
			printf("TR");
			break;
		case 1:
			printf("TI");
			break;
		case 2:
			printf("TB");
			break;
		case 3:
			printf("S");
			break;
		case 8:
			printf("H");
			break;
		case 9:
			printf("HO");
			break;
		case 10:
			printf("HB");
			break;
		case 11:
			printf("S");
			break;
		case 16:
			printf("C");
			break;
		case 17:
			printf("CO");
			break;
		case 18:
			printf("CB");
			break;
		case 19:
			printf("S");
			break;
		case 24:
			printf("TBI");
			break;
		case 25:
			printf("HBO");
			break;
		case 26:
			printf("CBO");
			break;
		case 27:
			printf("S");
			break;
		default:
			fprintf(stderr, "Illegal Font %d\n", font);
		}
		printf(" F\n");
		cfont = font;
		csize = size;
	}
	if (ypos == cy)
		printf("(%s)%d X\n", pstr, xpos);
	else
		printf("(%s)%d %d P\n", pstr, xpos, 3 * ypos);
	cx = xpos;
	cy = ypos;
}

fontps(f1, ps, str)
char *str;
{
	tfont = cfont;
	tsize = csize;
	pstr = str;
	size = ps;
	font = f1;
}

illegal(s)
char *s;
{
	fprintf(stderr, "Sequence %s is not allowed\n", s);
}

crsize(old, new)
{
	if ((old == 16 || old >= 20) && (new != 16 && new < 20))
		xpos += 55;
	else if ((new == 16 || new >= 20) && (old != 16 && old < 20))
		xpos -= 55;
}

char *
cstr(c)
char c;
{
	static char s[2] = " ";

	*s = c;
	return s;
}

newpage()
{
	printf("save\n");
}

prolog()
{
	printf("/P {moveto show} def\n");
	printf("/X {currentpoint exch pop moveto show} def\n");
	printf("/F {findfont exch scalefont setfont} def\n");
	printf("/TR /Times-Roman def\n");
	printf("/TI /Times-Italic def\n");
	printf("/TB /Times-Bold def\n");
	printf("/S /Symbol def\n");
	printf("/H /Helvetica def\n");
	printf("/HO /Helvetica-Oblique def\n");
	printf("/HB /Helvetica-Bold def\n");
	printf("/C /Courier def\n");
	printf("/CO /Courier-Oblique def\n");
	printf("/CB /Courier-Bold def\n");
	printf("/TBI /Times-BoldItalic def\n");
	printf("/HBO /Helvetica-BoldOblique def\n");
	printf("/CBO /Courier-BoldOblique def\n");
	printf("1 6 div dup scale\n");
}

endpage()
{
	printf("showpage\n");
	printf("restore\n");
	cfont = csize = -1;	/* Doing this will cause a new font message */
}
