%%STARTSHELL%%
#@(#)gfnttab.sh 2.1 90/07/18
#	Set this to something non-null in the Makefile if you need
#	a.out.h/COFF headers on your width files, and the COFF/HEADERSIZE
#	defines cause dit2catwid to generate width tables that
#	troff screams about.
compile=%%COMPILE%%
rc=1
dir=$1
install=$2
curdir=`pwd`
fontdir=%%FONTDIR%%
trap "echo GFNTTAB failed ; exit \$rc" 0
if [ -z "$dir" ]
then
    echo "Missing font directory argument"
    exit
fi
echo "GFNTTAB: Processing font directory $dir"
if [ -n "$install" ]
then
    ffile=$curdir/$install.fonts.new
else
    ffile=`basename $dir | sed -e 's/^.*\(..\)$/\1/'`
    ffile=$curdir/$ffile.fonts.new
fi
rm -f $ffile
if [ ! -d $dir ]
then
    echo "No $dir directory"
    exit
fi
cd $dir
rm -f /tmp/S
if [ ! -r R ]
then
    echo "Creating Dummy R font width table"
    touch R
fi
if [ -r S ]
then
    cp S /tmp/S
    chmod 644 /tmp/S
    if [ -r S2 ]
    then
	sed -e '1,/charset/d' S2 >> /tmp/S
    fi
    if [ -r ST ]
    then
	sed -e '1,/charset/d' ST >> /tmp/S
    fi
    if [ -r SI ]
    then
	sed -e '1,/charset/d' SI >> /tmp/S
    fi
else
    echo "WARNING: no symbol font!"
    > /tmp/S
fi
DESC=DESC
if [ -r $DESC ]
then
    res=`sed -n -e 's/^[ 	]*res[ 	][ 	]*\([0-9][0-9]*\).*/\1/p' $DESC`
    if [ -z "$res" ]
    then
	echo "WARNING: no `res' command in DESC - assuming 300"
	res="-r 300"
    else
	res="-r $res"
    fi
else
    echo "WARNING: no DESC file in $dir - assuming 'res 300'"
    res="-r 300"
fi
for i in [A-Z]*
do
    case $i in
	??) ;;
	?) ;;
	*) continue ;;
    esac
    trc=0
    if [ "$i" != S2 -a "$i" != ST -a "$i" != SI ]
    then
	Cline=`sed -e '1q' $i | sed -e 's/^#[ 	]*//'`
	echo "$i	$Cline" >> $ffile
    fi
    case $i in
	S)
	    args="-s R /tmp/S"
	    ;;
	S2 | ST | SI)
	    continue
	    ;;
	*)
	    args="/tmp/S $i"
	    ;;
    esac
    echo "GFNTTAB: processing font $i ($Cline)"
    if [ -n "$compile" ]
    then
	$curdir/dit2catwid $res -c $args ft${i}.c
	if [ $? != 0 ]
	then
	    trc=1
	else
	    cc -c ft${i}.c
	    trc=$?
	    mv ft${i}.o ft${i}
	fi
    else
	$curdir/dit2catwid $res $args ft${i}
	trc=$?
    fi
    if [ $trc != 0 ]
    then
	rc=2
    fi
done
if [ $rc -gt 1 ]
then
    exit
fi
if [ -s "$ffile" ]
then
    ed - $ffile <<\!
0a
DUM
DUM
DUM
DUM
.
g/^R	/m0
g/^I	/m1
g/^B	/m2
g/^S	/m3
4a
..	BracketFont
.
g/^DUM/d
w
q
!
fi
if [ $? != 0 ]
then
    exit
fi
if [ -n "$install" ]
then
    if [ ! -d $fontdir/$install ]
    then
	mkdir $fontdir/$install
    fi
    mv ft* $fontdir/$install
    if [ $? != 0 ]
    then
	exit
    fi
fi
trap '' 0
rc=0
exit 0
