/*	Copyright 1985, 1986, 1987, 1988 16:47:45 Chris Lewis
		All Rights Reserved

    Permission to copy and further distribute is freely given provided
    this copyright notice remains intact and that this software is not
    sold for profit.

	Project:	Generic Troff drivers
	Module:		dit2catwid.c
	Author: 	Chris Lewis
	Specs:		Converts ditroff width tables to CAT's
 */

#ifndef	lint
static char SCCSID[] =
    "@(#)dit2catwid.c 2.1 Copyright 90/07/18 16:47:45 Chris Lewis";
#endif

#include <stdio.h>
#include "../defs.h"
#include <ctype.h>

#ifndef	HEADERSIZE
#	ifdef COFF
#		include <aouthdr.h>
#		include <filehdr.h>
#		include <scnhdr.h>
#		include <ldfcn.h>
#		include <reloc.h>
#		define H1 (sizeof (struct filehdr) + sizeof (struct aouthdr))
#		define H2 (sizeof (struct scnhdr) + sizeof (struct reloc))
#		define HEADERSIZE (H1 + H2)
#	else
#		include <a.out.h>
#		define HEADERSIZE (sizeof (struct exec))
#	endif
#endif

int res = 300;
int unitwid = 10;
int symfont = 0;
int verbose = 0;
int genc = 0;

#define	TROFFUWID	6

#ifdef	DEBUG
#undef	DEBUG
#endif

FILE *mustopen();

extern struct cattab tabN[], tabS[];

char *progname;

main(argc, argv)
int argc; char **argv; {
    extern char *optarg;
    extern int optind;
    int c;

    FILE *in1, *in2, *out;
    char *fin1, *fin2, *fout;

    progname = argv[0];

    while ((c = getopt(argc, argv, "vsr:u:ch")) != EOF)
	switch(c) {
	    case 'h':
		printf("%d\n", HEADERSIZE);
		exit(0);
		break;
	    case 's':
		symfont = 1;
		break;
	    case 'r':
		res = atoi(optarg);
		break;
	    case 'u':
		unitwid = atoi(optarg);
		break;
	    case 'v':
		verbose = 1;
		break;
	    case 'c':
		genc = 1;
		break;
	    default:
		usage();
	}
    if (optind != argc - 3) {
	usage();
    }
    in1 = mustopen(fin1 = argv[optind], "r");
    in2 = mustopen(fin2 = argv[optind+1], "r");
    out = mustopen(fout = argv[optind+2], "w");

    process(in1, fin1);
    process(in2, fin2);

    sort(tabS);
    sort(tabN);

    if (genc) {
	if (symfont)
	    genccode(tabS, out, fout, "Symbol character set");
	else
	    genccode(tabN, out, fout, "Normal character set");
    } else {
	if (symfont)
	    output(tabS, out, fout, "Symbol character set");
	else
	    output(tabN, out, fout, "Normal character set");
    }
    fclose(in1);
    fclose(in2);
    fclose(out);
    exit(0);
}

genccode(symset, f, file, type)
FILE *f;
struct cattab *symset;
char *type, *file; {
    int i, j;

    fprintf(f, "/* %s */\n", type);
    fprintf(f, "char ftXX[224] = {\n");

    for (i = 0, j = 0; i < 224; i++) {
	/* skip to next valid CAT char */
	while(symset[j].ch_name && !symset[j].ch_name[0])
	    j++;

	/* not the right position yet */
	if (!symset[j].ch_name || i < symset[j].ch_wididx) {
	    gencline(f, i, 0, NULL);
	    continue;
	}

	if (symset[j].ch_wididx != i) {
	    fprintf(stderr, "GFNTTAB: index mismatch: (%d/%d)\n",
		i, j);
	    exit(1);
	}

	if (!(symset[j].ch_info&0x3f)) {
	    printf("INFO: No width for %s (index %d, file %s)\n",
		symset[j].ch_name, symset[j].ch_wididx, file);
	    gencline(f, i, symset[0].ch_info, symset[j].ch_name);
	} else
	    gencline(f, i, symset[j].ch_info, symset[j].ch_name);
	j++;
    }

    fprintf(f, "};\n");
    dumpset(symset, "After C Dump");

    if (symset[j].ch_name) {
	fprintf(stderr, "GFNTTAB: table error (too long: %d left: %s)\n",
	    j, symset[j].ch_name);
	exit(1);
    }
}

gencline(file, index, width, name)
FILE *file; int index, width; char *name; {
    int w = width&077;
    int k = width&0300;
    fprintf(file, "\t%2d", w);
    if (k)
	fprintf(file, "+0%03o", k);
    if (index != 223)
	fprintf(file, ",");
    if (name && *name) {
	if (!k)
	    fprintf(file, "\t");
	fprintf(file, "\t/* %s */\n", name);
    } else
	fprintf(file, "\n");
}

output(symset, f, file, type)
FILE *f;
struct cattab *symset;
char *type, *file; {
    int i, j;
    /* This simply prepends HEADERSIZE bytes to the font width file.
       This may not be adequate for some troffs, in that some of the
       fields in the appropriate object headers have to be filled in.
       If this is a problem, use dit2catwid -c and compile it manually.
    */

    for (i = 0; i < HEADERSIZE; i++)
	fputc('\0', f);

    for (i = 0, j = 0; i < 224; i++) {

	/* skip to next valid CAT char */
	while(symset[j].ch_name && !symset[j].ch_name[0])
	    j++;

	/* not the right position yet */
	if (!symset[j].ch_name || i < symset[j].ch_wididx) {
	    fputc('\0', f);
	    continue;
	}

	if (symset[j].ch_wididx != i) {
	    fprintf(stderr, "GFNTTAB: index mismatch: (%d/%d)\n",
		i, j);
	    exit(1);
	}

	if (!(symset[j].ch_info&0x3f)) {
	    printf("INFO: No width for %s (index %d, file %s)\n",
		symset[j].ch_name, symset[j].ch_wididx, file);
	    fputc(symset[0].ch_info, f);
	} else
	    fputc(symset[j].ch_info, f);
	j++;
    }

    dumpset(symset, "After CAT dump");

    if (symset[j].ch_name) {
	fprintf(stderr, "GFNTTAB: table error (too long: %d left: %s)\n",
	    j, symset[j].ch_name);
	exit(1);
    }
}

dumpset(symset, str)
struct cattab *symset;
char *str; {
    int i, j;
    if (verbose) {
	printf("\n%s:\n", str);
	for (i = 0; symset[i].ch_name; i++) {
	    if (strlen(symset[i].ch_name) == 0)
		continue;
	    printf(" %4d", symset[i].ch_wididx);
	    printf("	%d+%03o,",
		symset[i].ch_info & 077, symset[i].ch_info & 0300);
	    if (symset[i].ch_name)
		printf ("	/* \"%s\" */\n", symset[i].ch_name);
	    else
		printf ("\n");
	}
    }
}

usage() {
    fprintf(stderr, "usage: %s [-rres] [-uunitwid] normfont symfont output\n",
	progname);
    exit(1);
}

FILE *
mustopen(f, mode)
char *f, *mode; {
    FILE *desc;
    if ((desc = fopen(f, mode)) == NULL) {
	fprintf(stderr, "%s: cannot open file %s mode %s\n", progname, f, mode);
	exit(1);
    } else
	return(desc);
}

char *gettoken();

process(f, filename)
FILE *f;
char *filename; {
    char *sv;
    char buffer[512];
    char *tok;
    int commentsok = 1;
    int widval, oldwidval;
    while(fgets(buffer, sizeof(buffer), f) && buffer[0] == '#');

    if (feof(f))	/* NULL file */
	return;

    do {
	tok = gettoken(buffer, NULL);

	if (!tok)
	    continue;
	if (0 == strcmp(tok, "charset"))
	    break;

	if (0 == strcmp(tok, "spacewidth")) {
	    if (!(tok = gettoken(buffer, 1))) {
		fprintf(stderr, "%s: bad spacewidth line in %s\n",
		    progname, filename);
		exit(1);
	    }
	    widval = atoi(tok);
	    widval = ((double) TROFFUWID * TROFFRESOLUTION * widval /
		(unitwid * res)) + .5;
	    update(tabS, " ", widval);
	    update(tabN, " ", widval);
	    update(tabS, "\\|", widval / 2);
	    update(tabN, "\\|", widval / 2);
	    update(tabS, "\\^", widval / 4);
	    update(tabN, "\\^", widval / 4);
	}
    } while(fgets(buffer, sizeof(buffer), f));

    if (strcmp(tok, "charset")) {
	fprintf(stderr, "%s: %s bad format - no charset line\n", progname,
	    filename);
	exit(1);
    }
    while(fgets(buffer, sizeof(buffer), f)) {
	char str[3];
	if (commentsok && buffer[0] == '#')
	    continue;
	if (strlen(buffer) > 1 && buffer[0] == '#' && !isspace(buffer[1]))
	    continue;
	commentsok = 0;
#ifdef	DEBUG
	printf("buffer: %s\n", buffer);
#endif
	tok = gettoken(buffer, NULL);
	if (!tok)
	    continue;
	if (strlen(tok) > 2) {
	    fprintf(stderr, "%s: %s bad format on line %s\n",
		progname, filename, buffer);
	    exit(1);
	}
	strcpy(str, tok);
	tok = gettoken(buffer, 1);
	if (!tok) {
	    fprintf(stderr, "%s: %s bad format on line %s\n",
		progname, filename, buffer);
	    exit(1);
	}
	if (tok[0] == '#' && !isspace(tok[1]))
	    continue;
#ifdef	DEBUG
	printf("token: %s\n", tok);
#endif
	if (0 == strcmp(tok, "\""))
	    widval = oldwidval;
	else {
	    widval = ((double) TROFFUWID * TROFFRESOLUTION * atoi(tok) /
		(unitwid * res)) + .5;
	    widval = max(widval, 1);
	    tok = gettoken(buffer, 1);
	    if (!tok) {
		fprintf(stderr, "%s: %s bad format on line %s\n",
		    progname, filename, buffer);
		exit(1);
	    }
	    widval |= (atoi(tok) << 6);
	}
	update(tabS, str, widval);
	update(tabN, str, widval);
	oldwidval = widval;
    }
}

update(table, str, val)
struct cattab *table;
char *str;
int val; {
    int i;

#ifdef	DEBUG
    printf("Inserting char %s, (%03o)\n", str, val);
#endif

    for (i = 0; table[i].ch_name; i++)
	if (str && 0 == strcmp(table[i].ch_name, str)) {
	    if (verbose && table[i].ch_info && table[i].ch_info != val)
		fprintf(stderr, "Duplicate nonequal width entry (%s/%s:%x/%x)\n",
		    table[i].ch_name, str, table[i].ch_info, val);
	    table[i].ch_info = val;
	}
}

char *
gettoken(buf, ptr)
char *buf, *ptr; {
    static char *saveptr;
    static char savebuf[512];
    char *bp = savebuf;
    if (!ptr)
	saveptr = buf;
    while(*saveptr && isspace(*saveptr)) saveptr++;
    if (*saveptr)
	while(*saveptr && !isspace(*saveptr))
	    *bp++ = *saveptr++;
    *bp = '\0';
    if (savebuf[0])
	return(savebuf);
    else
	return((char *) NULL);
}

tabcmp(a, b)
struct cattab *a, *b; {
    return(a->ch_wididx - b->ch_wididx);
}

sort(table)
struct cattab *table; {
    register int i;

    for (i = 0; table[i].ch_name; i++);

    qsort(table, i, sizeof(struct cattab), tabcmp);

    dumpset(table, "After Sort");
}
