/*	Copyright 1985, 1986, 1987, 1988 16:49:49 Chris Lewis
		All Rights Reserved

    Permission to copy and further distribute is freely given provided
    this copyright notice remains intact and that this software is not
    sold for profit.

	Project:	Generic Troff drivers
	Module:		pk2sfp.c
	Author: 	Chris Lewis
	Specs:		prints header info from PK's and SFP's
 */

#ifndef	lint
static char SCCSID[] =
    "@(#)pk2sfp.c 2.1 Copyright 90/07/18 16:49:49 Chris Lewis";
#endif
#include "defs.h"
#include "pk.h"

int firstchar = 0, lastchar = 0xff;
int verbose = 0;
char *progname;
extern char *mustmalloc();
long pks_malloc;

/*	Dummied out for pk.c */
needchar(a, b)
int a, b; {
    return(1);
}

main(argc, argv)
int argc;
char **argv; {
    int c;
    extern int optind, getopt();
    extern char *optarg;
    register struct pkp *p;
    struct pkp *pk_read();

    progname = argv[0];
    while((c = getopt(argc, argv, "D:vf:l:")) != EOF)
	switch(c) {
	    case 'D':
#ifdef	DEBUG
		setdebug(optarg, "diagnostics");
		break;
#else
		fprintf(stderr, "%s: debug not supported recompile with DEBUG\n",
		    progname);
		exit(1);
#endif
	    case 'v':
		verbose = 1;
		break;
	    case 'f':
		firstchar = *optarg;
		break;
	    case 'l':
		lastchar = *optarg;
		break;
	    default:
		fprintf(stderr, "Usage: %s [-f<ch>] [-l<ch>] pk_files\n", progname);
		exit(1);
	}
#ifdef	DEBUG2
    {
	struct pkc p;
	static int8 raster[] = {
	    0xd9, 0xe2, 0x97, 0x2b, 0x1e, 0x22,
	    0x93, 0x24, 0xe3, 0x97, 0x4e, 0x22,
	    0x93, 0x2c, 0x5e, 0x22, 0x97, 0xd9};

	struct ras *r;

	p.pkc_flag = 0x88;
	p.pkc_dyn_f = 8;
	p.pkc_pl = 0x1a;
	p.pkc_char = 4;
	p.pkc_tfm = 0x09c61c;
	p.pkc_dx = 0x19;
	p.pkc_dy = 0;
	p.pkc_x_off = 0xFE;
	p.pkc_y_off = 0;
	p.pkc_height = 0x1d;
	p.pkc_width = 0x14;
	p.pkc_pkr = raster;
	p.pkc_rlen = sizeof(raster);
	r = pkrast(&p);
	dumpr(r, p.pkc_height);
    }
#endif
    for (; optind < argc; optind++) {
	char *filebuf = mustmalloc(strlen(argv[optind]) + 10);
	register char *cp;

	cp = strrchr(argv[optind], '/');

	if (cp)
	    strcpy(filebuf, cp+1);
	else
	    strcpy(filebuf, argv[optind]);

	strcat(filebuf, ".D");

	if (diagFile)
	    fclose(diagFile);

	if (!(diagFile = fopen(filebuf, "w"))) {
	    fprintf(stderr, "%s: cannot open filebuf\n");
	    exit(1);
	}
	p = pk_read(argv[optind]);
	pk_dump(p, argv[optind]);
	pk_destroy(p);
	free(filebuf);
    }
    exit(0);
}

pk_dump(p, file)
struct pkp *p;
char *file; {
    struct pkc *pc;

    fprintf(diagFile, "**********************************************\n");
    fprintf(diagFile, "File %s:\n", file);
    fprintf(diagFile, "  Font file type: %s\n",
	p->pkp_flags&1 ? "PK" : "SFP");
    fprintf(diagFile, "  Number of characters: %d\n", p->pkp_num);
    fprintf(diagFile, "  Approximately %d bytes used\n", pks_malloc);
    fprintf(diagFile, "  Design size: %ld, Native point size: %ld\n",
	p->pkp_ds, p->pkp_ds / pow2(20));
    fprintf(diagFile, "  Pointsize normalized to %d DPI: %ld\n",
	OUTRES, p->pkp_npts);
    fprintf(diagFile, "  Checksum: %ld\n", p->pkp_cs);
    fprintf(diagFile, "  hppp: %ld, vppp: %ld\n", p->pkp_hppp, p->pkp_vppp);
    fprintf(diagFile, "  hor. pixels/point: %f, ver. pixels/point: %f\n",
	(double) p->pkp_hppp / pow2(16), (double) p->pkp_vppp / pow2(16));
    fprintf(diagFile,
	"  Hor. font resolution: %ld, Ver. font resolution: %ld\n",
	p->pkp_res, (long) ((p->pkp_vppp * POINT / pow2(16)) + .5));
    fprintf(diagFile,
	"  Max y offset: %ld, Max descender: %ld, ", p->pkp_bmax, p->pkp_dmax);
    fprintf(diagFile, "Max width: %ld, Max X offset: %ld\n",
	p->pkp_wmax, p->pkp_xomax);
    fprintf(diagFile,
	"  Kern high: %ld, Kern low: %ld\n", p->pkp_kh, p->pkp_kl);
    fprintf(diagFile,
	"  SFP Info: symset: %d%c, style: %d, stroke: %d, typeface: %d\n",
	(p->pkp_symset & 0x01e0) >> 5, (p->pkp_symset & 0x1f) + '@',
	p->pkp_style, p->pkp_sw, p->pkp_typeface);

    for (pc = p->pkp_chars; pc; pc = pc->pkc_next) {
	register int i;
	if (pc->pkc_char < firstchar || pc->pkc_char > lastchar)
	    continue;
	fprintf(diagFile, "\nCharacter: %lx (%c), (0%03o), Packet length: %d\n",
	    pc->pkc_char, (char) (isprint(pc->pkc_char) ? pc->pkc_char : '?'),
	    pc->pkc_char, pc->pkc_pl);
	fprintf(diagFile, "  Flag byte: %d\n", pc->pkc_flag);
	fprintf(diagFile, "  Dynamic packing variable: %d\n", pc->pkc_dyn_f);
	fprintf(diagFile, "  TFM width: %d, dx: %d", pc->pkc_tfm, pc->pkc_dx);
	if (pc->pkc_dy)
	    fprintf(diagFile, " dy: %d\n", pc->pkc_dy);
	else
	    putc('\n', diagFile);
	fprintf(diagFile,
	    "  Height: %d, Width: %d, X-offset: %d, Y-offset: %d\n",
	    pc->pkc_height, pc->pkc_width, pc->pkc_x_off, pc->pkc_y_off);
	if (pc->pkc_rlen) {
	    fprintf(diagFile,
		"  Raster length: %d, width in pixels: %ld\n", pc->pkc_rlen,
		pc->pkc_dx / pow2(16));
	    fprintf(diagFile, "  ");
	    for (i = 0; i < 32; i++)
		if (i >= pc->pkc_rlen)
		    break;
		else
		    fprintf(diagFile, "%02x", 0xff & pc->pkc_pkr[i]);
	    putc('\n', diagFile);
	}

	if (pc->pkc_sfpr)
	    fprintf(diagFile, "  SFP length: %d\n", pc->pkc_sfpr->ras_bytes);
	if (p->pkp_flags&PK_PK) {
	    if (pc->pkc_dyn_f == 14)
		fprintf(diagFile, "  Bit map character, ");
	    else
		fprintf(diagFile, "  Packed character, ");
	    switch(pc->pkc_flag & 0x7) {
		case 7:
		    fprintf(diagFile, "Long form\n");
		    break;
		case 4: case 5: case 6:
		    fprintf(diagFile, "Extended short form\n");
		    break;
		default:
		    fprintf(diagFile, "Short form\n");
	    }
	}
	if (verbose)
	    rasterdump(pc);
    }
}

rasterdump(pc)
struct pkc *pc; {
    struct ras *r;
    register int x, y;
    extern struct ras *pkrast();
    r = pkrast(pc);
    if (r) {
	fprintf(diagFile, "Character image:\n");
	dumpr(r, r->ras_height);
	free(r->ras_raster);
	free(r);
    } else
	fprintf(diagFile, "NULL character image\n");
}
