/*	Copyright 1985, 1986, 1987, 1988 90/07/18 Chris Lewis
		All Rights Reserved

    Permission to copy and further distribute is freely given provided
    this copyright notice remains intact and that this software is not
    sold for profit.

	Project:	Generic Troff drivers
	Module:		pk2sfp.c
	Author: 	Chris Lewis
	Specs:		Generates SFP's from PK's.
 */

#ifndef	lint
static char SCCSID[] =
    "@(#)pk2sfp.c 2.1 Copyright 90/07/18 16:49:44 Chris Lewis";
#endif

#include "defs.h"
#include "pk.h"

#define	MAXMAP 256

struct fontmap {
    short from;
    short to;
} fontmap[MAXMAP], *flast = fontmap, *fp;

char emittedyet[256];

#define	NOTSET	32767

int symset = NOTSET;
int style = NOTSET;
int strokeweight = NOTSET;
int typeface = NOTSET;
int fontid = NOTSET;
int verbose = 0;
int merge = 0;
int symbol = 0;
int partial = 0;
int permanent = 0;

char *progname;

extern struct enctab encNormal[], encSymbol[];

needchar(font, character)
int font;
long character; {
    register struct enctab *tab;
    register char *p;

    if (!partial)
	return(1);

    if (symbol)
	tab = encSymbol;
    else
	tab = encNormal;

    for(; tab->e_name; tab++) {
	for (p = tab->e_seq; *p; p++)
	    if (((*p) & 0xff) == character)
		return(1);
    }

    return(0);
}

main(argc, argv)
int argc;
char **argv; {
    char buf[512];
    extern int optind;
    long totalbytes, numbytes;
    int totalcodes, numcodes;

    extern char *optarg;
    int i;
    int c;

    progname = argv[0];

    while((c = getopt(argc, argv, "D:s:t:w:f:i:vmSpP")) != EOF) {
	switch(c) {
	    case 'D':
#ifdef	DEBUG
		setdebug(optarg, "diagnostics");
		break;
#else
		fprintf(stderr, "%s: DEBUG disabled, recompile\n", progname);
		exit(1);
#endif
	    case 'P':
		permanent = 1;
		break;
	    case 'S':
		symbol = 1;
		break;
	    case 'p':
		partial = 1;
		break;
	    case 's':
		symset = ((optarg[0] - '0') << 5) + optarg[1] - 64;
		break;
	    case 't':
		style = atoi(optarg);
		break;
	    case 'w':
		strokeweight = atoi(optarg);
		break;
	    case 'f':
		typeface = atoi(optarg);
		break;
	    case 'i':
		fontid = atoi(optarg);
		break;
	    case 'v':
		verbose = 1;
		break;
	    case 'm':
		merge = 1;
		break;

	    default:
		fprintf(stderr, "usage: pk2sfp [-Dopts] [<options>] file...\n");
		fprintf(stderr, "or   : pk2sfp -m [-Dopts] [<options>]");
		fprintf(stderr, " map file map file ....\n");

		fprintf(stderr, "\t-sna: symset, eg: -s8U\n");
		fprintf(stderr, "\t-t0|1: style: 0 upright, 1 italic\n");
		fprintf(stderr, "\t-wn: stroke weight (-7..7)\n");
		fprintf(stderr, "\t-fn: typeface, eg: 5 is Times Roman\n");
		fprintf(stderr, "\t-in: prepend fontid n, auto increments\n");
		fprintf(stderr, "\t-v: verbose - emit actions to stderr\n");
		fprintf(stderr, "\t-p: only download chars psroff needs\n");
		fprintf(stderr, "\t-S: font is used for psroff Symbol font\n");
		fprintf(stderr, "\t-P: mark font as permanent (needs -in)\n");
		exit(1);
	}
    }
    if (merge)
	fprintf(stderr, "MERGING fonts\n");

    numbytes = 0;

    for(;argv[optind];optind++) {
	register struct pkp *pk;
	register struct pkc *pc;

	numcodes = 0;
	numbytes = 0;

	strcpy(buf, argv[optind]);

	if (merge && readmerge(buf))
	    continue;

	/* Read the PK file in-core */
	pk = pk_read(buf);

	/* Overrides */
	if (symset != NOTSET)
	    pk->pkp_symset = symset;
	if (style != NOTSET)
	    pk->pkp_style = style;
	if (strokeweight != NOTSET)
	    pk->pkp_sw = strokeweight;
	if (typeface != NOTSET)
	    pk->pkp_typeface = typeface;

	if (verbose)
	    if (merge > 1)
		fprintf(stderr, "Appending %s: ", buf);
	    else
		fprintf(stderr, "Emitting %s: ", buf);

	/* you want a font ID select? */
	if (merge <= 1 && fontid != NOTSET) {
	    if (verbose)
		fprintf(stderr, "fontid %d\n", fontid);
	    printf("\033*c%dD", fontid);
	} else
	    if (verbose)
		fprintf(stderr, "no fontid\n");

	if (merge <= 1 && verbose) {
	    fprintf(stderr, "\tsymset: %d%c\n", pk->pkp_symset >> 5,
		(pk->pkp_symset & 0x1f) + 64);
	    fprintf(stderr, "\ttype: %s\n", pk->pkp_style?"italic":"upright");
	    fprintf(stderr, "\tstroke weight: %d\n", pk->pkp_sw);
	    fprintf(stderr, "\ttypeface: %d\n", pk->pkp_typeface);
	}

	if (merge <= 1) {
	    /* Emit the SFP header */
	    epk_desc(pk, stdout);
	    numbytes += 2048;
	    numcodes = 0;
	    if (merge == 1)
		merge++;
	}

	/* Emit each character */
	for (i = 0; i < pk->pkp_num; i++) {
	    pc = pk->pkp_list[i];
	    if (merge) {
		for (fp = fontmap; fp < flast; fp++)
		    if (pc->pkc_char == fp->from) {
			pc->pkc_char = fp->to;
			if (emittedyet[(fp->to)&0xff]) {
			    if (verbose)
				fprintf(stderr,
				"Skipping %02x (%c) as %02x (%c) from %s\n",
				fp->from, pchr(fp->from),
				fp->to, pchr(fp->to), buf);
			    break;
			}
			if (verbose)
			    fprintf(stderr,
				"Emitting %02x (%c) as %02x (%c) from %s\n",
				fp->from, pchr(fp->from),
				fp->to, pchr(fp->to), buf);
			emittedyet[(fp->to)&0xff] = 1;
			fp->to = 0x00;
			numbytes += epkc_desc(pc, stdout);
			numcodes++;
			break;
		    }
	    } else {
		DBP((D_FONT,"Downloading char %02x (%c)\n", pc->pkc_char,
		    pchr(pc->pkc_char)));
		numbytes += epkc_desc(pc, stdout);
		numcodes++;
	    }
	}
				/* added to make fonts permanent */
				/* ron@mlfarm 6.1.90 */

	if (fontid != NOTSET && permanent)
	    printf("\033*c%dd5F", fontid);

	if (fontid != NOTSET)
	    fontid++;

	/* Clobber in-core PK */
	pk_destroy(pk);

	totalbytes += numbytes;
	totalcodes += numcodes;
	if (verbose)
	    fprintf(stderr, "%s: %d bytes %d codes\n", buf, numbytes, numcodes);

    }
    if (merge)
	checkmissing((char *) NULL);
    if (verbose)
	fprintf(stderr, "total: %d bytes %d codes\n", totalbytes, totalcodes);
    exit(0);
}

/*	similar to strtol */
short
cvt(p)
register char *p; {
    register short ret = 0;
    int base = 10;

    if (!isdigit(*p) && !*(p+1))
	return(*p);

    if (*p == '0')
	if (*(p+1) == 'x' || *(p+1) == 'X') {
	    base = 16;
	    p += 2;
	} else
	    base = 8;
    while(*p)
	ret = ret * base + ccvt(*p++);
    return(ret);
}

ccvt(c)
int c; {
    if (isdigit(c))
	return(c - '0');
    else if (isupper(c))
	return(c - 'A' + 10);
    else if (islower(c))
	return(c - 'a' + 10);
    else {
	fprintf(stderr, "%s: bad digit %c in map file\n", progname, c);
	exit(1);
    }
}
pchr(x)
int x; {
    if (isascii(x) && isprint(x))
	return(x);
    else
	return('?');
}

/*	Reads merge descriptor.  Returns non-zero if not a merge */
readmerge(name)
char *name; {
    char from[20], to[20];
    FILE *f = fopen(name, "r");
    char buffer[512];
    register char *p;
    if (!f) {
	fprintf(stderr, "%s: Can't open %s\n", progname, name);
	exit(1);
    }
    if (!fgets(buffer, sizeof(buffer), f)) {
	fprintf(stderr, "%s: Nothing in this file? (%s)\n", progname, name);
	fclose(f);
	return(0);
    }
    if (buffer[0] == '\033' || (buffer[0] & 0xff) == PK_pre) {
	fclose(f);
	return(0);
    }
    checkmissing(name);
    flast = fontmap;
    do {
	for(p = buffer; *p && isspace(*p); p++);
	if (!*p || *p == '\n' || *p == '#')
	    continue;
	switch(sscanf(p, "%s %s", from, to)) {
	    case 0:
		continue;
	    case 1:
		strcpy(to, from);
		break;
	    case 2:
		if (strcmp(to, "\"") == 0)
		    strcpy(to, from);
		break;
	}
	if (flast - fontmap >= MAXMAP) {
	    fprintf(stderr, "%s: too many map sequences in %s\n", progname,
		name);
	    exit(1);
	}

	flast->from = cvt(from);
	flast->to = cvt(to);
	flast++;
    } while (fgets(buffer, sizeof(buffer), f));
    fclose(f);

#ifdef	DEBUG
    if (debug&D_FONT) {
	DBP((D_FONT, "Map from %s map file\n", name));
	for (fp = fontmap; fp < flast; fp++)
	    DBP((D_FONT, "  %02x (%c) -> %02x (%c)\n",
		fp->from, pchr(fp->from),
		fp->to, pchr(fp->to)));
    }
#endif
    return(1);
}

checkmissing(name)
register char *name; {
    static char lastmap[512];
    if (!verbose || flast == fontmap)
	return;
    for (fp = fontmap; fp < flast; fp++)
	if (fp->to)
	    fprintf(stderr, "Didn't remap 0x%02x:0%o:%d (%c) in map file %s\n",
		fp->from, fp->from, fp->from, pchr(fp->from), lastmap);
    if (name)
	strcpy(lastmap, name);
}
