/*	Copyright 1985, 1986, 1987, 1988 90/07/18 Chris Lewis
		All Rights Reserved

    Permission to copy and further distribute is freely given provided
    this copyright notice remains intact and that this software is not
    sold for profit.

	Project:	Generic Troff drivers
	Module:		sfp2ps.c
	Author: 	Chris Lewis
	Specs:		Displays SFP font information in Postscript.
			(analogous to showfont, but it reads PK/SFP
			files and generates postscript, rather than
			executing on the printer using the built-in
			fonts)
 */

#ifndef	lint
static char SCCSID[] =
    "@(#)pk2ps.c 2.1 Copyright 90/07/18 16:49:58 Chris Lewis";
#endif
#include "defs.h"
#include "pk.h"

int verbose = 0;
char *progname;
extern char *mustmalloc();
long pks_malloc;
long highest = 0;
int fontonly = 0;

/*	Dummied out for pk.c */
needchar(a, b)
int a, b; {
    return(1);
}

main(argc, argv)
int argc;
char **argv; {
    int c;
    extern int optind, getopt();
    extern char *optarg;
    register struct pkc *pc;
    register struct pkp *p;
    extern struct ras *pkrast();
    struct pkp *pk_read();
    register int i, len;
    int chcount;

    progname = argv[0];
    while((c = getopt(argc, argv, "fD:v")) != EOF)
	switch(c) {
	    case 'D':
#ifdef	DEBUG
		setdebug(optarg, "diagnostics");
		break;
#else
		fprintf(stderr, "%s: debug not supported recompile with DEBUG\n",
		    progname);
		exit(1);
#endif
	    case 'v':
		verbose = 1;
		break;
	    case 'f':
		fontonly = 1;
		break;
	    default:
		fprintf(stderr, "Usage: %s pk_files\n", progname);
		exit(1);
	}
    for (; optind < argc; optind++) {
	char *filebuf = mustmalloc(strlen(argv[optind]) + 10);
	register char *cp;

	printf("%%FILE: %s\n", argv[optind]);

	highest = 0;

	cp = strrchr(argv[optind], '/');

	if (cp)
	    strcpy(filebuf, cp+1);
	else
	    strcpy(filebuf, argv[optind]);
	cp = strchr(filebuf, '.');
	if (cp)
	    *cp = '\0';

	if (!fontonly) {
	    printf("/saveobj save def\n");
	}

	printf("10 dict dup begin\n");
	printf("/FontType 3 def\n");
	printf("/FontMatrix [1 0 0 1 0 0] def\n");
	printf("/FontBBox [1.28 1.2 -0.16 -.024] def\n");
	printf("/FontInfo 5 dict def\n");
	printf("FontInfo begin\n");
	printf("    /isFixedPitch false def\n");
	printf("end\n");
	printf("/Encoding 256 array def\n");
	printf("0 1 255 {Encoding exch /.notdef put} for\n");
	printf("Encoding\n");

	p = pk_read(argv[optind]);

	chcount = 0;
	for (pc = p->pkp_chars; pc; pc = pc->pkc_next) {
	    if (pc->pkc_next)
		printf("dup ");
	    printf("%d /ch%d put\n", pc->pkc_char, pc->pkc_char);
	    highest = max(highest, pc->pkc_char);
	    chcount++;
	}

	if (verbose) {
	    fprintf(stderr, "Emitting %s, %d codes\n", filebuf, chcount);
	}

	if (highest <= 127)
	    highest = 128;
	else
	    highest = 256;

	printf("/BuildChar\n");
	printf("    { 0 begin\n");
	printf("	/char exch def\n");
	printf("	/fontdict exch def\n");
	printf("	/charname fontdict /Encoding get char get def\n");
	printf("	/charinfo fontdict /CharData get charname\n");
	printf("	    get def\n");
	printf("	/wx charinfo 0 get def\n");
	printf("	/charbbox charinfo 1 4 getinterval def\n");
	printf("	wx 0 charbbox aload pop setcachedevice\n");
	printf("	charinfo 5 get charinfo 6 get true\n");
	printf("	fontdict /imagemaskmatrix get\n");
	printf("	    dup 4 charinfo 7 get put\n");
	printf("	    dup 5 charinfo 8 get put\n");
	printf("	charinfo 9 1 getinterval cvx\n");
	printf("	imagemask\n");
	printf("    end\n");
	printf("} def\n");
	printf("\n");
	printf("/BuildChar load 0 6 dict put\n");

#define	DOTS2UNITS(x)	((x) / ((p->pkp_npts / POINT) * 300))

	printf("/imagemaskmatrix [%.2f 0 0 -%.2f 0 0] def\n",
	    1 / DOTS2UNITS((double) 1),
	    1 / DOTS2UNITS((double) 1)
	    );
	printf("/CharData %d dict def\n", chcount+1);
	printf("CharData begin\n");

	for (pc = p->pkp_chars; pc; pc = pc->pkc_next) {
	    register struct ras *r;
	    r = pkrast(pc);
	    if (!r) {
		fprintf(stderr, "%0: no raster image for %02x\n",
		    progname, pc->pkc_char);
		continue;
	    }
	    printf(
	    "    /ch%d [ %.2f %.2f %.2f %.2f %.2f %d %d %.2f %.2f\n\t<",
		pc->pkc_char,

		DOTS2UNITS((double) pc->pkc_dx / pow2(16)),	/* width */

		DOTS2UNITS((double) -pc->pkc_x_off),		/* bblx */
		DOTS2UNITS((double) pc->pkc_y_off -
		    pc->pkc_height + 1),			/* bbly */
		DOTS2UNITS((double) -pc->pkc_x_off + pc->pkc_width),/* bbux */
		DOTS2UNITS((double) pc->pkc_height + pc->pkc_y_off),/* bbuy */

		r->ras_width,
		r->ras_height,
		(double) pc->pkc_x_off - .5,			/* shift x */
		(double) pc->pkc_y_off - .5			/* shift y */
	    );
	    len = r->ras_height * r->ras_bline;
	    for (i = 0; i < len; i++) {
		printf("%02x", r->ras_raster[i]);
		if (i % 30 == 29)
		    putchar('\n');
	    }
	    printf(">]\n    def\n");
	    free(r->ras_raster);
	    free(r);
	}
	printf("    /.notdef [ .24 0 0 0 0 1 0 0 0 <>] def\n");

	printf("    end\n");
	/*	Should be unique enough between Postscript runs	*/
	printf("    /UniqueID %ld def\n", (long) getpid() + (optind << 16));
	printf("end\n");
	printf("/%s exch definefont pop\n", filebuf);

	/* end of font definition */
	if (!fontonly) {

	    printf("36 %d moveto\n", 11 * 72 - 36);
	    printf("/%s findfont 18 scalefont setfont\n", filebuf);
	    printf("(%s) show\n", argv[optind]);
	    printf("36 %d moveto\n", 11 * 72 - 54);
	    printf("/Courier findfont 18 scalefont setfont\n");
	    printf("(%s) show\n", argv[optind]);

#ifdef	NEVER
	    printf("/%s findfont 10 scalefont setfont\n", filebuf);
	    printf("72 500 moveto (ABCDEFGHIJKLMNOPQRSTUVWXYZ) show\n");
	    printf("72 400 moveto (abcdefghijklmnopqrstuvwxyz) show\n");
#endif

#define	XPOS(i)	(((i) % 16) * 30 + 72)
#define	YPOS(i) (680 - ((i) / 16) * 44)
#define	PSIZE	7
#define	PSEP	8

	    printf("/%s findfont 18 scalefont setfont\n", filebuf);
	    for (i = 0; i < highest; i++) {
		printf("%d %d moveto\n", XPOS(i), YPOS(i) + 3 * PSEP + 3);
		printf("(\\%03o) show\n", i);
	    }
	    printf("/Courier findfont %d scalefont setfont\n", PSIZE);
	    for (i = 0; i < highest; i++) {
		if ((i % 16) == 0) {
		    printf("%d %d moveto\n", 36, YPOS(i) + 2 * PSEP);
		    printf("(DEC:) show\n");
		    printf("%d %d moveto\n", 36, YPOS(i) + PSEP);
		    printf("(HEX:) show\n");
		    printf("%d %d moveto\n", 36, YPOS(i));
		    printf("(OCT:) show\n");
		}
		printf("%d %d moveto\n", XPOS(i), YPOS(i) + 2 * PSEP);
		printf("(%3d) show\n", i);
		printf("%d %d moveto\n", XPOS(i), YPOS(i) + PSEP);
		printf("( %02x) show\n", i);
		printf("%d %d moveto\n", XPOS(i), YPOS(i));
		printf("(%03o) show\n", i);
	    }
	    printf("showpage\n");
	    printf("saveobj restore\004");
	}

	pk_destroy(p);
	free(filebuf);
    }
    exit(0);
}
