/*	Copyright 1985, 1986, 1987, 1988 16:50:16 Chris Lewis
		All Rights Reserved

    Permission to copy and further distribute is freely given provided
    this copyright notice remains intact and that this software is not
    sold for profit.

	Project:	Generic Troff drivers
	Module:		dumpft.c
	Author: 	Chris Lewis
	Specs:		Dumps CAT width tables in various formats
 */

#ifndef	lint
static char SCCSID[] =
    "@(#)dumpft.c 2.1 Copyright 90/07/18 16:50:16 Chris Lewis";
#endif

#include "../defs.h"
#define	NUMPER	8
#define	WPER	54
int dotab = 0;
struct cattab tabN[], tabS[];
#ifdef	HEADERSIZE
int skip = HEADERSIZE;
#else
#include <a.out.h>
#ifdef	X_EXEC
/*	Xenix I think.... */
#define	HEADERSIZE sizeof(struct xexec)
#endif
#ifdef	F_LNNO
/*	COFF format headers */
#define	HEADERSIZE (-sizeof(struct filehdr))
#endif
#ifndef HEADERSIZE
/*	Generalized V7 or BSD - non-coff format headers */
/*	This is the only one likely to be useful - Xenix doesn't
	need headersize, and I've not seen a COFF version of troff
	yet */
#define	HEADERSIZE sizeof(struct exec)
#endif
int skip = HEADERSIZE;
#endif

double ditres = 1;

main(argc, argv)
int argc; char **argv; {
    register int i;
    register int j, c;
    register int k;
    extern int getopt();
    extern char *optarg;
    int found;
    struct cattab *ct = tabN;
    while((c = getopt(argc, argv, "dstwfh:")) != EOF) {
	switch(c) {
	    case 'd':
		ditres = (double) 300 / 432 * (double) 10 / 6;
		break;
	    case 's':
		ct = tabS;
		break;
	    case 't':
		dotab = 1;
		break;
	    case 'w':
		dotab = 2;
		break;
	    case 'f':
		dumpexamples();
		exit(0);
	    case 'h':
		skip = atoi(optarg);
		fprintf(stderr, "skip: %d\n", skip);
		break;
	    case '?':
		fprintf(stderr,
	    "usage: dumpft [-s][-f][-t][-w][-hheadersize] < cat width file\n");
		exit(1);
	}
    }

    for (i = 0; i < skip; i++)
	c = getchar();
    k = 0;
    for (i = 0; i < 224; i++) {
	found = 0;
	c = getchar();
	for (j = 0; ct[j].ch_name; j++) {
	    if (!ct[j].ch_name[0])
		continue;
	    if (ct[j].ch_wididx == i) {
		ct[j].ch_info = c;
		found = 1;
		if ((dotab == 1 || dotab == 2) && ct[j].ch_catidx == NTC)
		    continue;
		switch(dotab) {
		    case 2:
			if (k % WPER == 0)
			    printf("%s.br\n", k == 0 ? "":"\n");
			if (strlen(ct[j].ch_name) > 1)
			    printf("\\(%s", ct[j].ch_name);
			else if (strcmp(ct[j].ch_name, "\\") == 0)
			    printf("\\e");
			else if (strcmp(ct[j].ch_name, ".") == 0)
			    printf("\\.");
			else
			    printf("%s", ct[j].ch_name);
			break;
		    case 1:
			if (k % NUMPER)
			    printf("\t");
			else
			    printf("_\n");
			if (ct[j].ch_name[0] == '\\') {
			    if (ct[j].ch_name[1] == 0)
				printf("\\e\t\\ee");
			    else
				printf("%s\t\\e%s", ct[j].ch_name,
				    &ct[j].ch_name[1]);
			} else if (strlen(ct[j].ch_name) > 1)
			    printf("\\(%s\t\\e(%s", ct[j].ch_name,
				ct[j].ch_name);
			else if (strcmp(ct[j].ch_name, ".") == 0)
			    printf("\\.\t.");
			else if (strcmp(ct[j].ch_name, "=") == 0)
			    printf("\\&=\t\\&=");
			else
			    printf("%s\t%s", ct[j].ch_name, ct[j].ch_name);
			if (k % NUMPER == (NUMPER-1))
			    putchar('\n');
			break;
		    case 0:
			if (i == 0) {
			    printf("spacewidth %d\n", c&0xf);
			    printf("charset\n");
			} else
			    printf("%s\t%d\t%d\n", ct[j].ch_name,
				(int) ((c&0x3f) * ditres + .5),
				(c >> 6) & 0x3);
			break;
		}
		k++;
	    }
	}
	if (!found && c) {
	    fprintf(stderr, "Table problem - found %d character (width %2x)\n",
		i, c);
	}
    }
    switch(dotab) {
	case 0:
	    for (i = 0; ct[i].ch_name; i++)
		if (ct[i].ch_name[0] && !ct[i].ch_info)
		    fprintf(stderr, "Table problem - no width for '%s' (%d)",
			ct[i].ch_name, i);
		    fprintf(stderr, ", wididx: %d, catidx: %d\n",
			ct[i].ch_wididx, ct[i].ch_catidx);
	    break;
	case 1:
	    if (k % NUMPER != 0)
		putchar('\n');
	    break;
	case 2:
	    putchar('\n');
	    break;
    }
    exit(0);
}

char *normch[] = {
"a","b","c","d","e","f","g","h","i","j","k","l","m","n","o",
"p","q","r","s","t","u","v","w","x","y","z",
"A","B","C","D","E","F","G","H","I","J","K","L","M","N","O",
"P","Q","R","S","T","U","V","W","X","Y","Z",
"1","2","3","4","5","6","7","8","9","0",
"!","$","%","&","(",")","`","'","*","+","\\-",
".",",","/",":",";","=","?","[","]","|",
"\\(bu","\\(sq","\\(em","\\(hy","\\(ru","\\(14","\\(12","\\(34","\\(fi",
"\\(fl","\\(ff","\\(Fi","\\(Fl","\\(de","\\(fm","\\(dg","\\(ct","\\(rg",
"\\(co","\\(tm",
NULL
};

char *symch[] = {
"\"", "\\(aa", "\\e", "^", "\\(ul", "\\(ga", "~", "\\(sl", "<",
">", "{", "}", "#", "@", "\\(pl", "\\(mi", "\\(eq", "\\(**",

"\\(*a", "\\(*b", "\\(*g", "\\(*d", "\\(*e", "\\(*z", "\\(*y", "\\(*h",
"\\(*i", "\\(*k", "\\(*l", "\\(*m", "\\(*n", "\\(*c", "\\(*o", "\\(*p",
"\\(*r", "\\(*s", "\\(ts", "\\(*t", "\\(*u", "\\(*f", "\\(*x", "\\(*q",
"\\(*w",

"\\(*G", "\\(*D", "\\(*H", "\\(*L", "\\(*C", "\\(*P", "\\(*S", "\\(*U",
"\\(*F", "\\(*Q", "\\(*W",

"\\(sr", "\\(rn", "\\(>=", "\\(<=", "\\(==", "\\(ap", "\\(~=", "\\(!=",
"\\(->", "\\(<-", "\\(ua", "\\(da", "\\(mu", "\\(di", "\\(+-", "\\(cu",
"\\(ca", "\\(sb", "\\(sp", "\\(ib", "\\(ip", "\\(if", "\\(pd",

"\\(sc", "\\(gr", "\\(no", "\\(is", "\\(pt", "\\(es", "\\(mo",
"\\(dd", "\\(rh", "\\(lh", "\\(or", "\\(ci", "\\(lt", "\\(lb",
"\\(rt", "\\(rb", "\\(lk", "\\(rk", "\\(bv", "\\(lf", "\\(rf",
"\\(lc", "\\(rc", "\\(br",
NULL
};

char *names[] = {"Times Roman",
		 "Times Italic",
		 "Times Bold",
		 "Special Mathmatics font"
};

dumpexamples() {
    register int i;
    register char **p;
    printf(".sp 1i\n");
    printf(".ps 12\n");
    printf(".vs 14p\n");
    for (i = 0; i < 3; i++) {
	printf(".ft %d\n", i+1);
	printf(".sp\n");
	printf("%s\n", names[i]);
	printf(".sp\n");
	for (p = normch; *p; p++)
	    if (strlen(*p) == 1) {
		if (isalnum(**p))
		    putchar(**p);
		else
		    printf("%c\\^", **p);
		if (**p == 'z' || **p == 'Z' || **p == '0' || **p == '|') {
		    printf("\n.br\n");
		}
	    } else {
		printf("%s\\h'.25m'", *p);
		if (strcmp(*p, "\\(tm") == 0)
		    printf("\n.br\n");
	    }
    }
    printf(".sp\n");
    printf("%s\n", names[3]);
    printf(".sp\n");
    for (p = symch; *p; p++) {
	printf("%s\\h'.25m'", *p);
	if (strcmp(*p, "\\(**") == 0 ||
	    strcmp(*p, "\\(*w") == 0 ||
	    strcmp(*p, "\\(*W") == 0 ||
	    strcmp(*p, "\\(pd") == 0)
	    printf("\n.br\n");
    }
    printf("\n");
}
