/*	Copyright 1988, 1989 16:47:06 Chris Lewis
		All Rights Reserved

    Permission to copy and further distribute is freely given provided
    this copyright notice remains intact and that this software is not
    sold for profit.

	Project:	Generic Troff drivers
	Module:		pkc.c 2.1 90/07/18 16:47:06
	Author: 	Chris Lewis
	Specs:		PK Cache handlers

*/

#if	defined(PARTIAL) || defined(INCR)
/*

	if defined(PARTIAL):

	    This defines a table of bit maps for the "normal" (N),
	    "symbol" (S) and overide (digit fonts > 3) indicating which
	    characters in the font are "useful".  This is built during
	    Prolog (which is after the ljStdFont/ljSymFont arrays are modified
	    by any overrides in the *.fonts file), by examining the
	    lj*Font arrays and seeing which characters are actually used.
	    This is "partial" downloading, *not* incremental.

	if defined(INCR):

	    This defines a table of bit maps for *each* mentioned font at
	    *each* pointsize, where the bit being on indicates whether the
	    character has been downloaded *yet*.
 */

#define	ETYP	long
#define	ELEN	(sizeof(ETYP) * 8)	/* length in bits of an ETYP */
#define	MASKLEN	((256 - (' ' * 2) + (ELEN - 1)) / ELEN)

#define	NPTSIZE	15

struct needmaps {
    int fontnum;
    ETYP nm[MASKLEN];
    struct needmaps *next;
};

#define	NMAP(x)	nm[x]

extern struct needmaps *needmaps;

#ifdef	INCR
struct downmaps {
    ETYP *nm[NPTSIZE];
    int lastpage[NPTSIZE];
    struct pkp *pkfont[NPTSIZE];
};
#endif

#define	DMAP(x,p) nm[p][x]
#endif
