/*	Copyright 1985, 1986, 1987, 1988 Chris Lewis
		All Rights Reserved

    Permission to copy and further distribute is freely given provided
    this copyright notice remains intact and that this software is not
    sold for profit.

	Project:	Generic Troff drivers
	Module:		pkc.c
	Author: 	Chris Lewis
	Specs:		PK Cache

*/

#include "defs.h"

#if	defined(PARTIAL) || defined(INCR)

#ifndef	lint
static char SCCSid[] =
    "@(#)pkc.c: 2.1 Copyright 90/07/18 16:52:50 Chris Lewis";
#endif

#include "pk.h"

#include "pkc.h"

extern int fontCount;

/*	Does the font *need* this character? */
extern struct needmaps *needmaps;

needchar(font, ch)
register int font;
register long ch; {
    register struct needmaps *nbp;

    ch &= 0xff;

    if (ch <= ' ' || (ch > 0x7f && ch <= (0x80 + ' ')))
	return(0);
    ch -= ' ';
    if (ch >= 0x80 - ' ')
	ch -= ' ';

    if (font >= 0 && font <= 2)	/* redirections to NORM fonts */
	font = N;
    else if (font == 3)		/* redirections to SYMBOL font */
	font = S;

    for (nbp = needmaps; nbp; nbp = nbp->next)
	if (nbp->fontnum == font) {
	    return(nbp->NMAP(ch / ELEN) & (1 << (ch % ELEN)));
	}
    return(0);
}


addneedchar(font, ch)
register int font, ch; {
    register struct needmaps *nbp, *onbp = (struct needmaps *) NULL;
    ch &= 0xff;

    if (ch <= ' ' || (ch > 0x7f && ch <= (0x80 + ' ')))
	return;
    ch -= ' ';
    if (ch >= 0x80 - ' ')
	ch -= ' ';

    if (font >= 0 && font <= 2)	/* redirections to NORM fonts */
	font = N;
    else if (font == 3)		/* redirections to SYMBOL font */
	font = S;

    for (onbp = (struct needmaps *) NULL, nbp = needmaps;
	nbp; onbp = nbp, nbp = nbp->next)

	if (nbp->fontnum == font)
	    break;

    if (!nbp) {
	nbp = (struct needmaps *) mustmalloc(sizeof(struct needmaps),
	    "needmaps");
	nbp->fontnum = font;
	if (!onbp)
	    needmaps = nbp;
	else
	    onbp->next = nbp;
    }
    if (ch == -1)
	return;
    nbp->NMAP(ch / ELEN) |= (1 << (ch % ELEN));
}

#endif

#ifdef	INCR
downchar(font, ch, pointidx)
int font, ch, pointidx; {
    ch &= 0xff;
    if (ch <= ' ' || (ch > 0x7f && ch <= (0x80 + ' ')))
	return(0);
    ch -= ' ';
    if (ch >= 0x80 - ' ')
	ch -= ' ';
    return(fonttable[font].map->DMAP(ch / ELEN, pointidx) &
	(1 << (ch % ELEN)));
}

setdown(font, ch, pointidx)
int font, ch, pointidx; {
    ch &= 0xff;
    if (ch <= ' ' || (ch > 0x7f && ch <= (0x80 + ' ')))
	return;
    ch -= ' ';
    if (ch >= 0x80 - ' ')
	ch -= ' ';
    fonttable[font].map->DMAP(ch / ELEN, pointidx) |= (1 << (ch % ELEN));
    fonttable[font].map->lastpage[pointidx] = currentPage;
}
#endif

#if	defined(DEBUG) && defined(PARTIAL)
dumppartmaps() {
    register struct needmaps *nbp;
    register int c;
    fprintf(diagFile,"MASKLEN: %d, ELEN: %d\n", MASKLEN, ELEN);
    for (nbp = needmaps; nbp; nbp = nbp->next) {
	fprintf(diagFile,"Font: %02x, needmap:", nbp->fontnum);
	for (c = 0; c < MASKLEN; c++)
	    fprintf(diagFile," %08x", nbp->NMAP(c));
	fprintf(diagFile,"\n");
    }
}

#ifdef	INCR
dumpincrmaps() {
    static char ptsizes[] =
	 {6, 7, 8, 9, 10, 11, 12, 14, 16, 18, 20, 22, 24, 28, 36};
    register struct downmaps *dbp;
    register int c, p, fn;
    fprintf(diagFile,"MASKLEN: %d, ELEN: %d\n", MASKLEN, ELEN);
    for (fn = 0; fonttable[fn].troffName; fn++) {
	dbp = fonttable[fn].map;
	if (!dbp)
	    continue;
	fprintf(diagFile,"Font: %02x, troffname: %s, downloadedmaps:\n",
	    fn, fonttable[fn].troffName);
	for (p = 0; p < NPTSIZE; p++) {
	    if (!dbp->nm[p])
		continue;
	    fprintf(diagFile,"f%02d p%02d:%02d lp%d %s:", fn, p,
		ptsizes[p], dbp->lastpage[p], dbp->pkfont[p] ? "load": "unlo");
	    for (c = 0; c < MASKLEN; c++)
		fprintf(diagFile," %08x", dbp->DMAP(c,p));
	    fprintf(diagFile,"\n");
	}
    }
}
#endif

dumpmaps(which)
int which; {
    DBP((D_FONT,"dumpmaps: %d\n", which));
    if (diagFile && (debug&D_FONT)) {
	switch(which) {
	    case 0: dumppartmaps(); break;
#ifdef	INCR
	    case 1: dumpincrmaps(); break;
#endif
	}
    }
}

#endif

#ifdef	INCR
/*	Go find "oldest" font and delete it, both internally *and*
	on the printer.  It cannot already be in use on this page.
 */
pkflush(needfont, needpoint)
int needfont, needpoint; {
    register int oldestpage = 32767, p;
    int bestpoints, bestfont;
    register struct downmaps *dbp;
    int font;

    DBP((D_FONT, "Flushing font - avoid font %d, ps: %d\n",
	needfont, needpoint));

    for (font = 0; fonttable[font].troffName; font++) {

	if (!(dbp = fonttable[font].map))
	    continue;

	for (p = 0; p < NPTSIZE; p++) {
	    if (!dbp->pkfont[p] || (font == needfont && needpoint == p))
		continue;

	    /* if font in use, and less than oldest page */
	    DBP((D_FONT, "Checking font %d, point: %d, lastpage: %d\n",
		font, p, dbp->lastpage[p]));

	    if (dbp->lastpage[p] && dbp->lastpage[p] < oldestpage) {
		oldestpage = dbp->lastpage[p];
		bestpoints = p;
		bestfont = font;
	    }
	}
    }

    /* oh-oh! */
    if (oldestpage >= currentPage) {

	fprintf(stderr, "Too many fonts on page %d, SIMPLIFY!\n", currentPage);

    } else {
	dbp = fonttable[bestfont].map;

	DBP((D_FONT, "Dismembering font %d, pointidx: %d, p: %x\n", bestfont,
	    bestpoints, dbp->pkfont[bestpoints]));

	/* Clobber PK */
	pk_destroy(dbp->pkfont[bestpoints]);

	/* Clobber PK pointer */
	dbp->pkfont[bestpoints] = (struct pkp *) NULL;

	/* clear downloaded arrays */
	clrarray((char*) &dbp->DMAP(0,bestpoints), MASKLEN * sizeof(ETYP));

	/* reset lastpage */
	dbp->lastpage[bestpoints] = 0;

	/* tell backend that this font isn't downloaded anymore */
	fonttable[bestfont].fontFlags[bestpoints] =
	    tolower(fonttable[bestfont].fontFlags[bestpoints]);

	fontCount--;
	/* Select and nuke downloaded font */
	printf("\033*c%dd2F", (bestfont << 4) + bestpoints);
    }
}
#endif
