/*	Copyright 1985, 1986, 1987, 1988 16:47:03 Chris Lewis
		All Rights Reserved

    Permission to copy and further distribute is freely given provided
    this copyright notice remains intact and that this software is not
    sold for profit.

	Project:	Generic Troff drivers
	Module:		pk.h
	Author: 	Chris Lewis
	Specs:		PK format font file description
 */

#ifdef	PK

#define	int8	unsigned char
#define	PK_ID	89
#define	PK_xxx1	240
#define	PK_xxx2	241
#define	PK_xxx3	242
#define	PK_xxx4	243
#define	PK_yyy	244
#define	PK_post	245
#define	PK_no_op	246
#define	PK_pre	247

/*	PK header data */
struct pkp {
#define	PK_PK	01
#define	PK_SFP	02
    long pkp_ds;	/* design size */
    long pkp_npts;	/* pointsize normalized to 300 dpi */
    long pkp_res;	/* resolution of this font */
    long pkp_cs;	/* checksum */
    long pkp_hppp;	/* Horizontal pixel ratio */
    long pkp_vppp;	/* Vertical pixel ratio */
    long pkp_bmax;	/* baseline max */
    long pkp_dmax;	/* descender max */
    long pkp_wmax;	/* width max */
    long pkp_xomax;	/* left offset max */
    long pkp_kh;	/* kern high */
    long pkp_kl;	/* kern low */
    struct pkc *pkp_chars;	/* pointer to character descriptors */
    struct pkc *pkp_last;	/* pointer to last character descriptor */
    struct pkc **pkp_list;	/* pointer to sorted list of descriptors */
    long pkp_num;	/* number of characters */
    int pkp_symset;	/* symbol set */
    char pkp_flags;	/* font format */
    char pkp_style;	/* style */
    char pkp_sw;	/* stroke weight */
    char pkp_typeface;	/* typeface */
};

struct pkp *pk_read();

struct pkc {
    long pkc_flag;	/* flag byte */
    long pkc_dyn_f;	/* dynamic packing byte */
    long pkc_pl;	/* packet length */
    long pkc_char;	/* character code */
    long pkc_tfm;	/* TeX font metrics */
    long pkc_dx;	/* Horizontal escapement */
    long pkc_dy;	/* Vertical escapement */
    long pkc_width;	/* character width of BB */
    long pkc_height;	/* character height of BB */
    long pkc_x_off;	/* horizontal offset from upper left pixel to ref. */
    long pkc_y_off;	/* vertical offset from upper left pixel to ref. */
    long turnon;	/* used for unravelling bits */
    long pkc_rlen;	/* actual raster length */
    int8 *pkc_pkr;	/* actual PK raster */
    struct ras *pkc_sfpr;	/* SFP raster */
    struct pkc *pkc_next;	/* next character */
};

struct ras {
    long ras_width;
    long ras_height;
    long ras_bline;
    long ras_bytes;
    long ras_xcur;
    long ras_ycur;
    int8 *ras_raster;
};

#define	pow2(x)	(1L << (x))

#define	OUTRES	300
#endif
