.\"Copyright 1988 by Chris Lewis 2.1 90/07/18
.TH PSROFF 1 local
.SH NAME
psroff,ljroff,xxroff \- troff replacement for PostScript or other printers
.SH SYNOPSIS
.IB xx roff
.BI "[-T" xx "]"
.BI "[-d" ptr "]"
.BI "[-rL" length "]"
.BI "[-P" prologs "]"
.BI "[-D" deb "]"
[-X] [-M] [-F]
.BI "[-R" nn "]"
.BI "[-O" off "]"
.BI "[-Y" off "]"
.BI [ troffopts ]
files ...
.SH DESCRIPTION
.I Psroff
is functionally equivalent for
.I troff
for printing on PostScript or HP Laserjet printers.
.I Troffopts
can be any of the normal
.I troff
arguments, in particular -m directives for specifying macro package.
Note that the semantics of "-t" are changed - it means send the Postscript
(or HP Laserjet) output to stdout rather than the printer.
.P
Most of the options you shouldn't need to use, except for
.IR troffopts ,
and are for special (non-default)
behaviours:
.P
The ``-X'' option does a ``set -x'' for debugging the
.I psroff
shell script.
The ``-Dopts'' option passes the ``-Dopts'' debugging option through to
.IR troff2ps .
The ``-M'' option turns on printer metrics (if supported by the driver).
The ``-P'' options can be specified as many times as you want and are
passed through as special directives to the backend before the output
pages start (see
.IR troff2ps (1L)).
The ``-dptr'' option supplies ``ptr'' as the physical printer destination.
(analogous to ``-d'' in UNIX System V lp).
The ``-Rnn'' option is passed to
.I troff2ps
and will set the resolution of
the generated output (ditroff output only).
The ``-F'' option runs troff without
.RI troff2 xx
so that you can see troff's error messages.
.P
Note that -m directives are parsed by
.I psroff
itself, not
.IR troff ,
and
must be invoked *after* -T if -T is used.
.P
.I Psroff
can be made to generate several different printer output formats.
It selects which one by one of two methods.
First,
.I psroff
looks at the characters prior to "roff" in it's name for printer type.
Thus, you can link "psroff" to "ljroff" - invocation of the latter will
generate LaserJet codes.
Additionally, you can override this by specifying
the
.RI -T xx
option, where
.I xx
will select which printer codes to generate.
.P
As shipped, the
.I psroff
.RI -T xx
understands ``ps'' (postscript), ``tp'' (ditroff->tpscript also postscript),
``jt'' (ditroff->jetroff (HP PCL)),
``lj'' (HP PCL),
and
``dt'' (Ditroff output, no printer).
However, this list may be different at your site - see
the
.I %%LIBDIR%%/lib/psroff.lib
file.
.P
.I Psroff
invokes
.I troff
to do the document formatting, then sends the output
to
.I troff2ps
to do the generation of the correct printer codes.
.P
Since
.I troff2ps
requires that it knows the page length, the "-rL" option should be
used (see the documentation for MM and
.I troff2ps
for more details).
.P
The "-O" option allows you to specify a physical offset from the
left margin of the page.
Normal troff prohibits the total page offset plus line length from
being greater than 7.54 inches, which means that it would be impossible
to centre a 7.54 inch line on 8.5 inch wide paper.
The default -O is .5 inch (specified as .5i), which allows you to
centre a 7.5 inch line with a zero troff offset (.po directive).
The .5 inch default was originally a hardcoded offset in
.IR troff2ps .
The macro adapters have been tuned to centre the default line length
in a 8.5 inch page.
The value for the "-O" option can take any form allowed by the "-rL"
option in
.IR troffps .
This is not implemented as "-rO", because troff itself isn't supposed
to know about it.
The real line offset on a sheet of paper is the sum of the -O and
troff page offset (.po directive).
.P
The "-Y" option allows you to specify a vertical page offset,
similar to "-O" for horizontal.
.SH MACROS
Included with the
.I psroff
package is a set of macros called
.IR tmac.t2 .
This is a set of extensions to and definitions for MM that we find useful.
.P
.I psroff
comes with a series of macro adapters designed to make it work
with the least amount of grief with various macro packages.
In order for this to work, whenever you specify the
.BI -m macro
option,
.I psroff
attempts to find a set of adapters for the specified macro package.
The search path is as follows:
.BI %%LIBDIR%%/adapters/mac. type /tmac. macro ,
.BI %%LIBDIR%%/adapters/tmac. macro ,
and finally
.BI %%RTMACDIR%%/tmac. macro .
Where
.I type
is the printer type (eg: ``ps'') and
.I macro
is the macros you requested (eg: ``m'' for a request of ``-mm'').
Only the first
.BR tmac. macro
file found is used.
.P
The first two directories can contain files with something of the following
form:
.nf
\&.so %%LIBDIR%%/adapters/common.pre
macro specific prolog customization if necessary
\&.so <real macro package>
macro specific epilog customization if necessary
\&.so %%LIBDIR%%/adapters/common.post
.fi
.P
The intent is for
.BI adapters/mac. type /tmac. macro
files to be adapters where the modifications have to be based on
printer type,
and
.BI adapters/tmac. macro
where the modifications are independent of the printer type.
.P
.IR Psroff,
as shipped comes with only printer independent adapters which have
the following customizations in
.BR common.pre :
turn off ligatures,
reload R, I, B, S font width tables,
define ``.sR'' macro,
and redefine ``.fp" directive to call both the built-in troff function ``.fp''
and ``.sR''.
.B common.post
merely contains a disabling of ligatures (again).
The macro-specific customization (as present) is simply the removal of
cut marks.
.SH FILES
.if t .ta 2.5i
.if n .ta 3.5i
%%LIBDIR%%	Troff2ps library directory
.br
%%LIBDIR%%/adapters/mac.*	printer specific macro adapter directories
.br
%%LIBDIR%%/adapters/tmac.*	non-printer-specific macro adapters
.br
%%LIBDIR%%/lib/psroff.lib	shell script configuration
.br
%%LIBDIR%%/lib/*	configuration files and default inclusions.
etc.
.SH "BUGS and FEATURES"
Old-fashioned CAT troff doesn't have a mechanism for passing arbitrary
commands to the CAT - eg: overlays, and physical font mounting etc.
In order to support these things, a macro ".sR" was invented that
passes special directives to the back end by means of a magic pseudo
CAT code 'M', followed by an ASCII string containing the directive.
Unfortunately, the only way to get that to the back end from troff
that I have found so far is to embed the 'M<string>' in a ``.tm'' troff
directive.
The ``.tm'' puts it's string to stderr, so psroff has been modified to
merge the stdout (CAT codes using -t option to troff) and stderr (.tm
directives) together.
.P
Unfortunately, this means that you don't get to see troff-generated
errors except possibly as "illegal flash" errors from
.IR troff2ps ,
or varying
degrees of extreme garbage on the printer.
If you encounter mangled output, try running
psroff, with the ``-F'' option.
Then you will see troff's stderr.
.P
The troff primitive ".tm" is renamed to ".tM" when using one of the
supplied macro adapters.
".tm" is now a macro which calls ".tM" with the appropriate arguments
to pass the string straight through the stderr of
.IR troff2ps .
Hence, traditional index macro handling and macro package errors will
be visible on the stderr of psroff.
.P
Another idiosyncrasy with MM is that if any ".sR" command is invoked
before use of the ".MT" macro, the ".MT" macro will not work correctly.
(this includes ".fp"!).
This is why the
.B -P
option was invented.
.SH "SEE ALSO"
troff(1), troff2ps(1L), mm(7?), cat(5L).
.SH AUTHOR
Written by Chris Lewis
